/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.util.ISVUtil;
import kd.occ.ocepfp.core.form.view.parser.PageViewBuilder;
import kd.occ.ocepfp.core.service.view.ExtViewServiceHelper;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class JfsXMLLoader {
    protected static Log logger = LogFactory.getLog(JfsXMLLoader.class);
    private static ConcurrentMap<String, Boolean> INITIALIZED = new ConcurrentHashMap<String, Boolean>(10);

    public static final void initAllXML(ExtWebContext webContxt) {
        Boolean initialized = (Boolean)INITIALIZED.get(RequestContext.get().getAccountId());
        if (initialized == null || !initialized.booleanValue()) {
            if (ISVUtil.isDevelopmentEnv()) {
                INITIALIZED.put(RequestContext.get().getAccountId(), true);
                return;
            }
            logger.info("InitJFSXML....begin:" + RequestContext.get().getAccountId());
            Set<String> jsfXMLUrls = JfsXMLLoader.loadAllXML(webContxt);
            List<String> modifiedViewList = JfsXMLLoader.checkAndUpdateModifiedXML(webContxt, jsfXMLUrls);
            try {
                PageViewBuilder.rebuildPageView(webContxt, modifiedViewList);
            }
            catch (IllegalAccessException | InstantiationException | DocumentException e) {
                logger.error(e.getMessage(), e);
            }
            INITIALIZED.put(RequestContext.get().getAccountId(), true);
            logger.info("InitJFSXML....end:" + RequestContext.get().getAccountId());
        }
    }

    private static final Set<String> loadAllXML(ExtWebContext webContxt) {
        HashSet<String> jsfXMLUrls = new HashSet<String>(10);
        try {
            Enumeration<URL> urls = JfsXMLLoader.class.getClassLoader().getResources("JfsView");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                jsfXMLUrls.addAll(JfsXMLLoader.getXMLFileByRootPath(url));
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return jsfXMLUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> checkAndUpdateModifiedXML(ExtWebContext webContxt, Set<String> jsfXMLUrls) {
        ClassLoader classLoader = JfsXMLLoader.class.getClassLoader();
        Iterator<String> iterator = jsfXMLUrls.iterator();
        Map<String, Long> oldJsfVersions = ExtViewServiceHelper.getAllViewVersions();
        Document newDocument = null;
        ArrayList<String> modifiedList = new ArrayList<String>(10);
        while (iterator.hasNext()) {
            String fileName = iterator.next();
            InputStream is = classLoader.getResourceAsStream(fileName);
            logger.info("CheckUpdateJFS:" + fileName + ": hasContent:" + (is != null));
            try {
                String viewKey;
                if (is == null || !JfsXMLLoader.checkUpdated(oldJsfVersions, viewKey = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.indexOf(".")).toLowerCase(), newDocument = new SAXReader().read(is))) continue;
                ExtViewServiceHelper.saveView(webContxt, viewKey, newDocument);
                modifiedList.add(viewKey);
            }
            catch (DocumentException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return modifiedList;
    }

    private static final boolean checkUpdated(Map<String, Long> oldJsfVersions, String viewKey, Document document) {
        Element element = document.getRootElement();
        String newVersion = element.attributeValue("version");
        newVersion = StringUtil.isNotNull((String)newVersion) ? newVersion : "0";
        Long oldVersion = oldJsfVersions.get(viewKey);
        logger.info("checkUpdated:" + viewKey + ": newVersion:" + newVersion + ",oldVersion=" + oldVersion);
        return StringUtil.isNull((String)newVersion) || oldVersion == null || !newVersion.equalsIgnoreCase(oldVersion.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set<String> getXMLFileByRootPath(URL url) {
        ZipFile jarFile = null;
        HashSet<String> urls = new HashSet<String>(10);
        try {
            URLConnection con = url.openConnection();
            if (con instanceof JarURLConnection) {
                JarURLConnection jarCon = (JarURLConnection)con;
                jarFile = jarCon.getJarFile();
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryPath = entry.getName();
                    if (!entryPath.toLowerCase(Locale.ENGLISH).startsWith("jfsview") || !entryPath.endsWith(".xml")) continue;
                    urls.add(entryPath);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return urls;
    }
}

