/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.occ.ocepfp.common.entity.ExtView;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.view.parser.JFSBase;
import kd.occ.ocepfp.core.service.view.ExtViewServiceHelper;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class JfsXMLMerger
extends JFSBase {
    private ExtWebContext webCtx;
    private String mainViewKey;
    private String appendId;
    private Map<String, Element> allExistElement;
    private boolean mergeBeforeAppendId = false;
    private boolean mergeEndAppendId = false;
    private Document mainDocument;

    public static final JfsXMLMerger getJFSFileMerger(ExtWebContext webCtx, String mainViewKey, String appendId, boolean mergeBeforeAppendId, boolean mergeEndAppendId) {
        JfsXMLMerger jfsFileMerger = new JfsXMLMerger();
        jfsFileMerger.webCtx = webCtx;
        jfsFileMerger.mainViewKey = mainViewKey;
        jfsFileMerger.appendId = appendId;
        jfsFileMerger.allExistElement = new HashMap<String, Element>();
        jfsFileMerger.mergeBeforeAppendId = mergeBeforeAppendId;
        jfsFileMerger.mergeEndAppendId = mergeEndAppendId;
        return jfsFileMerger;
    }

    public static final JfsXMLMerger getJFSFileMerger(ExtWebContext webCtx, String mainViewKey, String appendId) {
        return JfsXMLMerger.getJFSFileMerger(webCtx, mainViewKey, appendId, false, false);
    }

    public static final JfsXMLMerger getJFSFileMerger(ExtWebContext webCtx, String mainViewKey, String appendId, String fromdb) {
        JfsXMLMerger merger = JfsXMLMerger.getJFSFileMerger(webCtx, mainViewKey, appendId, false, false);
        return merger;
    }

    public final Document merge() throws DocumentException, InstantiationException, IllegalAccessException {
        if (this.mainViewKey == null) {
            return null;
        }
        ExtView extView = ExtViewServiceHelper.getView(this.webCtx, this.mainViewKey);
        if (extView == null) {
            LogUtil.error(JfsXMLMerger.class, (String)("JfsEditor Merge:\u672a\u627e\u5230XML\u6587\u4ef6" + this.mainViewKey), null);
            return null;
        }
        this.mainDocument = DocumentHelper.createDocument();
        this.mainDocument.addElement("pageview");
        this.allExistElement.put("pageview_", this.mainDocument.getRootElement());
        this.merge(this.mainViewKey, this.appendId, extView.getDetail(), false);
        return this.mainDocument;
    }

    private final void merge(String mainViewKey, String appendId, Document mainDocument, boolean isExtendBaseView) throws DocumentException, InstantiationException, IllegalAccessException {
        List<ExtView> appendViews;
        Element root = mainDocument.getRootElement();
        String extend = Convert.toString((String)root.attributeValue("extend"));
        if (StringUtil.isNotNull((String)extend)) {
            ExtView extView = ExtViewServiceHelper.getView(this.webCtx, extend);
            this.merge(extend, "", extView.getDetail(), true);
            Element mainRoot = this.mainDocument.getRootElement();
            Attribute append = mainRoot.attribute("append");
            if (append != null) {
                mainRoot.remove(append);
            }
        }
        this.readAllElement(root, "", "");
        if (StringUtil.isNotNull((String)appendId) && (appendViews = ExtViewServiceHelper.getAppendViewByMainKey(this.webCtx, mainViewKey)).size() > 0) {
            for (ExtView appendView : appendViews) {
                if (this.mergeBeforeAppendId && appendView.getViewKey().equalsIgnoreCase(appendId)) break;
                if (appendView.getDetail() != null) {
                    this.readAllElement(appendView.getDetail().getRootElement(), "", "");
                }
                if (!this.mergeEndAppendId || !appendView.getViewKey().equalsIgnoreCase(appendId)) continue;
                break;
            }
        }
    }

    private final Document readAllElement(Element parentElement, String parentName, String rootName) {
        if (parentElement.isRootElement()) {
            JfsXMLMerger.updateAttribute(parentElement, this.mainDocument.getRootElement());
        }
        Iterator node = parentElement.elementIterator();
        Element newElement = null;
        if (StringUtil.isNull((String)parentName)) {
            parentName = this.getId(parentElement, "").toLowerCase();
        }
        if (StringUtil.isNull((String)rootName) && parentName.equalsIgnoreCase("operations")) {
            rootName = parentName;
        }
        while (node.hasNext()) {
            Element sourceElement = (Element)node.next();
            String id = rootName + this.getId(sourceElement, parentName).toLowerCase();
            if (this.allExistElement.containsKey(id)) {
                JfsXMLMerger.updateAttribute(sourceElement, this.allExistElement.get(id));
                newElement = this.allExistElement.get(id);
            } else if (this.allExistElement.containsKey(parentName)) {
                newElement = JfsXMLMerger.copyElement(this.allExistElement.get(parentName), sourceElement);
            } else {
                this.mainDocument.add(sourceElement);
            }
            this.allExistElement.put(id, newElement);
            if (sourceElement.nodeCount() <= 0) continue;
            this.readAllElement(sourceElement, id, rootName);
        }
        return this.mainDocument;
    }

    private static final void updateAttribute(Element sourceElement, Element targetElement) {
        Iterator attributes = sourceElement.attributeIterator();
        while (attributes.hasNext()) {
            Attribute attribute = (Attribute)attributes.next();
            targetElement.addAttribute(attribute.getName(), attribute.getValue());
        }
        if (StringUtil.isNotNull((String)sourceElement.getText()) || StringUtil.isNotNull((String)targetElement.getText())) {
            String text = sourceElement.getText();
            targetElement.setText("");
            targetElement.addCDATA(text);
        }
    }

    private static final Element copyElement(Element parentElement, Element sourceElement) {
        Element newElement = parentElement.addElement(sourceElement.getName());
        JfsXMLMerger.updateAttribute(sourceElement, newElement);
        return newElement;
    }
}

