/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.parser;

import java.util.List;
import kd.occ.ocepfp.common.constant.BillViewType;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.ControlFactory;
import kd.occ.ocepfp.core.form.control.controls.DefaultFilter;
import kd.occ.ocepfp.core.form.control.controls.MoreFilter;
import kd.occ.ocepfp.core.form.control.controls.Option;
import kd.occ.ocepfp.core.form.control.controls.QueryFilter;
import kd.occ.ocepfp.core.form.control.controls.Select;
import kd.occ.ocepfp.core.form.control.controls.SelectData;
import kd.occ.ocepfp.core.form.control.controls.Text;
import kd.occ.ocepfp.core.form.view.base.ViewFactory;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.metadata.Field;

public class ListViewQueryFilterAutoBuilder {
    protected static void createQueryFilterFromBill(ExtWebContext webCtx, PageView pageView) {
        if (!BillViewType.ListView.getValue().equalsIgnoreCase(pageView.getBillViewType())) {
            return;
        }
        if (StringUtil.isNotNull((String)pageView.getPageBody().getFilterId())) {
            QueryFilter filter = (QueryFilter)pageView.getPageBody().getControl(pageView.getPageBody().getFilterId());
            if (filter.getDefaultFilter() == null) {
                ListViewQueryFilterAutoBuilder.createDefaultQueryFilter(webCtx, filter, pageView);
            }
            if (filter.getMoreFilter() == null) {
                ListViewQueryFilterAutoBuilder.createMoreQueryFilter(webCtx, filter, pageView);
            }
        }
    }

    private static void createDefaultQueryFilter(ExtWebContext webCtx, QueryFilter filter, PageView pageView) {
        DefaultFilter defaultFilter = new DefaultFilter();
        Text text = new Text();
        text.setId("q_default");
        text.setPlaceHolder("\u7f16\u7801/\u540d\u79f0");
        text.setORM("number,name");
        filter.addChild(defaultFilter, pageView.getPageBody());
        defaultFilter.addChild(text, pageView.getPageBody());
    }

    private static void createMoreQueryFilter(ExtWebContext webCtx, QueryFilter filter, PageView pageView) {
        PageView billPageView;
        List<Field> fieldList = null;
        int max = 10;
        if (StringUtil.isNotNull((String)pageView.getBaseViewId()) && (billPageView = ViewFactory.get(webCtx, pageView.getBaseViewId())) != null) {
            fieldList = billPageView.getMetadata().getListSearchField();
            if (fieldList.size() > 0) {
                max = Integer.MAX_VALUE;
            } else {
                fieldList = billPageView.getMetadata().getFieldList();
            }
        }
        if (fieldList == null) {
            fieldList = pageView.getMetadata().getFieldList();
        }
        MoreFilter moreFilter = ListViewQueryFilterAutoBuilder.createMoreQueryFilter(fieldList, max);
        filter.addChild(moreFilter, pageView.getPageBody());
    }

    private static MoreFilter createMoreQueryFilter(List<Field> fieldList, int max) {
        MoreFilter moreFilter = new MoreFilter();
        if (fieldList == null) {
            return moreFilter;
        }
        String nodeName = null;
        for (Field field : fieldList) {
            nodeName = field.getNodeName().equalsIgnoreCase("MultiLanguageText") ? "text" : field.getNodeName();
            Control control = ListViewQueryFilterAutoBuilder.isDateField(field.getFieldType()) ? ListViewQueryFilterAutoBuilder.createQueryFilterDate(nodeName, field) : (Control)ControlFactory.getControlFace(nodeName).getControlInstance();
            if (control != null) {
                control.setId("q_" + field.getId());
                control.setName(field.getName());
                control.setORM(field.getId());
                if (field.isF7()) {
                    ((SelectData)control).setBaseViewId(StringUtil.isNotNull((String)field.getBaseListViewId()) ? field.getBaseListViewId() : field.getBaseViewId());
                }
                moreFilter.addChild(control);
            }
            if (moreFilter.getChilds().size() < max) continue;
            break;
        }
        return moreFilter;
    }

    private static final boolean isDateField(String controlType) {
        return controlType.equalsIgnoreCase("Date") || controlType.equalsIgnoreCase("CreateDate") || controlType.equalsIgnoreCase("DateTime") || controlType.equalsIgnoreCase("ModifyDate");
    }

    private static Control createQueryFilterDate(String nodeName, Field field) {
        Select dateSelect = new Select();
        dateSelect.addChild(ListViewQueryFilterAutoBuilder.createOption("q_" + field.getId() + "_thisweek", "\u672c\u5468", "thisweek", "thisweek"));
        dateSelect.addChild(ListViewQueryFilterAutoBuilder.createOption("q_" + field.getId() + "_thismonth", "\u672c\u6708", "thismonth", "thismonth"));
        dateSelect.addChild(ListViewQueryFilterAutoBuilder.createOption("q_" + field.getId() + "_threemonth", "\u4e09\u6708\u5185", "threemonth", "threemonth"));
        dateSelect.addChild(ListViewQueryFilterAutoBuilder.createOption("q_" + field.getId() + "_customdate", "\u81ea\u5b9a\u4e49", "customdate", "customdate"));
        return dateSelect;
    }

    private static Option createOption(String id, String name, String value, String iservice) {
        Option o = new Option();
        o.setId(id);
        o.setName(name);
        o.setValue(value);
        o.put("iservice", iservice);
        return o;
    }
}

