/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.parser;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.occ.ocepfp.common.entity.CaseInsensitiveKeysMap;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.formula.Formula;
import kd.occ.ocepfp.core.form.view.parser.XmlSerial;

public class PageBody {
    private Map<String, Control> controlElements = new LinkedHashMap<String, Control>();
    private List<String> dataGridIds = new ArrayList<String>(2);
    private String firstDataGridId = null;
    private String filterId;
    private String billViewType;
    private List<Formula> formulaList = new ArrayList<Formula>(2);
    protected String mainToolbarId = "";
    private List<String> disbaleFieldIdList = new ArrayList<String>(10);
    private List<String> hiddenFieldIdList = new ArrayList<String>(10);
    private Map<String, List<String>> linkCurrencyFormatDataMap = new HashMap<String, List<String>>(4);
    private Map<String, List<String>> linkUnitFormatDataMap = new HashMap<String, List<String>>(4);
    private String billStatusField;
    private List<String> autoSetValueFields = new ArrayList<String>(6);
    protected boolean hasAppend = false;

    public void addControl(Control control) {
        this.addControlElement(control);
    }

    @JsonIgnore
    public final <T> T getControl(String id) {
        CaseInsensitiveKeysMap<Control> element = this.getElement();
        return (T)element.get((Object)id.toLowerCase());
    }

    @JsonIgnore
    public <T> T getControl(String id, Map<String, Control> dynamicElements) {
        CaseInsensitiveKeysMap element = new CaseInsensitiveKeysMap(60);
        Object t = null;
        if (dynamicElements != null && dynamicElements.size() > 0) {
            element.putAll(this.getDynamicElement(dynamicElements));
            t = element.get((Object)id.toLowerCase());
            if (t != null) {
                return (T)t;
            }
        }
        element.putAll(this.getElement());
        return (T)element.get((Object)id.toLowerCase());
    }

    @JsonIgnore
    public <T> T getDependControl(String id) {
        Control control = (Control)this.getControl(id);
        if (control != null && StringUtil.isNotNull((String)control.getDepend())) {
            control = (Control)this.getControl(control.getDepend());
        }
        return (T)control;
    }

    @JsonIgnore
    public <T> T getControl(String id, Class<T> valueType) {
        T t = this.getControl(id);
        if (t == null) {
            try {
                t = valueType.newInstance();
                ((Control)t).setId(id);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LogUtil.error(PageBody.class, (String)e.getMessage(), (Throwable)e);
            }
        }
        return t;
    }

    public void addDataGrids(String dataGridId) {
        if (this.firstDataGridId == null) {
            this.firstDataGridId = dataGridId;
        }
        if (!this.dataGridIds.contains(dataGridId)) {
            this.dataGridIds.add(dataGridId);
        }
    }

    public String getFirstDataGridId() {
        return this.firstDataGridId;
    }

    public List<String> getDataGridIds() {
        return this.dataGridIds;
    }

    public void addControlElement(Control control) {
        this.controlElements.put(control.getId().toLowerCase(), control);
    }

    @JsonIgnore
    public Map<String, Control> getTopElement() {
        return this.controlElements;
    }

    public Map<String, Control> getControlElements() {
        return this.controlElements;
    }

    public void setControlElements(Map<String, Control> controlElements) {
        this.controlElements = controlElements;
    }

    public void setDataGridIds(List<String> dataGridIds) {
        this.dataGridIds = dataGridIds;
    }

    public void setFirstDataGridId(String firstDataGridId) {
        this.firstDataGridId = firstDataGridId;
    }

    @JsonIgnore
    public Map<String, Map> getFormElement() {
        HashMap<String, Map> formElement = new HashMap<String, Map>();
        CaseInsensitiveKeysMap<Control> element = this.getElement();
        for (Map.Entry entry : element.entrySet()) {
            Control control = (Control)entry.getValue();
            if (!control.getElementType().equals("form") || control.getParentControl() != null && !control.getParentControl().getElementType().equalsIgnoreCase("layout")) continue;
            HashMap<String, String> d = new HashMap<String, String>();
            d.put("type", control.getType());
            d.put("name", control.getOriginalName());
            formElement.put(control.getId(), d);
        }
        return formElement;
    }

    @JsonIgnore
    public CaseInsensitiveKeysMap<Control> getElement() {
        CaseInsensitiveKeysMap element = new CaseInsensitiveKeysMap();
        this.getElement((CaseInsensitiveKeysMap<Control>)element, this.controlElements);
        return element;
    }

    @JsonIgnore
    public CaseInsensitiveKeysMap<Control> getDynamicElement(Map<String, Control> dynamicElements) {
        CaseInsensitiveKeysMap element = new CaseInsensitiveKeysMap();
        this.getElement((CaseInsensitiveKeysMap<Control>)element, dynamicElements);
        return element;
    }

    @JsonIgnore
    private void getElement(CaseInsensitiveKeysMap<Control> element, Map<String, Control> control) {
        for (Map.Entry<String, Control> entry : control.entrySet()) {
            if (entry.getValue().hasChild()) {
                this.getElement(element, ((XmlSerial)((Object)entry.getValue())).getElement());
            }
            element.put(entry.getKey(), (Object)entry.getValue());
        }
    }

    public String getFilterId() {
        return this.filterId;
    }

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    public String getBillViewType() {
        return this.billViewType;
    }

    public void setBillViewType(String billViewType) {
        this.billViewType = billViewType;
    }

    public List<Formula> getFormulaList() {
        return this.formulaList;
    }

    public void setFormulaList(List<Formula> formulaList) {
        this.formulaList = formulaList;
    }

    public void addFormula(Formula formula) {
        this.formulaList.add(formula);
    }

    protected String getMainToolbarId() {
        return this.mainToolbarId;
    }

    protected void setMainToolbarId(String mainToolbarId) {
        this.mainToolbarId = mainToolbarId;
    }

    public List<String> getDisbaleFieldIdList() {
        return this.disbaleFieldIdList;
    }

    public void setDisbaleFieldIdList(List<String> disbaleFieldIdList) {
        this.disbaleFieldIdList = disbaleFieldIdList;
    }

    public String getBillStatusField() {
        return this.billStatusField;
    }

    public void setBillStatusField(String billStatusField) {
        this.billStatusField = billStatusField;
    }

    public List<String> getAutoSetValueFields() {
        return this.autoSetValueFields;
    }

    public void setAutoSetValueFields(List<String> autoSetValueFields) {
        this.autoSetValueFields = autoSetValueFields;
    }

    public List<String> getHiddenFieldIdList() {
        return this.hiddenFieldIdList;
    }

    public void setHiddenFieldIdList(List<String> hiddenFieldIdList) {
        this.hiddenFieldIdList = hiddenFieldIdList;
    }

    public void addLinkCurrencyFormatField(String id, String formatFieldId) {
        formatFieldId = formatFieldId.toLowerCase();
        id = id.toLowerCase();
        List<String> formtFieldList = this.linkCurrencyFormatDataMap.get(formatFieldId);
        if (formtFieldList == null) {
            formtFieldList = new ArrayList<String>(10);
            this.linkCurrencyFormatDataMap.put(formatFieldId, formtFieldList);
        }
        formtFieldList.add(id);
    }

    public Map<String, List<String>> getLinkCurrencyFormatDataMap() {
        return this.linkCurrencyFormatDataMap;
    }

    public void setLinkCurrencyFormatDataMap(Map<String, List<String>> linkCurrencyFormatDataMap) {
        this.linkCurrencyFormatDataMap = linkCurrencyFormatDataMap;
    }

    public List<String> getLinkedCurrencyFormatField(String formatFieldId) {
        return this.linkCurrencyFormatDataMap.get(formatFieldId);
    }

    public void addLinkUnitFormatField(String id, String formatFieldId) {
        formatFieldId = formatFieldId.toLowerCase();
        id = id.toLowerCase();
        List<String> formtFieldList = this.linkUnitFormatDataMap.get(formatFieldId);
        if (formtFieldList == null) {
            formtFieldList = new ArrayList<String>(10);
            this.linkUnitFormatDataMap.put(formatFieldId, formtFieldList);
        }
        formtFieldList.add(id);
    }

    public Map<String, List<String>> getLinkUnitFormatDataMap() {
        return this.linkUnitFormatDataMap;
    }

    public void setLinkUnitFormatDataMap(Map<String, List<String>> linkUnitFormatDataMap) {
        this.linkUnitFormatDataMap = linkUnitFormatDataMap;
    }

    public List<String> getLinkedUnitFormatField(String formatFieldId) {
        return this.linkUnitFormatDataMap.get(formatFieldId);
    }

    @JsonIgnore
    public boolean isHasAppend() {
        return this.hasAppend;
    }

    @JsonIgnore
    public void setHasAppend(boolean hasAppend) {
        this.hasAppend = hasAppend;
    }
}

