/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.parser;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.occ.ocepfp.common.constant.BillViewType;
import kd.occ.ocepfp.common.entity.CaseInsensitiveKeysMap;
import kd.occ.ocepfp.common.entity.ExtView;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.ControlFactory;
import kd.occ.ocepfp.core.form.control.controls.BillStatus;
import kd.occ.ocepfp.core.form.control.controls.DataGrid;
import kd.occ.ocepfp.core.form.control.controls.Global;
import kd.occ.ocepfp.core.form.control.controls.Html;
import kd.occ.ocepfp.core.form.control.controls.MenuButtonGroup;
import kd.occ.ocepfp.core.form.control.controls.Operation;
import kd.occ.ocepfp.core.form.control.controls.Plugin;
import kd.occ.ocepfp.core.form.control.controls.Price;
import kd.occ.ocepfp.core.form.control.controls.Qty;
import kd.occ.ocepfp.core.form.control.controls.Spu;
import kd.occ.ocepfp.core.form.control.controls.ToolBar;
import kd.occ.ocepfp.core.form.formula.Formula;
import kd.occ.ocepfp.core.form.formula.FormulaParser;
import kd.occ.ocepfp.core.form.view.base.ViewFactory;
import kd.occ.ocepfp.core.form.view.parser.ListViewQueryFilterAutoBuilder;
import kd.occ.ocepfp.core.form.view.parser.PageBody;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.form.view.parser.PageViewCache;
import kd.occ.ocepfp.core.form.view.parser.XmlSerial;
import kd.occ.ocepfp.core.metadata.Metadata;
import kd.occ.ocepfp.core.metadata.MetadataBuilder;
import kd.occ.ocepfp.core.orm.OrmBuilder;
import kd.occ.ocepfp.core.service.view.ExtViewServiceHelper;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class PageViewBuilder {
    public static final PageView getPageView(ExtWebContext webCtx, String viewKey) throws InstantiationException, IllegalAccessException, DocumentException {
        return PageViewBuilder.getPageView(webCtx, viewKey, true);
    }

    public static final PageView getPageView(ExtWebContext webCtx, String viewKey, boolean buildMetadata) throws InstantiationException, IllegalAccessException, DocumentException {
        PageView pageView = PageViewCache.getPageView(webCtx, viewKey);
        if (!buildMetadata || pageView == null) {
            return pageView;
        }
        if (pageView.getMetadata() == null) {
            pageView.setMetadata(MetadataBuilder.build(webCtx, pageView));
        }
        return pageView;
    }

    public static final void rebuildPageView(ExtWebContext webCtx, String viewKey) throws DocumentException, InstantiationException, IllegalAccessException {
        PageViewBuilder.buildPageView(webCtx, viewKey);
        List<String> affectedViews = ExtViewServiceHelper.getAllAffectedViews(viewKey);
        for (String affectedViewKey : affectedViews) {
            PageViewBuilder.buildPageView(webCtx, affectedViewKey);
        }
    }

    public static final void rebuildPageView(ExtWebContext webCtx, List<String> viewKeys) throws DocumentException, InstantiationException, IllegalAccessException {
        List<String> affectedViews = ExtViewServiceHelper.getAllAffectedViews(viewKeys);
        viewKeys.removeAll(affectedViews);
        viewKeys.addAll(affectedViews);
        for (String viewKey : viewKeys) {
            PageViewBuilder.buildPageView(webCtx, viewKey);
        }
    }

    public static final PageView buildPageView(ExtWebContext webCtx, String viewKey) throws DocumentException, InstantiationException, IllegalAccessException {
        PageView pageView = PageViewBuilder.buildPageView(webCtx, viewKey, null, null);
        if (pageView == null) {
            return null;
        }
        pageView.setRebuildCloudMetadata(true);
        PageViewBuilder.initRelatedOrm(pageView);
        pageView.setMetadata(MetadataBuilder.build(webCtx, pageView));
        PageViewBuilder.setSubEntry(webCtx, pageView);
        PageViewBuilder.setListViewId2BillView(webCtx, pageView);
        ListViewQueryFilterAutoBuilder.createQueryFilterFromBill(webCtx, pageView);
        PageViewCache.putPageView(webCtx, viewKey, pageView);
        if (pageView.getMetadata() != null && pageView.isRebuildCloudMetadata()) {
            OrmBuilder.buildMetadata(pageView, pageView.getVersion());
        }
        return pageView;
    }

    public static final PageView buildPageView(ExtWebContext webCtx, String viewKey, PageView pageView, ExtView appendView) throws DocumentException, InstantiationException, IllegalAccessException {
        List<ExtView> appendList;
        ExtView extMajorView = null;
        Element root = null;
        String version = "";
        if (pageView == null) {
            pageView = new PageView(viewKey);
        }
        if (viewKey != null) {
            extMajorView = ExtViewServiceHelper.getView(webCtx, viewKey);
            if (extMajorView == null) {
                return null;
            }
            Document document = extMajorView.getDetail();
            root = document.getRootElement();
            version = extMajorView.getVersion();
        } else if (appendView != null) {
            root = appendView.getDetail().getRootElement();
            version = appendView.getVersion();
        }
        if (version.compareTo(pageView.getVersion()) > 0) {
            pageView.setVersion(version);
        }
        if (root != null) {
            if (!StringUtil.isNull((String)root.attributeValue("extend"))) {
                PageViewBuilder.buildPageView(webCtx, root.attributeValue("extend"), pageView, null);
            }
            Iterator node = root.elementIterator();
            while (node.hasNext()) {
                String elementName;
                Element element = (Element)node.next();
                switch (elementName = element.getName().toLowerCase()) {
                    case "operations": {
                        PageViewBuilder.addOperations(element, pageView);
                        break;
                    }
                    case "view": {
                        PageViewBuilder.addChild(webCtx, element, (Object)pageView, pageView.getPageBody(), pageView.getMetadata());
                        break;
                    }
                    case "global": {
                        PageViewBuilder.addGlobal(element, pageView.getGlobal());
                        break;
                    }
                }
            }
        }
        if (StringUtil.isNotNull((String)viewKey) && root != null && pageView != null) {
            pageView = PageViewBuilder.toPageView(viewKey, root, pageView);
        }
        if (extMajorView != null && (appendList = ExtViewServiceHelper.getAppendViewByMainKey(webCtx, viewKey)) != null && appendList.size() > 0) {
            pageView.getPageBody().setHasAppend(true);
            for (ExtView loadAppendView : appendList) {
                PageViewBuilder.setPageViewProp(pageView, loadAppendView.getDetail().getRootElement(), true);
                PageViewBuilder.buildPageView(webCtx, null, pageView, loadAppendView);
            }
        }
        return pageView;
    }

    private static void addGlobal(Element parentXmlElement, Global global) {
        Iterator node = parentXmlElement.elementIterator();
        while (node.hasNext()) {
            Element element = (Element)node.next();
            String nodeName = element.getName().toLowerCase();
            Control c = (Control)ControlFactory.getControlFace(nodeName).getControlInstance();
            PageViewBuilder.attributeConvert(element, c);
            global.addChild(c, null);
        }
    }

    private static void addChild(ExtWebContext extCtx, Element parentXmlElement, Object parentControl, PageBody pageBody, Metadata metadata) throws InstantiationException, IllegalAccessException {
        boolean isUpdate = false;
        Iterator node = parentXmlElement.elementIterator();
        while (node.hasNext()) {
            Qty qty;
            Object nodeClassInstance;
            Element element = (Element)node.next();
            String nodeName = element.getName().toLowerCase();
            String nodeId = PageViewBuilder.getNodeId(element, parentControl);
            boolean bl = isUpdate = !StringUtil.isNull((String)nodeId) && pageBody.getControl(nodeId) != null;
            if (isUpdate) {
                nodeClassInstance = pageBody.getControl(nodeId);
            } else {
                if (ControlFactory.getControlFace(nodeName) == null) continue;
                nodeClassInstance = ControlFactory.getControlFace(nodeName).getControlInstance();
            }
            PageViewBuilder.attributeConvert(element, nodeClassInstance);
            Control control = (Control)nodeClassInstance;
            String ov = control.getDisable();
            if (StringUtil.isNotNull((String)ov) && !ov.equals("true") && !ov.equals("false")) {
                pageBody.getDisbaleFieldIdList().add(control.getId());
            }
            if (StringUtil.isNotNull((String)(ov = control.getHidden())) && !ov.equals("true") && !ov.equals("false")) {
                pageBody.getHiddenFieldIdList().add(control.getId());
            }
            if ("CreateDate".equals(control.getType()) || "Creator".equals(control.getType()) || "Modifier".equals(control.getType()) || "ModifyDate".equals(control.getType())) {
                pageBody.getAutoSetValueFields().add(control.getId());
            }
            if (control.getType().equals("DataGrid")) {
                control.put("_billtype", pageBody.getBillViewType());
            } else if (control.getType().equalsIgnoreCase("QueryFilter") && StringUtil.isNull((String)pageBody.getFilterId())) {
                pageBody.setFilterId(nodeId);
            } else if (control.getType().equals("BillStatus") && ((BillStatus)control).isMain()) {
                pageBody.setBillStatusField(control.getId());
            }
            if (StringUtil.isNull((String)control.getId())) {
                control.setId(nodeId);
            }
            if (control.getType().equals("Price") || control.getType().equals("Amount")) {
                Price price = (Price)control;
                if (StringUtil.isNotNull((String)price.getCurrency())) {
                    pageBody.addLinkCurrencyFormatField(control.getId(), price.getCurrency());
                }
            } else if (control.getType().equals("Qty") && StringUtil.isNotNull((String)(qty = (Qty)control).getUnit())) {
                pageBody.addLinkUnitFormatField(control.getId(), qty.getUnit());
            }
            PageViewBuilder.buildFormula(control, pageBody);
            if (!isUpdate) {
                if (parentXmlElement.getName().equalsIgnoreCase("view") || parentXmlElement.getName().equalsIgnoreCase("operations")) {
                    PageView pageView = (PageView)((Object)parentControl);
                    pageView.getPageBody().addControl(control);
                } else {
                    XmlSerial xmlSerial = (XmlSerial)parentControl;
                    xmlSerial.addChild(nodeClassInstance, pageBody);
                }
            }
            if (!element.elementIterator().hasNext()) continue;
            if (element.getName().equalsIgnoreCase("datagrid") || element.getName().equalsIgnoreCase("list") && StringUtil.isNull((String)element.attributeValue("depend"))) {
                pageBody.addDataGrids(StringUtil.toLowerCase((String)element.attributeValue("id")));
            } else if (element.getName().equalsIgnoreCase("toolbar") && StringUtil.isNull((String)pageBody.getMainToolbarId())) {
                pageBody.setMainToolbarId(StringUtil.toLowerCase((String)element.attributeValue("id")));
            }
            PageViewBuilder.addChild(extCtx, element, nodeClassInstance, pageBody, null);
        }
    }

    private static void attributeConvert(Element element, Object instance) {
        Control control = (Control)instance;
        control.setXmlNodeName(element.getName());
        Iterator attributes = element.attributeIterator();
        while (attributes.hasNext()) {
            Attribute attribute = (Attribute)attributes.next();
            String name = attribute.getName().toLowerCase();
            if ("name".equals(name)) {
                control.put("originalName", attribute.getData());
            } else if ("id".equalsIgnoreCase(name) || "group".equalsIgnoreCase(name) || "linkorm".equalsIgnoreCase(name)) {
                control.put(attribute.getName().toLowerCase(), attribute.getData().toString().toLowerCase());
                continue;
            }
            control.put(attribute.getName().toLowerCase(), PageViewBuilder.specialAttributeValue(control, attribute.getName(), attribute.getData()));
        }
        if (control.getType().equals("Html")) {
            ((Html)control).setContent(StringUtil.isNull((String)element.getText()) ? "" : element.getText().replaceAll("\r", "").replaceAll("\n", ""));
        } else {
            String format;
            String string = StringUtil.isNotNull((String)element.getText()) ? element.getText().replaceAll("\r", "").replaceAll("\n", "") : (format = StringUtil.isNotNull((String)control.getFormat()) ? control.getFormat() : "");
            if (StringUtil.isNotNull((String)format)) {
                control.setFormat(format);
            }
        }
    }

    private static Object specialAttributeValue(Control control, String name, Object value) {
        if (("disable".equalsIgnoreCase(name) || "hidden".equalsIgnoreCase(name)) && !value.equals("true") && !value.equals("false")) {
            return new StringBuffer(10).append("[").append(value.toString().replaceAll("!", "^")).append("]").toString();
        }
        return value;
    }

    private static String getNodeId(Element element, Object parentControl) {
        String nodeId = element.attributeValue("id");
        if (StringUtil.isNull((String)nodeId) && element.getName().equalsIgnoreCase("fields")) {
            nodeId = ((Control)parentControl).getId() + "fields";
        }
        return nodeId;
    }

    private static final PageView toPageView(String viewKey, Element root, PageView frontPageView) {
        PageViewBuilder.setPageViewProp(frontPageView, root, false);
        return frontPageView;
    }

    private static void setPageViewProp(PageView pageView, Element root, boolean isAppend) {
        Iterator attributes = root.attributeIterator();
        while (attributes.hasNext()) {
            Attribute attribute = (Attribute)attributes.next();
            if (isAppend && attribute.getName().equals("name")) continue;
            pageView.put(attribute.getName().toLowerCase(), attribute.getName().equals("plugin") || attribute.getName().equals("name") ? attribute.getData() : attribute.getData().toString().toLowerCase());
        }
        pageView.getPageBody().setBillViewType(pageView.getBillViewType());
    }

    private static void buildFormula(Control control, PageBody pageBody) {
        if (StringUtil.isNull((String)control.getFormula())) {
            return;
        }
        Formula formula = FormulaParser.build(control.getId(), control.getFormula());
        if (formula == null) {
            return;
        }
        control.setFormulaInstance(formula);
        pageBody.addFormula(formula);
    }

    private static void setListViewId2BillView(ExtWebContext webCtx, PageView pageView) {
        if (pageView.getBillViewType().equalsIgnoreCase(BillViewType.ListView.getValue()) && StringUtil.isNotNull((String)pageView.getBaseViewId()) && !pageView.getViewId().equalsIgnoreCase(pageView.getBaseViewId())) {
            PageView basePageView = ViewFactory.get(webCtx, pageView.getBaseViewId());
            if (basePageView != null && StringUtil.isNull((String)basePageView.getListViewId())) {
                basePageView.put("listviewid", pageView.getViewId());
            }
            PageViewBuilder.setMainDataGrid4Toolbar(pageView);
        }
    }

    private static void setMainDataGrid4Toolbar(PageView pageView) {
        if (StringUtil.isNull((String)pageView.getPageBody().getMainToolbarId())) {
            return;
        }
        ToolBar toolbar = (ToolBar)pageView.getPageBody().getControl(pageView.getPageBody().getMainToolbarId());
        if (toolbar != null) {
            String srcDataGridId = StringUtil.toLowerCase((String)pageView.getPageBody().getFirstDataGridId());
            toolbar.setSrcDataGrid(srcDataGridId);
            List<Control> controls = toolbar.getChilds();
            PageViewBuilder.setToolbarSrcGrid(controls, srcDataGridId);
        }
    }

    private static void setToolbarSrcGrid(List<Control> childs, String srcDataGridId) {
        for (Control control : childs) {
            control.setSrcDataGrid(srcDataGridId);
            if (!control.getType().equals("MenuButtonGroup")) continue;
            PageViewBuilder.setToolbarSrcGrid(((MenuButtonGroup)control).getChilds(), srcDataGridId);
        }
    }

    private static void setSubEntry(ExtWebContext webCtx, PageView pageView) {
        List<String> dataGridList = pageView.getPageBody().getDataGridIds();
        if (dataGridList != null && dataGridList.size() > 0) {
            for (String dataGridId : dataGridList) {
                DataGrid dataGrid = (DataGrid)pageView.getPageBody().getControl(dataGridId);
                if (!StringUtil.isNotNull((String)dataGrid.getParentDataGrid())) continue;
                DataGrid parentGridId = (DataGrid)pageView.getPageBody().getControl(dataGrid.getParentDataGrid());
                parentGridId.setSubDataGrid(dataGrid.getId());
                parentGridId.setRowSelected(true);
            }
        }
    }

    private static void initRelatedOrm(PageView pageView) {
        PageBody pageBody = pageView.getPageBody();
        CaseInsensitiveKeysMap<Control> elements = pageBody.getElement();
        if (elements != null) {
            for (Map.Entry entry : elements.entrySet()) {
                List<String> orms;
                Spu spu;
                String selectDataId;
                Control control = (Control)entry.getValue();
                if (StringUtil.isNotNull((String)control.getLinkORM())) {
                    selectDataId = control.getLinkORM().split("\\.")[0];
                    ((Control)pageBody.getControl(selectDataId)).addRelatedOrm(control.getLinkORM().replaceFirst(selectDataId + ".", ""));
                    ((Control)pageBody.getControl(selectDataId)).addRelatedControl(control.getId());
                }
                if (StringUtil.isNotNull((String)(selectDataId = control.getBaseField()))) {
                    ((Control)pageBody.getControl(selectDataId)).addRelatedBaseField(control.getId());
                }
                if (control.isSpu() && StringUtil.isNotNull((String)(selectDataId = (spu = (Spu)control).getLinkedSkuId()))) {
                    ((Control)pageBody.getControl(selectDataId)).addRelatedSku(control.getId());
                }
                if (!control.isF7() || !StringUtil.isNotNull((String)control.getFormat()) || (orms = control.getFormatOrms()) == null) continue;
                for (String orm : orms) {
                    control.addRelatedOrm(orm);
                }
            }
        }
    }

    private static void addOperations(Element parentElement, PageView pageView) {
        Iterator node = parentElement.elementIterator();
        while (node.hasNext()) {
            Element element = (Element)node.next();
            String nodeName = element.getName().toLowerCase();
            String id = element.attributeValue("id");
            Operation operation = pageView.getOperatios().get(id);
            if (operation == null) {
                operation = (Operation)ControlFactory.getControlFace(nodeName).getControlInstance();
            }
            PageViewBuilder.attributeConvert(element, operation);
            String refreshfield = operation.getString("refreshfield");
            if (StringUtil.isNotNull((String)refreshfield)) {
                operation.getRefreshFields().addAll(Arrays.asList(refreshfield.split(",")));
            }
            Iterator childElementIterator = element.elementIterator();
            while (childElementIterator.hasNext()) {
                element = (Element)childElementIterator.next();
                switch (nodeName = element.getName().toLowerCase()) {
                    case "plugins": {
                        PageViewBuilder.addPlugins(operation, element);
                        break;
                    }
                    case "parameters": {
                        PageViewBuilder.addOperationParameter(operation, element);
                        break;
                    }
                    case "validations": {
                        PageViewBuilder.addValidations(operation, element);
                    }
                }
            }
            pageView.getOperatios().put(operation.getId(), operation);
        }
    }

    private static void addPlugins(Operation operation, Element parentElement) {
        Iterator pluginEIterator = parentElement.elementIterator();
        while (pluginEIterator.hasNext()) {
            Element element = (Element)pluginEIterator.next();
            String nodeName = element.getName().toLowerCase();
            if (ControlFactory.getControlFace(nodeName) == null) continue;
            Plugin plugin = (Plugin)ControlFactory.getControlFace(nodeName).getControlInstance();
            PageViewBuilder.attributeConvert(element, plugin);
            operation.addPlugin(plugin);
        }
    }

    private static void addOperationParameter(Operation operation, Element parentElement) {
        Iterator parameterEIterator = parentElement.elementIterator();
        while (parameterEIterator.hasNext()) {
            Element element = (Element)parameterEIterator.next();
            operation.getParamter().put((Object)element.attributeValue("key"), (Object)element.attributeValue("value"));
        }
    }

    private static void addValidations(Operation operation, Element parentElement) {
        Iterator parameterEIterator = parentElement.elementIterator();
        while (parameterEIterator.hasNext()) {
            Element element = (Element)parameterEIterator.next();
            String id = element.attributeValue("id");
            SimpleMap validationMap = (SimpleMap)operation.getValidations().get((Object)id);
            if (validationMap == null) {
                validationMap = new SimpleMap(6);
                operation.getValidations().put((Object)id, (Object)validationMap);
            }
            PageViewBuilder.setAttribute(element, validationMap);
        }
    }

    private static void setAttribute(Element element, SimpleMap dataMap) {
        Iterator attributes = element.attributeIterator();
        while (attributes.hasNext()) {
            Attribute attribute = (Attribute)attributes.next();
            dataMap.put((Object)attribute.getName(), attribute.getData());
        }
    }
}

