/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.parser;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.form.view.parser.PageViewBuilder;
import kd.occ.ocepfp.core.metadata.MetadataBuilder;
import org.dom4j.DocumentException;

public class PageViewCache {
    protected static Log logger = LogFactory.getLog(PageViewCache.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ocepfp_pageview");
    private static final String version = "1.00039";

    public static final PageView getPageView(ExtWebContext ctx, String viewKey) {
        String pageViewStr = PageViewCache.getPageViewFromCache(viewKey);
        PageView pageView = null;
        try {
            if (StringUtil.isNull((String)pageViewStr)) {
                pageView = PageViewBuilder.buildPageView(ctx, viewKey);
            } else {
                long s = System.currentTimeMillis();
                pageView = (PageView)((Object)JsonUtil.readValue((String)pageViewStr, PageView.class));
                pageView.setMetadata(MetadataBuilder.build(ctx, pageView));
                LogUtil.info(PageViewCache.class, (String)(viewKey + " CacheTime:" + (System.currentTimeMillis() - s)));
            }
        }
        catch (InstantiationException e) {
            logger.error(pageViewStr);
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(pageViewStr);
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (DocumentException e) {
            logger.error(pageViewStr);
            logger.error(e.getMessage(), (Throwable)e);
        }
        return pageView;
    }

    public static final void putPageView(ExtWebContext ctx, String viewKey, PageView pageView) {
        String pageViewStr = JsonUtil.toString((Object)((Object)pageView));
        if (pageView.getPageBody().isHasAppend()) {
            cache.put(PageViewCache.getPrivateKey(viewKey), (Object)pageViewStr);
        } else {
            cache.put(PageViewCache.getPublicKey(viewKey), (Object)pageViewStr);
        }
    }

    public static final String getPageViewStr(String viewKey) {
        return PageViewCache.getPageViewFromCache(viewKey);
    }

    private static final String getPageViewFromCache(String viewKey) {
        if (StringUtil.isNull((String)viewKey)) {
            return "";
        }
        String pageViewStr = (String)cache.get(PageViewCache.getPrivateKey(viewKey));
        if (StringUtil.isNull((String)pageViewStr)) {
            pageViewStr = (String)cache.get(PageViewCache.getPublicKey(viewKey));
        }
        return pageViewStr;
    }

    private static final String getPublicKey(String key) {
        return PageViewCache.getPrivateKey(key);
    }

    private static final String getPrivateKey(String key) {
        return String.format("%s.%s.%s", RequestContext.get().getAccountId(), key, version);
    }
}

