/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.parser;

import java.util.HashMap;
import java.util.Map;
import kd.occ.ocepfp.common.constant.BillViewType;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.form.view.base.ExtListView;

public class ViewBasePluginFactory {
    private static Map<String, String> _cache = new HashMap<String, String>(4);

    public static final String getBasePluginClassName(String billType) {
        return _cache.get(billType);
    }

    public static final AbstractExtFormPlugin getBasePlugin(String billType) {
        return (AbstractExtFormPlugin)Convert.toInstance((String)ViewBasePluginFactory.getBasePluginClassName(billType));
    }

    public static final ExtDynamicView<?> getBaseView(String billType) {
        ExtDynamicView view = null;
        switch (billType) {
            case "listview": {
                view = new ExtListView();
                break;
            }
            case "billview": 
            case "portalview": {
                view = new ExtBillView();
            }
        }
        return view;
    }

    static {
        _cache.put(BillViewType.BillView.getValue(), "kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin");
        _cache.put(BillViewType.ListView.getValue(), "kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin");
        _cache.put(BillViewType.PortalView.getValue(), "kd.occ.ocepfp.core.form.plugin.ExtPortalViewPlugin");
    }
}

