/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.lang.Lang;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.GlobalParameter;
import kd.occ.ocepfp.common.entity.LoadViewResponse;
import kd.occ.ocepfp.common.entity.UserSettingInfo;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.PageUtil;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.ControlFactory;
import kd.occ.ocepfp.core.form.control.IControlParser;
import kd.occ.ocepfp.core.form.view.base.Command;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.servicehelper.GlobalParamServiceHelper;
import kd.occ.ocepfp.core.servicehelper.userinfo.UserInfoHelper;

public class ViewObjectConverter {
    public static final LoadViewResponse getInitViewData(ExtWebContext extCtx, PageView pageView, Map<String, Control> customControlStack, List<Command> commandList, boolean isModifiedInInitView, String customPageTitle) {
        String pageId = StringUtil.isNotNull((String)extCtx.getForm().getPageId()) ? extCtx.getForm().getPageId() : PageUtil.getPageId();
        String renderData = pageView.getSnapShortParsedString();
        if (!isModifiedInInitView || StringUtil.isNull((String)renderData)) {
            renderData = ViewObjectConverter.getRenderData(extCtx, pageView, pageId, customControlStack);
            if (!isModifiedInInitView) {
                pageView.setSnapShortParsedString(renderData);
            }
        }
        pageView.setEnableUseSnapShot(isModifiedInInitView);
        LoadViewResponse loadViewResponse = new LoadViewResponse();
        loadViewResponse.setData(ViewObjectConverter.getMainData(extCtx, pageView, renderData, customPageTitle));
        loadViewResponse.setLocales(ViewObjectConverter.getLocales(extCtx));
        loadViewResponse.setTheme(ViewObjectConverter.getTheme(extCtx));
        loadViewResponse.setRootpath(ViewObjectConverter.getRootPath(extCtx));
        loadViewResponse.setInitfilter(commandList);
        loadViewResponse.setGb(ViewObjectConverter.getGB(extCtx, pageView, commandList));
        loadViewResponse.setPageId(pageId);
        loadViewResponse.setMessage("");
        return loadViewResponse;
    }

    private static final Map<String, Object> getGB(ExtWebContext extCtx, PageView pageView, List<Command> commandList) {
        HashMap<String, Object> data = new HashMap<String, Object>(6);
        data.put("locales", ViewObjectConverter.getLocales(extCtx));
        data.put("theme", ViewObjectConverter.getTheme(extCtx));
        data.put("rootpath", ViewObjectConverter.getRootPath(extCtx));
        data.put("initfilter", commandList);
        data.put("imgsrv", PictureUtil.getFileServerUrl());
        data.put("maskloading", pageView.isMaskLoading());
        return data;
    }

    private static final Map<String, Object> getMainData(ExtWebContext extCtx, PageView pageView, String renderData, String customPageTitle) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("pagetype", pageView.getBillViewType());
        data.put("name", StringUtil.isNotNull((String)customPageTitle) ? customPageTitle : pageView.getName());
        if (pageView.isForceRefresh()) {
            data.put("ff", pageView.isForceRefresh());
        }
        data.put("controls", JsonUtil.readValue((String)renderData, List.class));
        ViewObjectConverter.setMobileData(extCtx, pageView, data);
        data.put("global", ViewObjectConverter.getGlobal(pageView));
        data.put("gm", ViewObjectConverter.getGlobalMsg(extCtx));
        return data;
    }

    private static final List<Map<String, Object>> getLocales(ExtWebContext extCtx) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(2);
        HashMap<String, Object> zh = new HashMap<String, Object>(4);
        zh.put("k", Lang.zh_CN);
        zh.put("desc", "\u4e2d\u6587");
        zh.put("default", true);
        zh.put("icon", "iconjianti");
        list.add(zh);
        HashMap<String, Object> en = new HashMap<String, Object>(4);
        en.put("k", Lang.en_US);
        en.put("desc", "\u82f1\u6587");
        en.put("default", false);
        en.put("icon", "iconyingwen");
        list.add(en);
        return list;
    }

    private static final String setMobileData(ExtWebContext extCtx, PageView pageView, Map<String, Object> data) {
        String value = "";
        if (extCtx.isFromMobile()) {
            if (pageView.isHideMainTabbar()) {
                data.put("hidemaintabbar", pageView.isHideMainTabbar());
            }
            if (pageView.isHideReturnBack()) {
                data.put("hidereturnback", pageView.isHideReturnBack());
            }
            if (pageView.isOnGoHistory()) {
                data.put("gohistory", pageView.isOnGoHistory());
            }
            if (StringUtil.isNotNull((String)pageView.getNavColor())) {
                data.put("navcolor", pageView.getNavColor());
            }
            if (StringUtil.isNotNull((String)pageView.getThemeColor())) {
                data.put("themecolor", pageView.getThemeColor());
            }
            if (StringUtil.isNotNull((String)pageView.getShareAppMessage())) {
                data.put("shareappmessage", pageView.getShareAppMessage());
            }
            if (StringUtil.isNotNull((String)pageView.getShareTimeline())) {
                data.put("sharetimeline", pageView.getShareTimeline());
            }
            if (pageView.isForceLoaction()) {
                data.put("forcelocation", true);
            }
            if (pageView.isHomeButton()) {
                data.put("homebutton", true);
            }
            data.put("location", pageView.isLoaction());
        }
        return value;
    }

    private static final Map<String, Object> getTheme(ExtWebContext extCtx) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (extCtx.getForm().isFramePage()) {
            UserSettingInfo userSettingInfo = UserInfoHelper.getUserSettingInfo();
            data.put("tabShowType", userSettingInfo.getTabShowType());
            data.put("pageOpenType", userSettingInfo.getPageOpenType());
            data.put("isDefaultTheme", userSettingInfo.isDefaultTheme());
            data.put("customThemeColor", StringUtil.isNull((String)userSettingInfo.getCustomThemeColor()) ? "#5582F3" : userSettingInfo.getCustomThemeColor());
        }
        return data;
    }

    private static final Map<String, String> getGlobalMsg(ExtWebContext extCtx) {
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("nosd", "\u8bf7\u5148\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u8bb0\u5f55!");
        return data;
    }

    public static final String getRootPath(ExtWebContext extCtx) {
        String rootPath = extCtx.getRootPath();
        return rootPath;
    }

    private static final Map<String, Object> getGlobal(PageView pageView) {
        List maskImageList;
        GlobalParameter globalParam = GlobalParamServiceHelper.getGlobalParameter();
        HashMap<String, Object> child = new HashMap<String, Object>(6);
        child.putAll(globalParam.getNormalParams());
        if (pageView.getGlobal().getChilds() != null && pageView.getGlobal().getChilds().size() > 0) {
            for (Control property : pageView.getGlobal().getChilds()) {
                child.put(property.getString("key"), property.getValue());
            }
        }
        if ((maskImageList = globalParam.getMaskImageList()) != null && maskImageList.size() > 0) {
            child.put("mallMaskImageStatus", maskImageList);
        }
        return child;
    }

    protected static final String getRenderData(ExtWebContext extCtx, PageView pageView, String pageId, Map<String, Control> customControlStack) {
        StringBuilder content = new StringBuilder();
        Map<String, Control> element = pageView.getPageBody().getTopElement();
        String o = "";
        content.append("[");
        for (Map.Entry<String, Control> entry : element.entrySet()) {
            content.append(o).append(ViewObjectConverter.create(extCtx, entry.getValue(), pageId, customControlStack));
            o = ",";
        }
        content.append("]");
        return content.toString();
    }

    public static final String create(ExtWebContext extCtx, List<Control> controls, String pageId, Map<String, Control> customControlStack) {
        StringBuilder source = new StringBuilder();
        String o = "";
        for (Control control : controls) {
            source.append(o).append(ViewObjectConverter.create(extCtx, control, pageId, customControlStack));
            o = ",";
        }
        o = null;
        return source.toString();
    }

    public static final String create(ExtWebContext extCtx, Control control, String pageId, Map<String, Control> customControlStack) {
        ControlFactory.Face face = ControlFactory.getControlFace(control.getXmlNodeName());
        if (face == null) {
            return "";
        }
        IControlParser controlParse = face.getControlParse();
        if (customControlStack != null && customControlStack.containsKey(control.getId())) {
            return controlParse.create(extCtx, customControlStack.get(control.getId()), pageId, customControlStack);
        }
        String x = controlParse.create(extCtx, control, pageId, customControlStack);
        return x;
    }
}

