/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.core.form.view.storage.LocalJfsView;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class LocalStorage {
    protected static Log logger = LogFactory.getLog(LocalStorage.class);
    private static final ConcurrentMap<String, LocalJfsView> _versionCache = new ConcurrentHashMap<String, LocalJfsView>();

    public static final LocalJfsView getLocalVersion(String viewId) {
        LocalJfsView localView = (LocalJfsView)_versionCache.get(viewId);
        if (localView != null) {
            return localView;
        }
        Document document = LocalStorage.loadViewFile(viewId);
        localView = new LocalJfsView();
        localView.setDocument(document);
        if (document != null) {
            Element rootElement = document.getRootElement();
            localView.setVersion(rootElement.attributeValue("version"));
            localView.setAppId(rootElement.attributeValue("appid") != null ? Long.parseLong(rootElement.attributeValue("appid")) : 0L);
        }
        _versionCache.put(viewId, localView);
        return localView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Document loadViewFile(String viewId) {
        InputStream is = LocalStorage.class.getResourceAsStream(String.format("/JfsView/%s.xml", viewId));
        logger.info("xml filePath:" + LocalStorage.class.getResource(String.format("/JfsView/%s.xml", viewId)));
        Document document = null;
        try {
            if (is != null) {
                document = new SAXReader().read(is);
            }
        }
        catch (DocumentException e) {
            LogUtil.error(LocalStorage.class, (String)e.getMessage(), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return document;
    }
}

