/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.storage.cache.local;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.occ.ocepfp.common.entity.ExtView;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.IExtLocalCacheObject;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.view.storage.ExtStorageFactory;
import kd.occ.ocepfp.core.form.view.storage.cache.local.ExtLocalCacheElement;

public class ExtLocalCacheVerInfo {
    private String cacheKey;
    private ConcurrentMap<String, ExtLocalCacheElement> _local = new ConcurrentHashMap<String, ExtLocalCacheElement>();
    private ConcurrentMap<String, String> _localAccountReference = new ConcurrentHashMap<String, String>();

    public ExtLocalCacheVerInfo(ExtWebContext webCtx, String cacheKey, IExtLocalCacheObject dataObject) {
        this.add(webCtx, cacheKey, dataObject);
    }

    public final IExtLocalCacheObject get(ExtWebContext webCtx) {
        System.out.println(this.cacheKey);
        String oldLocalVersion = (String)this._localAccountReference.get(webCtx.getAccountId());
        oldLocalVersion = StringUtil.isNull((String)oldLocalVersion) ? "" : oldLocalVersion;
        String centerVersion = ExtStorageFactory.getStandardStorage().getVersionFromVerCenter(webCtx, this.cacheKey);
        ExtLocalCacheElement cacheElement = (ExtLocalCacheElement)this._local.get(oldLocalVersion);
        if (StringUtil.isNull((String)oldLocalVersion) || StringUtil.isNull((String)centerVersion) || !oldLocalVersion.equalsIgnoreCase(centerVersion)) {
            if (cacheElement != null && cacheElement.remove(webCtx)) {
                LogUtil.info(ExtLocalCacheVerInfo.class, (String)(this.cacheKey + " check " + webCtx.getAccountId() + "," + oldLocalVersion + "," + centerVersion));
                this._local.remove(oldLocalVersion);
            }
            ExtView extView = ExtStorageFactory.getStandardStorage().getView(webCtx, this.cacheKey);
            cacheElement = this.add(webCtx, this.cacheKey, (IExtLocalCacheObject)extView);
        }
        return cacheElement.getDataObject();
    }

    private final ExtLocalCacheElement add(ExtWebContext webCtx, String cacheKey, IExtLocalCacheObject dataObject) {
        this.cacheKey = cacheKey;
        String version = dataObject == null ? "0" : dataObject.getVersion();
        ExtLocalCacheElement cacheElement = (ExtLocalCacheElement)this._local.get(version);
        if (cacheElement == null) {
            cacheElement = new ExtLocalCacheElement();
            this._local.put(version, cacheElement);
        }
        cacheElement.add(webCtx, dataObject);
        this._localAccountReference.put(webCtx.getAccountId(), version);
        ExtStorageFactory.getStandardStorage().setVersion2VerCenter(webCtx, cacheKey, version);
        return cacheElement;
    }
}

