/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.storage.cache.local;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.occ.ocepfp.common.entity.ExtView;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.IExtLocalCacheObject;
import kd.occ.ocepfp.common.util.CollectionUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.view.ExtMajorView;
import kd.occ.ocepfp.core.form.view.storage.ExtStorageFactory;
import kd.occ.ocepfp.core.form.view.storage.LocalJfsView;
import kd.occ.ocepfp.core.form.view.storage.LocalStorage;
import kd.occ.ocepfp.core.form.view.storage.cache.local.AccountCache;
import kd.occ.ocepfp.core.form.view.storage.cache.local.ExtLocalCache;
import kd.occ.ocepfp.core.service.view.ExtViewServiceHelper;

public class ExtViewLoader {
    private static ConcurrentMap<String, Boolean> _INIT = new ConcurrentHashMap<String, Boolean>();
    private static AccountCache<String, ExtMajorView> _LocalCache = new AccountCache();

    public static ExtMajorView get(ExtWebContext webCtx, String viewKey) {
        if (viewKey == null) {
            return null;
        }
        viewKey = viewKey.toLowerCase();
        if (!ExtViewLoader.isInit(webCtx)) {
            ExtViewLoader.init(webCtx);
        }
        ExtMajorView majorView = (ExtMajorView)_LocalCache.getCache(webCtx.getAccountId()).get(viewKey);
        majorView = ExtViewLoader.checkPhysicsFileVersion(webCtx, viewKey, majorView);
        return majorView;
    }

    private static ExtMajorView checkPhysicsFileVersion(ExtWebContext webCtx, String viewKey, ExtMajorView majorView) {
        LocalJfsView localJfsView = LocalStorage.getLocalVersion(viewKey);
        if (localJfsView == null) {
            return majorView;
        }
        if (majorView == null || majorView.getView() == null || localJfsView.isOutVersion(majorView.getView().get(webCtx).getVersion())) {
            try {
                ExtViewServiceHelper.updateFileFromJarView(webCtx, viewKey, localJfsView.getDocument(), localJfsView.getAppId());
            }
            catch (Exception e) {
                LogUtil.error(ExtViewLoader.class, (String)e.getMessage(), (Throwable)e);
            }
            String extendViewId = localJfsView.getExtend();
            if (StringUtil.isNotNull((String)extendViewId)) {
                ExtViewLoader.get(webCtx, extendViewId);
            }
            ExtViewLoader.reload(webCtx, viewKey);
            majorView = (ExtMajorView)_LocalCache.getCache(webCtx.getAccountId()).get(viewKey);
        }
        return majorView;
    }

    public static synchronized void reload(ExtWebContext webCtx, String viewKey) {
        ExtViewLoader.init(webCtx);
        ExtView extView = ExtStorageFactory.getStandardStorage().getView(webCtx, viewKey);
        if (extView != null) {
            ExtLocalCache.add(webCtx, extView.getViewKey(), new IExtLocalCacheObject[]{extView});
            ExtViewLoader.addAppend(webCtx, extView);
        }
    }

    public static void reloadAll(ExtWebContext webCtx) {
        List<ExtView> extViewList = ExtStorageFactory.getStandardStorage().getAllViews(webCtx);
        if (CollectionUtil.isNotNull(extViewList)) {
            for (ExtView extView : extViewList) {
                ExtLocalCache.add(webCtx, extView.getViewKey(), new IExtLocalCacheObject[]{extView});
                ExtViewLoader.addAppend(webCtx, extView);
            }
        }
    }

    private static synchronized void init(ExtWebContext webCtx) {
        if (!ExtViewLoader.isInit(webCtx)) {
            ExtViewLoader.reloadAll(webCtx);
            ExtViewLoader.setInitialized(webCtx);
        }
    }

    private static void addAppend(ExtWebContext webCtx, ExtView extView) {
        String key;
        ConcurrentMap<String, ExtMajorView> myCache = _LocalCache.getCache(webCtx.getAccountId());
        ExtMajorView extMajorView = (ExtMajorView)myCache.get(key = StringUtil.isNotNull((String)extView.getAppend()) ? extView.getAppend() : extView.getViewKey());
        if (extMajorView == null) {
            LogUtil.info(ExtViewLoader.class, (String)("addAppend:" + extView.getViewKey() + "," + webCtx.getAccountId()));
            extMajorView = new ExtMajorView(key, extView.getExtend());
            myCache.put(key, extMajorView);
        } else if (key.equalsIgnoreCase(extView.getViewKey())) {
            extMajorView.setExtend(extView.getExtend());
        }
        if (StringUtil.isNotNull((String)extView.getAppend())) {
            extMajorView.addAppend(extView.getViewKey());
        }
    }

    private static boolean isInit(ExtWebContext webCtx) {
        return _INIT.containsKey(webCtx.getAccountId()) && (Boolean)_INIT.get(webCtx.getAccountId()) != false;
    }

    private static void setInitialized(ExtWebContext webCtx) {
        _INIT.put(webCtx.getAccountId(), true);
    }
}

