/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.login;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.occ.ocepfp.common.constant.ExtLoginType;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.MainPortal;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.login.IExtLoginInterceptor;
import kd.occ.ocepfp.core.login.LoginCheckResult;
import kd.occ.ocepfp.core.login.MemberLoginInterceptor;
import kd.occ.ocepfp.core.login.NextCloudLoginInterceptor;
import kd.occ.ocepfp.core.service.portal.ExtPortalServiceHelper;

public class LoginCheckHelper {
    private static Map<ExtLoginType, IExtLoginInterceptor> _Map = new HashMap<ExtLoginType, IExtLoginInterceptor>(2);
    private static Set<String> _IgnoreEventMap = new HashSet<String>();

    public static final LoginCheckResult check(ExtWebContext extCtx) {
        PageView pageView = extCtx.getCurrentPageView();
        LoginCheckResult loginCheckResult = null;
        if (pageView == null || (!pageView.isNeedLogin() || _IgnoreEventMap.contains(extCtx.getForm().getEvent())) && !extCtx.getForm().getBoolean("force_login", Boolean.valueOf(false)).booleanValue()) {
            loginCheckResult = LoginCheckResult.getNoNeedResultInstance();
            return loginCheckResult;
        }
        IExtLoginInterceptor interceptor = _Map.get(StringUtil.isNull((Object)pageView.getLoginType()) ? ExtLoginType.nextcloud : pageView.getLoginType());
        loginCheckResult = interceptor != null ? interceptor.check(extCtx) : LoginCheckResult.getNoLoginTypeInstance();
        if (!loginCheckResult.isSuccess()) {
            MainPortal mainPortal = ExtPortalServiceHelper.getMainPortal(extCtx);
            loginCheckResult.setLoginPage(mainPortal.getCurrentLoginPage(extCtx.getForm().getDevice()));
        }
        return loginCheckResult;
    }

    static {
        _Map.put(ExtLoginType.member, new MemberLoginInterceptor());
        _Map.put(ExtLoginType.nextcloud, new NextCloudLoginInterceptor());
        _IgnoreEventMap.add("getPublicKey");
        _IgnoreEventMap.add("regFans");
        _IgnoreEventMap.add("wxLogin");
        _IgnoreEventMap.add("wxRegister");
    }
}

