/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.SelectDataEntity;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.FlexField;
import kd.occ.ocepfp.core.form.control.controls.Price;
import kd.occ.ocepfp.core.form.control.controls.SelectData;
import kd.occ.ocepfp.core.form.control.controls.Spu;
import kd.occ.ocepfp.core.form.control.controls.Text;

public class Field
implements Serializable {
    private static final long serialVersionUID = 4840506095497636476L;
    private String id;
    private String name;
    private String orm;
    private String field;
    private String baseViewId;
    private String baseListViewId;
    private boolean isPrimary;
    private boolean isBillNo;
    private boolean isUnique;
    private String fieldType;
    private boolean isRequired;
    private Integer length;
    private Integer precision;
    private String parentViewId;
    private String parentId;
    private Object defaultValue;
    private String nodeName;
    private String splitTable;
    private String linkorm;
    private String reform;
    private int minLength;
    private int maxLength;
    private String baseMaterialField;
    private String baseItemField;
    private String baseField;
    private String linkedSkuId;
    private String entityId;
    private String currency;
    private List<SimpleMap<String, Object>> values = new ArrayList<SimpleMap<String, Object>>(2);

    public String getLinkedSkuId() {
        return this.linkedSkuId;
    }

    public void setLinkedSkuId(String linkedSkuId) {
        this.linkedSkuId = linkedSkuId;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public Field setUnique(boolean isUnique) {
        this.isUnique = isUnique;
        return this;
    }

    public String getOrm() {
        return this.orm;
    }

    public Field setOrm(String orm) {
        this.orm = orm;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Field setName(String name) {
        this.name = name;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Field setId(String id) {
        this.id = id;
        return this;
    }

    public String getField() {
        return this.field;
    }

    public Field setField(String field) {
        this.field = field;
        return this;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public Field setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
        return this;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    @JsonIgnore
    public boolean isF7() {
        return "SelectData".equals(this.fieldType) || "Creator".equals(this.fieldType) || "Modifier".equals(this.fieldType) || "Unit".equals(this.fieldType) || "Currency".equals(this.fieldType);
    }

    @JsonIgnore
    public boolean isFlexField() {
        return "flexfield".equals(this.fieldType);
    }

    public Field setFieldType(String fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public Integer getLength() {
        return this.length;
    }

    public Field setLength(Integer length) {
        this.length = length;
        return this;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Field setPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public Field setRequired(boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    public boolean isBillNo() {
        return this.isBillNo;
    }

    public Field setBillNo(boolean isBillNo) {
        this.isBillNo = isBillNo;
        return this;
    }

    public String getBaseViewId() {
        return this.baseViewId;
    }

    public void setBaseViewId(String baseViewId) {
        this.baseViewId = baseViewId;
    }

    public String getParentViewId() {
        return this.parentViewId;
    }

    public void setParentViewId(String parentViewId) {
        this.parentViewId = parentViewId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getSplitTable() {
        return this.splitTable;
    }

    public void setSplitTable(String splitTable) {
        this.splitTable = splitTable;
    }

    public static final Field createField(ExtWebContext extCtx, Control control) {
        Field field = null;
        if ("form".equals(control.getElementType())) {
            field = new Field();
            field.setId(control.getId());
            field.setOrm(control.getORM());
            field.setName(control.getName());
            field.setField(control.getField());
            field.setFieldType(control.getType());
            field.setNodeName(control.getXmlNodeName());
            field.setBillNo("Code".equalsIgnoreCase(control.getType()));
            field.setRequired(StringUtil.isNotNull((String)control.getRequired()) && control.getRequired().equalsIgnoreCase("true"));
            field.setBillNo(control.getType().equalsIgnoreCase("Code"));
            field.setDefaultValue(control.getValue());
            field.setLinkorm(control.getLinkORM());
            if (control.isF7()) {
                field.setReform(control.getRelatedOrm() + (StringUtil.isNotNull((String)control.getRelatedOrm()) ? "," : ""));
                SelectData selectData = (SelectData)control;
                field.setReform(field.getReform() + (StringUtil.isNotNull((String)selectData.getDisplayField()) ? selectData.getDisplayField() + "," : ""));
                field.setReform(field.getReform() + (StringUtil.isNotNull((String)selectData.getRefProp()) ? selectData.getRefProp() + "," : ""));
            }
            if ("Input".equalsIgnoreCase(field.getFieldType())) {
                field.setMaxLength(((Text)control).getMaxLength());
                field.setMinLength(((Text)control).getMinLength());
            }
            if ("spu".equalsIgnoreCase(field.getFieldType())) {
                field.setLinkedSkuId(((Spu)control).getLinkedSkuId());
            }
            if ("flexfield".equalsIgnoreCase(field.getFieldType())) {
                FlexField flexField = (FlexField)control;
                field.setBaseMaterialField(flexField.getMaterialField());
                field.setBaseItemField(flexField.getItemField());
            }
            if (field.isF7()) {
                SelectDataEntity selectDataEntity = ((SelectData)control).getSelectDataEntity(extCtx);
                field.setBaseViewId(selectDataEntity.getBaseViewId());
                field.setBaseListViewId(selectDataEntity.getListViewId());
            } else if (StringUtil.isNotNull((String)control.getString("baseviewid"))) {
                field.setBaseViewId(control.getString("baseviewid"));
            }
            if ("Amount".equals(field.getFieldType()) || "Price".equals(field.getFieldType())) {
                field.setCurrency(((Price)control).getCurrency());
            }
        }
        return field;
    }

    public String getLinkorm() {
        return this.linkorm;
    }

    public void setLinkorm(String linkorm) {
        this.linkorm = linkorm;
    }

    public String getReform() {
        return this.reform;
    }

    public void setReform(String reform) {
        this.reform = reform;
    }

    public String getBaseListViewId() {
        return this.baseListViewId;
    }

    public void setBaseListViewId(String baseListViewId) {
        this.baseListViewId = baseListViewId;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public List<SimpleMap<String, Object>> getValues() {
        return this.values;
    }

    public void setValues(List<SimpleMap<String, Object>> values) {
        this.values = values;
    }

    public String getBaseMaterialField() {
        return this.baseMaterialField;
    }

    public void setBaseMaterialField(String baseMaterialField) {
        this.baseMaterialField = baseMaterialField;
    }

    public String getBaseItemField() {
        return this.baseItemField;
    }

    public void setBaseItemField(String baseItemField) {
        this.baseItemField = baseItemField;
    }

    public String getBaseField() {
        return this.baseField;
    }

    public void setBaseField(String baseField) {
        this.baseField = baseField;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }
}

