/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.Operation;
import kd.occ.ocepfp.core.metadata.Field;
import kd.occ.ocepfp.core.metadata.Metadata;

public class MainMetadata
extends Metadata {
    private static final long serialVersionUID = 7945681124265539355L;
    private String viewId;
    private Field billNoField;
    private String billType;
    private String billDataType;
    private String baseMetadataId;
    private String listMetadataId;
    private List<Operation> operationList = new ArrayList<Operation>(6);
    private int pkType = 1;

    public static final MainMetadata create(String viewId, String name, String billType, String billDataType, String tableName, String pkField, String dbRoute) {
        MainMetadata mainMetadata = new MainMetadata();
        mainMetadata.init(name, tableName, pkField);
        mainMetadata.viewId = viewId;
        mainMetadata.billType = billType;
        mainMetadata.billDataType = billDataType;
        mainMetadata.setDbRoute(dbRoute);
        return mainMetadata;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public Field getBillNoField() {
        return this.billNoField;
    }

    public void setBillNoField(Field billNoField) {
        this.billNoField = billNoField;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getBillDataType() {
        return this.billDataType;
    }

    public void setBillDataType(String billDataType) {
        this.billDataType = billDataType;
    }

    @Override
    public Field addField(ExtWebContext extCtx, Control control) {
        Field field = super.addField(extCtx, control);
        if (field != null) {
            field.setParentViewId(this.getViewId());
            field.setParentId(this.getViewId());
            if (field.isBillNo()) {
                this.setBillNoField(field);
            }
            this.addListSearchField(control, field);
        }
        return field;
    }

    public String getBaseMetadataId() {
        return this.baseMetadataId;
    }

    public void setBaseMetadataId(String baseMetadataId) {
        this.baseMetadataId = baseMetadataId;
    }

    @JsonIgnore
    public String getMainMetadataOrmId() {
        return StringUtil.isNotNull((String)this.baseMetadataId) ? this.baseMetadataId : this.viewId;
    }

    public String getListMetadataId() {
        return this.listMetadataId;
    }

    public void setListMetadataId(String listMetadataId) {
        this.listMetadataId = listMetadataId;
    }

    public int getPkType() {
        return this.pkType;
    }

    public void setPkType(int pkType) {
        this.pkType = pkType;
    }

    public List<Operation> getOperationList() {
        return this.operationList;
    }

    public void setOperationList(List<Operation> operationList) {
        this.operationList = operationList;
    }

    public void addOperation(Operation operation) {
        this.operationList.add(operation);
    }
}

