/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.occ.ocepfp.common.constant.ExtDbRouter;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.SelectData;
import kd.occ.ocepfp.core.metadata.Entry;
import kd.occ.ocepfp.core.metadata.Field;

public abstract class Metadata
implements Serializable {
    private static final long serialVersionUID = -4666220540419393137L;
    private Map<String, Entry> entryMap = new HashMap<String, Entry>();
    private Map<String, Field> fieldsMap = new HashMap<String, Field>();
    private String name;
    private String entityId;
    private String tableName;
    private String pkField;
    private boolean isSplitTable;
    private String dbRoute;
    private List<Field> fieldList = new ArrayList<Field>(30);
    private List<Entry> entries = new ArrayList<Entry>(4);
    private List<Field> defaultValueFieldList = new ArrayList<Field>(30);
    private Metadata mainMetadata;
    private List<Field> listSearchField = new ArrayList<Field>(10);
    private Map<String, OrmMapKv> ormMapIdKeys = new HashMap<String, OrmMapKv>(8);
    private Map<String, OrmMapKv> allFieldsMap = new HashMap<String, OrmMapKv>(8);

    public Field addField(ExtWebContext extCtx, Control control) {
        Field field = Field.createField(extCtx, control);
        if (field == null) {
            return null;
        }
        this.fieldList.add(field);
        this.fieldsMap.put(field.getId().toLowerCase(), field);
        field.setSplitTable(control.getSplitTable());
        if (StringUtil.isNotNull((String)control.getORM())) {
            Map<String, OrmMapKv> ormMapIdKeysTmp = this.mainMetadata != null ? this.mainMetadata.getOrmMapIdKeys() : this.ormMapIdKeys;
            Boolean isFilterField = control.getBoolean("_isfilter");
            if (!isFilterField.booleanValue()) {
                OrmMapKv ormMapKv = new OrmMapKv();
                ormMapKv.setEntryId(control.getSrcDataGrid());
                ormMapKv.setId(control.getId());
                if (field.isF7()) {
                    SelectData selectData = (SelectData)control;
                    ormMapKv.setDisplayOrm(control.getORM().toLowerCase() + "." + selectData.getDisplayField());
                }
                ormMapIdKeysTmp.put(control.getORM().toLowerCase(), ormMapKv);
            }
        }
        Map<String, OrmMapKv> allFieldsMap = this.mainMetadata != null ? this.mainMetadata.getAllFieldsMap() : this.allFieldsMap;
        OrmMapKv fieldKey = new OrmMapKv();
        fieldKey.setEntryId(control.getSrcDataGrid());
        fieldKey.setId(control.getId());
        allFieldsMap.put(field.getId(), fieldKey);
        this.addDefaultValueField(field);
        return field;
    }

    private void addDefaultValueField(Field field) {
        if (StringUtil.isNotNull((Object)field.getDefaultValue())) {
            this.defaultValueFieldList.add(field);
        }
    }

    public List<Field> getDefaultValueFieldList() {
        return this.defaultValueFieldList;
    }

    public void addListSearchField(Control control, Field field) {
        if (control.isListSearch()) {
            this.listSearchField.add(field);
        }
    }

    public List<Field> getFieldList() {
        return this.fieldList;
    }

    protected void init(String name, String tableName, String pkField) {
        this.name = name;
        this.tableName = tableName;
        this.pkField = pkField;
        Field _pkField = new Field();
        _pkField.setId("id");
        _pkField.setOrm("id");
        _pkField.setField(pkField);
    }

    public void addEntry(Entry entry) {
        entry.setParentPkField(this.pkField);
        entry.setMainMetadata(this);
        this.entries.add(entry);
        this.addEntryMap(entry);
    }

    @JsonIgnore
    public String getMainListDataGridId() {
        return this.entries != null && this.entries.size() > 0 ? this.entries.get(0).getId() : "";
    }

    public Entry getEntry(String entryId) {
        return this.entryMap.get(entryId.toLowerCase());
    }

    protected void addEntryMap(Entry entry) {
        this.entryMap.put(entry.getId().toLowerCase(), entry);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Metadata setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getPkField() {
        return this.pkField;
    }

    public Metadata setPkField(String pkField) {
        this.pkField = pkField;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Metadata setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isSplitTable() {
        return this.isSplitTable;
    }

    public void setSplitTable(boolean isSplitTable) {
        this.isSplitTable = isSplitTable;
    }

    public String getDbRoute() {
        return StringUtil.isNotNull((String)this.dbRoute) ? this.dbRoute : ExtDbRouter.EXT.getRouteKey();
    }

    public void setDbRoute(String dbRoute) {
        this.dbRoute = dbRoute;
    }

    public void setMainMetadata(Metadata mainMetadata) {
        this.mainMetadata = mainMetadata;
    }

    public Metadata getMainMetadata() {
        return this.mainMetadata;
    }

    public Map<String, OrmMapKv> getOrmMapIdKeys() {
        return this.ormMapIdKeys;
    }

    public void setOrmMapIdKeys(Map<String, OrmMapKv> ormMapIdKeys) {
        this.ormMapIdKeys = ormMapIdKeys;
    }

    public Map<String, OrmMapKv> getAllFieldsMap() {
        return this.allFieldsMap;
    }

    public void setAllFieldsMap(Map<String, OrmMapKv> allFieldsMap) {
        this.allFieldsMap = allFieldsMap;
    }

    @JsonIgnore
    public boolean isField(String id) {
        return this.fieldsMap.containsKey(id.toLowerCase());
    }

    @JsonIgnore
    public Field getField(String id) {
        return this.fieldsMap.get(id.toLowerCase());
    }

    public Map<String, Field> getFieldsMap() {
        return this.fieldsMap;
    }

    public void setFieldsMap(Map<String, Field> fieldsMap) {
        this.fieldsMap = fieldsMap;
    }

    public void setFieldList(List<Field> fieldList) {
        this.fieldList = fieldList;
    }

    @JsonIgnore
    public Field getUniqueField(String id) {
        OrmMapKv fieldKey;
        String[] keys = id.split("\\.");
        int fieldIndex = 0;
        if (this.isEntry(keys[0])) {
            fieldIndex = 1;
        }
        if ((fieldKey = this.getAllFieldsMap().get(keys[fieldIndex])) == null) {
            Field field = new Field();
            if (keys.length >= 2) {
                field.setEntityId(keys[0]);
                field.setId(keys[1]);
            } else {
                field.setId(id);
            }
            return field;
        }
        String entryId = fieldKey.getEntryId();
        if (StringUtil.isNotNull((String)entryId)) {
            return this.getEntry(entryId).getField(keys[fieldIndex]);
        }
        return this.getField(keys[fieldIndex]);
    }

    @JsonIgnore
    public boolean isEntry(String id) {
        return this.entryMap.containsKey(id);
    }

    public List<Field> getListSearchField() {
        return this.listSearchField;
    }

    public void setListSearchField(List<Field> listSearchField) {
        this.listSearchField = listSearchField;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
        if (entries != null) {
            for (Entry entry : entries) {
                entry.setMainMetadata(this);
            }
        }
    }

    public Map<String, Entry> getEntryMap() {
        return this.entryMap;
    }

    public void setEntryMap(Map<String, Entry> entryMap) {
        this.entryMap = entryMap;
    }

    public static class OrmMapKv {
        private String id;
        private String entryId;
        private String displayOrm;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getEntryId() {
            return this.entryId;
        }

        public void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        public String getDisplayOrm() {
            return this.displayOrm;
        }

        public void setDisplayOrm(String displayOrm) {
            this.displayOrm = displayOrm;
        }
    }
}

