/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.MixControl;
import kd.occ.ocepfp.core.form.control.controls.DataGrid;
import kd.occ.ocepfp.core.form.control.controls.Operation;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.metadata.Entry;
import kd.occ.ocepfp.core.metadata.Field;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import kd.occ.ocepfp.core.metadata.Metadata;
import kd.occ.ocepfp.core.metadata.MetadataFactory;

public class MetadataBuilder {
    public static final MainMetadata build(ExtWebContext extCtx, PageView pageView) {
        if (pageView == null) {
            return null;
        }
        MainMetadata mainMetadata = MetadataBuilder.buildHeader(extCtx, pageView);
        MetadataBuilder.buildEntry(extCtx, mainMetadata, pageView);
        return mainMetadata;
    }

    private static final MainMetadata buildHeader(ExtWebContext extCtx, PageView pageView) {
        int operationSize;
        MainMetadata mainMetadata = MainMetadata.create(pageView.getViewId(), pageView.getName(), pageView.getBillViewType(), pageView.getBillDataType(), pageView.getTableName(), pageView.getPkField(), pageView.getDbRoute());
        mainMetadata.setPkType(pageView.getPkType());
        if (StringUtil.isNotNull((String)pageView.getBaseViewId()) && !pageView.getBaseViewId().equalsIgnoreCase(pageView.getViewId())) {
            mainMetadata.setBaseMetadataId(pageView.getBaseViewId());
            MainMetadata baseViewMetadata = MetadataFactory.getMetadata(extCtx, pageView.getBaseViewId());
            if (baseViewMetadata != null) {
                mainMetadata.setBillNoField(baseViewMetadata.getBillNoField());
            }
        }
        if ((operationSize = pageView.getOperatios().size()) > 0) {
            ArrayList<Operation> operationList = new ArrayList<Operation>(operationSize);
            for (Map.Entry<String, Control> entry : pageView.getOperatios().entrySet()) {
                operationList.add((Operation)entry.getValue());
            }
            mainMetadata.setOperationList(operationList);
        }
        Map<String, Control> controlMap = pageView.getPageBody().getTopElement();
        for (Map.Entry<String, Control> entry : controlMap.entrySet()) {
            MetadataBuilder.build(extCtx, mainMetadata, entry.getValue(), null, true);
        }
        return mainMetadata;
    }

    private static final void buildEntry(ExtWebContext extCtx, MainMetadata mainMetadata, PageView pageView) {
        List<String> dataGridIdList = pageView.getPageBody().getDataGridIds();
        if (dataGridIdList == null || dataGridIdList.size() == 0) {
            return;
        }
        HashMap<String, Entry> _addedEntry = new HashMap<String, Entry>(4);
        for (String dataGridId : dataGridIdList) {
            DataGrid dataGrid = (DataGrid)pageView.getPageBody().getControl(dataGridId);
            Entry entry = Entry.create(dataGridId, dataGrid.getPkField());
            entry.setMainMetadata(mainMetadata);
            entry.setTableName(dataGrid.getTableName()).setPkField(dataGrid.getPkField());
            entry.setName(dataGrid.getName());
            MetadataBuilder.build(extCtx, entry, dataGrid, null, false);
            if (StringUtil.isNotNull((String)dataGrid.getParentDataGrid())) {
                Entry parentEntry = (Entry)_addedEntry.get(dataGrid.getParentDataGrid().toLowerCase());
                if (parentEntry == null) continue;
                entry.setParentDataGrid(dataGrid.getParentDataGrid());
                parentEntry.setSubEntry(entry);
                mainMetadata.addEntryMap(entry);
                continue;
            }
            mainMetadata.addEntry(entry);
            _addedEntry.put(dataGridId, entry);
        }
        _addedEntry.clear();
    }

    private static final void build(ExtWebContext extCtx, Metadata mainMetadata, Control parentControl, Field parentField, boolean isFromHead) {
        if (parentControl.isFilterField() || "QueryFilter".equalsIgnoreCase(parentControl.getType()) || isFromHead && ("DataGrid".equalsIgnoreCase(parentControl.getType()) || "List".equalsIgnoreCase(parentControl.getType())) || StringUtil.isNotNull((String)parentControl.getDepend())) {
            return;
        }
        if (parentControl.getElementType() != null && parentControl.getElementType().equalsIgnoreCase("form")) {
            parentField = mainMetadata.addField(extCtx, parentControl);
        }
        if (parentControl.hasChild()) {
            List<Control> mixControl = ((MixControl)parentControl).getChilds();
            if (mixControl != null && mixControl.size() == 0) {
                return;
            }
            boolean isBillStatus = parentControl.getType().equals("BillStatus");
            if (mixControl != null) {
                for (Control childControl : mixControl) {
                    if (isBillStatus) {
                        parentField.getValues().add((SimpleMap<String, Object>)childControl.getProperties());
                        continue;
                    }
                    MetadataBuilder.build(extCtx, mainMetadata, childControl, parentField, isFromHead);
                }
            }
        }
    }
}

