/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.orm;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.form.view.parser.PageViewBuilder;
import kd.occ.ocepfp.core.metadata.Entry;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import kd.occ.ocepfp.core.orm.IOrm;
import kd.occ.ocepfp.core.orm.nextcloud.NextCloudOrm;
import org.dom4j.DocumentException;

public class OrmBuilder {
    private static final ConcurrentMap<String, String> _VersionCache = new ConcurrentHashMap<String, String>(100);
    private IOrm orm;
    private PageView pageView;
    private String version;

    public static final void buildMetadata(ExtWebContext webCtx, String viewId, boolean forceReBuild) {
        try {
            PageView pageView = PageViewBuilder.getPageView(webCtx, viewId);
            OrmBuilder.buildMetadata(pageView, pageView.getVersion(), forceReBuild);
        }
        catch (IllegalAccessException | InstantiationException | DocumentException e) {
            e.printStackTrace();
        }
    }

    public static final void buildMetadata(PageView pageView, String newVersion) {
        OrmBuilder.buildMetadata(pageView, newVersion, false);
    }

    public static final void buildMetadata(PageView pageView, String newVersion, boolean forceReBuild) {
        String key = OrmBuilder.getCacheKey(pageView.getViewId());
        String localVersion = (String)_VersionCache.get(key);
        if (forceReBuild || StringUtil.isNull((String)localVersion) || !newVersion.equalsIgnoreCase(localVersion)) {
            OrmBuilder ormBuilder = OrmBuilder.getOrmBuilder();
            ormBuilder.version = newVersion;
            ormBuilder.build(pageView);
            _VersionCache.put(key, newVersion);
        }
    }

    public static final void cleanMetadata(String viewId) {
        String key = OrmBuilder.getCacheKey(viewId);
        _VersionCache.remove(key);
    }

    private static final OrmBuilder getOrmBuilder() {
        OrmBuilder ormBuilder = new OrmBuilder();
        ormBuilder.orm = new NextCloudOrm();
        return ormBuilder;
    }

    public final void build(PageView pageView) {
        MainMetadata metadata = pageView.getMetadata();
        this.pageView = pageView;
        this.orm.createMainMetadata(pageView);
        this.orm.createMainField(metadata.getFieldList());
        this.buildMainEntity();
        this.orm.afterCreateMain();
        this.orm.persistent(metadata, this.version);
    }

    private final void buildMainEntity() {
        List<Entry> entries = this.pageView.getMetadata().getEntries();
        if (entries != null && entries.size() > 0) {
            for (Entry entry : entries) {
                this.orm.createMainEntry(entry);
            }
        }
    }

    private static final String getCacheKey(String viewId) {
        return String.format("%s.%s", CacheKeyUtil.getAcctId(), viewId.toLowerCase());
    }
}

