/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.orm.cache;

import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.IDataEntityBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.core.orm.nextcloud.NextCloudEntityMetadataCache;

public class FormDataCacheManager {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bbcbilldata");
    private String viewId;
    private String pageId;
    private MainEntityType dt;

    public static final FormDataCacheManager getDataModelCache(ExtWebContext webCtx, String viewId, String pageId) {
        return new FormDataCacheManager(webCtx, viewId, pageId);
    }

    public FormDataCacheManager(ExtWebContext webCtx, String viewId, String pageId) {
        this.viewId = viewId.toLowerCase();
        this.pageId = pageId;
        this.dt = NextCloudEntityMetadataCache.getDataEntityType(webCtx, viewId);
    }

    private String getRootCacheKey() {
        return String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), this.viewId, this.pageId);
    }

    private String getEntryCacheKey(String entryKey) {
        return String.format("%s.%s.%s.%s", CacheKeyUtil.getAcctId(), this.viewId, entryKey, this.pageId);
    }

    public DynamicObject getRootDataEntity() {
        return this.getRootDataEntity(true);
    }

    private DynamicObject getRootDataEntity(boolean throwError) {
        String strMain = (String)cache.get(this.getRootCacheKey());
        if (StringUtils.isEmpty((CharSequence)strMain)) {
            if (!throwError) {
                return null;
            }
            throw new KDException(new ErrorCode("###", ResManager.loadKDString((String)"\u9875\u9762\u672a\u521d\u59cb\u5316\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00---\u4ece\u7f13\u5b58\u8bfb\u53d6\u6a21\u578b\u6570\u636e\u5931\u8d25\u3002", (String)"602753474706276352", (SubSystemType)SubSystemType.SL, (Object[])new Object[0])), new Object[]{this.getRootCacheKey()});
        }
        DynamicObject rootDataEntity = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)strMain, (IDataEntityType)this.dt);
        return rootDataEntity;
    }

    public void saveAll(DynamicObject dataEntity) {
        this.saveRootDataEntity(dataEntity);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(true);
        option.setIncludeDataEntityState(true);
        for (ICollectionProperty prop : this.dt.getProperties().getCollectionProperties(false)) {
            DynamicObjectCollection cols = (DynamicObjectCollection)prop.getValueFast((Object)dataEntity);
            String[] strRows = DataEntitySerializer.serializerToListString((IDataEntityType)prop.getItemType(), (List)cols, (DataEntitySerializerOption)option);
            this.setCache(prop, strRows);
        }
    }

    private void setCache(ICollectionProperty prop, String[] strRows) {
        cache.remove(this.getEntryCacheKey(prop.getName()));
        if (strRows.length > 0) {
            cache.addList(this.getEntryCacheKey(prop.getName()), strRows, CacheKeyUtil.getPageCacheKeyTimeout());
        }
    }

    public void saveEntry(DynamicObjectCollection cols) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(true);
        option.setIncludeDataEntityState(true);
        String[] strRows = DataEntitySerializer.serializerToListString((IDataEntityType)cols.getDynamicObjectType(), (List)cols, (DataEntitySerializerOption)option);
        cache.remove(this.getEntryCacheKey(cols.getDynamicObjectType().getName()));
        if (strRows.length > 0) {
            cache.addList(this.getEntryCacheKey(cols.getDynamicObjectType().getName()), strRows, CacheKeyUtil.getPageCacheKeyTimeout());
            cache.getList(this.getEntryCacheKey(cols.getDynamicObjectType().getName()));
        }
    }

    public void saveRootDataEntity(DynamicObject dataEntity) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(false);
        option.setIncludeDataEntityState(true);
        option.setDataEntityBinder(new IDataEntityBinder(){

            public boolean isSerializProperty(IDataEntityProperty prop, DataEntitySerializerOption option) {
                if (prop instanceof DynamicLocaleProperty) {
                    return true;
                }
                if (prop instanceof MulBasedataProp) {
                    return true;
                }
                return super.isSerializProperty(prop, option);
            }
        });
        String main = DataEntitySerializer.serializerToString((Object)dataEntity, (DataEntitySerializerOption)option);
        cache.put(this.getRootCacheKey(), (Object)main, CacheKeyUtil.getPageCacheKeyTimeout());
    }

    public DynamicObject getAll() {
        DynamicObject dataEntity = this.getRootDataEntity(true);
        for (ICollectionProperty prop : this.dt.getProperties().getCollectionProperties(false)) {
            if (prop instanceof DynamicLocaleProperty || prop instanceof MulBasedataProp) continue;
            DynamicObjectCollection cols = (DynamicObjectCollection)prop.getValueFast((Object)dataEntity);
            String[] strRows = this.getCache(prop.getName());
            IDataEntityType itemType = prop.getItemType();
            DataEntitySerializer.deserializerFromListString((List)cols, (IDataEntityType)itemType, (String[])strRows);
            this.setSeq(cols.getStartRowIndex(), (List<DynamicObject>)cols, itemType);
        }
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{dataEntity}, (IDataEntityType)dataEntity.getDataEntityType());
        return dataEntity;
    }

    private String[] getCache(String key) {
        return cache.getList(this.getEntryCacheKey(key));
    }

    private List<DynamicObject> setSeq(int start, List<DynamicObject> cols, IDataEntityType itemType) {
        IDataEntityProperty propSeq = (IDataEntityProperty)itemType.getProperties().get((Object)"seq");
        if (propSeq != null) {
            for (int i = 0; i < cols.size(); ++i) {
                propSeq.setValueFast((Object)cols.get(i), (Object)(start + i + 1));
            }
        }
        return cols;
    }
}

