/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.orm.cache;

import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.occ.ocepfp.common.entity.RowData;
import kd.occ.ocepfp.common.util.PageSizeUtil;
import kd.occ.ocepfp.common.util.StringUtil;

public class ListDataCacheManager {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bbclistdata");

    public static String getCacheId(String pageId) {
        return (String)cache.get(ListDataCacheManager.getCacheKey(pageId));
    }

    public static boolean isCached(String pageId) {
        return StringUtil.isNotNull((String)ListDataCacheManager.getCacheId(pageId));
    }

    public static void cacheVersion(String pageId, String version) {
        cache.put(ListDataCacheManager.getVersionCacheKey(pageId), (Object)version);
    }

    public static boolean isOutOfVersion(String pageId, String version) {
        String oldVersion = (String)cache.get(ListDataCacheManager.getVersionCacheKey(pageId));
        if (StringUtil.isNull((String)oldVersion)) {
            return true;
        }
        return !oldVersion.equals(version);
    }

    public static void cacheData(String pageId, int pageSize, List<Row> rows) {
        if (rows != null && rows.size() > 0) {
            int timeout = CacheKeyUtil.getPageCacheKeyTimeout();
            CacheHint cacheHint = new CacheHint();
            cacheHint.setTimeout((long)timeout, TimeUnit.SECONDS);
            CachedDataSetBuilder cacheBuilder = new CachedDataSetBuilder(((AbstractRow)rows.get(0)).getRowMeta(), cacheHint, ListDataCacheManager.class.getClass().getName() + ".cacheData.rows");
            cacheBuilder.append(rows.iterator());
            CachedDataSet cachedDataSet = cacheBuilder.build();
            String cacheId = cachedDataSet.getCacheId();
            cache.put(ListDataCacheManager.getCacheKey(pageId), (Object)cacheId, timeout);
        } else {
            cache.remove(ListDataCacheManager.getCacheKey(pageId));
        }
    }

    public static RowData getData(String pageId, int page, int pageSize) {
        String cacheId = ListDataCacheManager.getCacheId(pageId);
        if (StringUtil.isNotNull((String)cacheId)) {
            RowData rowData = new RowData();
            CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheId);
            rowData.setRowCount(cachedDataSet.getRowCount());
            rowData.setLimitRows(cachedDataSet.getList(PageSizeUtil.getStart((int)page, (int)pageSize), pageSize));
            return rowData;
        }
        return null;
    }

    public static int getDataCount(String pageId) {
        String cacheId = ListDataCacheManager.getCacheId(pageId);
        if (StringUtil.isNotNull((String)cacheId)) {
            CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheId);
            return cachedDataSet.getRowCount();
        }
        return 0;
    }

    private static String getCacheKey(String pageId) {
        return "listids_" + pageId;
    }

    private static String getVersionCacheKey(String pageId) {
        return "listversion_" + pageId;
    }
}

