/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.orm.ext;

import java.util.ArrayList;
import java.util.List;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.event.filter.QueryFilter;
import kd.occ.ocepfp.core.form.event.filter.QueryFilterParam;
import kd.occ.ocepfp.core.metadata.Field;
import kd.occ.ocepfp.core.metadata.Metadata;
import kd.occ.ocepfp.core.metadata.MetadataFactory;
import kd.occ.ocepfp.core.orm.alias.TableAlias;
import kd.occ.ocepfp.core.orm.alias.TableAliasManager;
import kd.occ.ocepfp.core.orm.ext.SqlBuilderParameter;
import kd.occ.ocepfp.core.orm.ext.SqlSyntax;

public class SqlBuilder {
    private Metadata mainMetadata;
    private ExtWebContext extCtx;
    private TableAliasManager tableAlias = TableAliasManager.getInstance();
    private StringBuffer joinTableStr = new StringBuffer();
    private StringBuffer selectFieldStr = new StringBuffer();
    private StringBuffer filterStr = null;
    private List<SqlBuilderParameter> builderParameterList = null;

    public static final SqlBuilder create(ExtWebContext extCtx, String viewId) {
        return SqlBuilder.create(extCtx, MetadataFactory.getMetadata(extCtx, viewId));
    }

    public static final SqlBuilder create(ExtWebContext extCtx, Metadata metadata) {
        SqlBuilder joinTable = new SqlBuilder();
        joinTable.setMainMetadata(metadata);
        joinTable.from(metadata);
        joinTable.setExtCtx(extCtx);
        return joinTable;
    }

    public final SqlBuilder filter(QueryFilter queryFilter) {
        this.buildFilter(queryFilter.getFilter());
        return this;
    }

    public final SqlBuilder selectField(List<String> selectedFields) {
        if (selectedFields != null) {
            for (String showFieldOrm : selectedFields) {
                String[] fields = showFieldOrm.split("\\.");
                this.selectField(fields);
            }
        }
        return this;
    }

    public final String getSql() {
        String sql = "SELECT " + this.selectFieldStr.toString() + " " + this.joinTableStr.toString();
        if (this.filterStr.length() > 0) {
            sql = sql + " WHERE " + this.filterStr.toString();
        }
        return sql;
    }

    public final SField selectField(String[] orms) {
        return this.buildField(orms, true);
    }

    public final SField selectField(String orms) {
        return this.selectField(orms.split("\\."));
    }

    private final void buildFilter(List<QueryFilterParam> queryFilterList) {
        if (queryFilterList != null) {
            int max = queryFilterList.size() - 1;
            int i = 0;
            while (true) {
                QueryFilterParam queryFilter = queryFilterList.get(i);
                Object[] orms = queryFilter.getOrmKey().split("\\.");
                SField filterField = this.buildFilterField((String[])orms);
                String paramName = StringUtil.join((Object[])orms, (String)"_");
                if (filterField != null) {
                    this.getFilterStr().append(SqlSyntax.where(filterField.field, queryFilter.getSqlCompareOperator(), paramName));
                    this.addParameter(paramName, filterField.type);
                }
                if (i == max) break;
                this.getFilterStr().append(queryFilter.getSqlLogicalOperator().getValue());
                ++i;
            }
        }
    }

    private final SField buildFilterField(String[] orms) {
        return this.buildField(orms, false);
    }

    private final SField buildField(String[] orms, boolean needAddSelected) {
        return null;
    }

    private final SField buildField(String[] orms, int start, Metadata parentMetadata, Field parenViewField, boolean needAddSelected) {
        return null;
    }

    private StringBuffer addSelectField(String field) {
        if (this.selectFieldStr.length() > 0) {
            this.selectFieldStr.append(",");
        }
        this.selectFieldStr.append(field);
        return this.selectFieldStr;
    }

    private void leftJoin(Metadata metadata, String[] orm, int start) {
        TableAlias parentTableAlias = this.tableAlias.getAlias(StringUtil.join((Object[])orm, (int)(start - 1), (String)","));
        TableAlias currentTableAlias = this.tableAlias.getAlias(StringUtil.join((Object[])orm, (int)start, (String)","), metadata.getTableName(), metadata.getPkField());
        if (parentTableAlias != null) {
            this.joinTableStr.append(SqlSyntax.leftJoin(metadata.getTableName(), currentTableAlias.getTableAlias(), metadata.getPkField(), parentTableAlias.getTableAlias(), parentTableAlias.getPkField()));
        }
    }

    private void from(Metadata metadata) {
        this.joinTableStr.append(SqlSyntax.from(metadata.getTableName(), this.tableAlias.getAlias("", metadata.getTableName(), metadata.getPkField()).getTableAlias()));
    }

    private void addParameter(String name, String type) {
        if (this.builderParameterList == null) {
            this.builderParameterList = new ArrayList<SqlBuilderParameter>();
        }
        this.builderParameterList.add(new SqlBuilderParameter(":" + name, type));
    }

    private StringBuffer getFilterStr() {
        if (this.filterStr == null) {
            this.filterStr = new StringBuffer();
        }
        return this.filterStr;
    }

    public List<SqlBuilderParameter> getBuilderParameterList() {
        return this.builderParameterList;
    }

    public Metadata getMainMetadata() {
        return this.mainMetadata;
    }

    public void setMainMetadata(Metadata mainMetadata) {
        this.mainMetadata = mainMetadata;
    }

    public ExtWebContext getExtCtx() {
        return this.extCtx;
    }

    public void setExtCtx(ExtWebContext extCtx) {
        this.extCtx = extCtx;
    }

    public static class SField {
        private String field;
        private String type;

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public SField(String field, String type) {
            this.field = field;
            this.type = type;
        }
    }
}

