/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.orm.nextcloud;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.RuntimeEntityMeta;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.entity.operation.OperationParameter;
import kd.bos.metadata.entity.validation.Validation;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.occ.ocepfp.common.constant.BillDataType;
import kd.occ.ocepfp.common.constant.ExtDbRouter;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.entity.UniqueRowUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.metadata.Entry;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import kd.occ.ocepfp.core.orm.IOrm;
import kd.occ.ocepfp.core.orm.nextcloud.field.NextCloudOrmFieldFactory;
import kd.occ.ocepfp.core.orm.nextcloud.parameter.NextCloudOPParamFactory;
import kd.occ.ocepfp.core.orm.nextcloud.validation.NextCloudValidationFactory;

public class NextCloudOrm
implements IOrm {
    private static final Map<String, String> _BillTypeMap = new HashMap<String, String>(4);
    private static final String mainKey = "_drp_ext_";
    private EntityMetadata entityMetadata;
    private FormMetadata formMetadata;
    private String modelType;
    private PageView pageView;

    @Override
    public void createMainMetadata(PageView pageView) {
        try {
            this.pageView = pageView;
            MainMetadata metadata = pageView.getMetadata();
            this.modelType = this.getBillDataType(metadata);
            this.formMetadata = new FormMetadata();
            EntityMetadata entityMetadata = new EntityMetadata();
            List items = entityMetadata.getItems();
            items.add(this.createBaseEntity(metadata));
            this.entityMetadata = entityMetadata;
        }
        catch (Exception e) {
            LogUtil.info(this.getClass(), (Throwable)e);
        }
    }

    public void setFormRootAp(MainMetadata metadata) {
        FormAp formAp = new FormAp();
        formAp.setKey(metadata.getViewId());
        LocaleString localeString = new LocaleString();
        localeString.setLocaleValue(metadata.getName());
        formAp.setName(localeString);
        formAp.setId(mainKey + this.pageView.getViewId().toLowerCase());
        formAp.setPkId("id");
        formAp.setEntity((Entity)this.entityMetadata.getRootEntity());
        this.formMetadata.setRootAp(formAp);
        this.formMetadata.setBizappId("18OYV6FTPLE6");
        this.formMetadata.setDevType("0");
        this.formMetadata.setKey(metadata.getViewId());
        this.formMetadata.setName(localeString);
        this.formMetadata.setModelType(this.modelType);
        this.formMetadata.getItems().add(formAp);
        this.formMetadata.setId(mainKey + this.pageView.getViewId().toLowerCase());
    }

    private MainEntity getRootEntity(MainMetadata metadata) {
        switch (this.modelType) {
            case "BaseFormModel": {
                BaseEntity baseEntity = new BaseEntity();
                baseEntity.setNameFieldId("name");
                baseEntity.setPkFieldName(metadata.getPkField());
                baseEntity.setNumberFieldId(metadata.getBillNoField() != null ? metadata.getBillNoField().getId() : "");
                baseEntity.setTableName(metadata.getTableName());
                return baseEntity;
            }
            case "BillFormModel": {
                BillEntity billEntity = new BillEntity();
                billEntity.setPkFieldName(metadata.getPkField());
                billEntity.setTableName(metadata.getTableName());
                return billEntity;
            }
        }
        MainEntity mainEntity = new MainEntity();
        return mainEntity;
    }

    private MainEntity createBaseEntity(MainMetadata metadata) {
        MainEntity rootEntity = this.getRootEntity(metadata);
        rootEntity.setdbRoute(this.pageView.getMetadata().getDbRoute());
        rootEntity.setKey(metadata.getViewId());
        rootEntity.setPkType(metadata.getPkType());
        if (this.modelType == null || !this.modelType.equalsIgnoreCase("DynamicFormModel")) {
            rootEntity.setTableName(metadata.getTableName());
        }
        rootEntity.setEntityMetadata(this.entityMetadata);
        LocaleString localeString = new LocaleString();
        localeString.setLocaleValue(metadata.getName());
        rootEntity.setName(localeString);
        this.createOperation(rootEntity);
        return rootEntity;
    }

    @Override
    public void createMainField(List<kd.occ.ocepfp.core.metadata.Field> fields) {
        this.createField(mainKey + this.pageView.getMetadata().getViewId(), null, fields);
    }

    @Override
    public void createMainEntry(Entry entry) {
        EntryEntity entryEntity = this.creatEntryHead(entry);
        this.createEntryField(entry, entryEntity);
        this.entityMetadata.getItems().add(entryEntity);
        if (entry.getSubEntry() != null) {
            EntryEntity subEntryEntity = this.creatEntryHead(entry.getSubEntry());
            subEntryEntity.setParentId(entryEntity.getId());
            this.createEntryField(entry.getSubEntry(), subEntryEntity);
            this.entityMetadata.getItems().add(subEntryEntity);
        }
    }

    public void createEntryField(Entry entry, EntryEntity entryEntity) {
        entryEntity.getItems().add(this.addUqrowEntryField(entry, entryEntity.getId()));
        this.createField(mainKey + this.pageView.getMetadata().getViewId() + "_" + entry.getId(), entryEntity.getItems(), entry.getFieldList());
    }

    private Field<?> addUqrowEntryField(Entry entry, String parentEntryId) {
        IntegerField newField = new IntegerField();
        newField.setId(UniqueRowUtil.getPropertyName((String)entry.getId()));
        newField.setKey(newField.getId());
        LocaleString localeString = new LocaleString();
        localeString.setLocaleValue("");
        newField.setName(localeString);
        newField.setParentId(parentEntryId);
        this.entityMetadata.getItems().add(newField);
        return newField;
    }

    private Field<?> addSelectedEntryField(Entry entry, String parentEntryId) {
        IntegerField newField = new IntegerField();
        newField.setId(UniqueRowUtil.getPropertyName((String)entry.getId()));
        newField.setKey(newField.getId());
        LocaleString localeString = new LocaleString();
        localeString.setLocaleValue("");
        newField.setName(localeString);
        newField.setParentId(parentEntryId);
        this.entityMetadata.getItems().add(newField);
        return newField;
    }

    private EntryEntity creatEntryHead(Entry entry) {
        EntryEntity entryEntity = new EntryEntity();
        entryEntity.setId(mainKey + this.pageView.getMetadata().getViewId() + "_" + entry.getId());
        entryEntity.setTableName(entry.getTableName());
        entryEntity.setKey(entry.getId());
        entryEntity.setdbRoute(ExtDbRouter.EXT.getRouteKey());
        entryEntity.setEntryPkFieldName(entry.getPkField());
        entryEntity.setEntityMetadata(this.entityMetadata);
        entryEntity.setParentId(mainKey + this.pageView.getMetadata().getViewId());
        LocaleString localeString = new LocaleString();
        localeString.setLocaleValue(StringUtil.isNull((String)entry.getName()) ? "" : entry.getName());
        entryEntity.setName(localeString);
        return entryEntity;
    }

    private void createField(String parentId, List<EntityItem<?>> items, List<kd.occ.ocepfp.core.metadata.Field> fields) {
        if (fields != null && fields.size() > 0) {
            for (kd.occ.ocepfp.core.metadata.Field field : fields) {
                if (field.getId().equalsIgnoreCase("id")) continue;
                Field ormField = (Field)NextCloudOrmFieldFactory.create(field, this.pageView);
                if (StringUtil.isNotNull((String)parentId)) {
                    ormField.setParentId(parentId);
                }
                this.entityMetadata.getItems().add(ormField);
            }
        }
    }

    private void createOperation(MainEntity rootEntity) {
        List<kd.occ.ocepfp.core.form.control.controls.Operation> operations = this.pageView.getMetadata().getOperationList();
        for (kd.occ.ocepfp.core.form.control.controls.Operation ops : operations) {
            Operation o = new Operation();
            o.setId(ops.getId());
            o.setKey(ops.getId());
            o.setOperationType(ops.getIService());
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(ops.getName());
            o.setName(localeString);
            List<kd.occ.ocepfp.core.form.control.controls.Plugin> plugins = ops.getPlugins();
            for (kd.occ.ocepfp.core.form.control.controls.Plugin splugin : plugins) {
                Plugin plugin = new Plugin();
                plugin.setClassName(splugin.getClassName());
                plugin.setEnabled(true);
                o.getPlugins().add(plugin);
            }
            OperationParameter parameter = NextCloudOPParamFactory.build(ops.getId(), ops.getParamter());
            if (parameter != null) {
                o.setParameter(parameter);
            }
            SimpleMap<String, SimpleMap<String, String>> validations = ops.getValidations();
            for (Map.Entry validationMap : validations.entrySet()) {
                Validation validation = NextCloudValidationFactory.build(((SimpleMap)validationMap.getValue()).getString("iservice"), (SimpleMap<String, String>)((SimpleMap)validationMap.getValue()));
                if (validation == null) continue;
                o.getValidations().add(validation);
            }
            rootEntity.getOperations().add(o);
        }
    }

    private String getBillDataType(MainMetadata metadata) {
        return _BillTypeMap.get(metadata.getBillDataType().toLowerCase());
    }

    @Override
    public void afterCreateMain() {
        this.entityMetadata.setModelType(this.modelType);
        this.entityMetadata.setBizappId("18OYV6FTPLE6");
        this.entityMetadata.setDevType("0");
        this.entityMetadata.setId(mainKey + this.pageView.getMetadata().getViewId().toLowerCase());
        this.entityMetadata.setKey(this.pageView.getMetadata().getViewId().toLowerCase());
    }

    @Override
    public void persistent(MainMetadata metadata, String version) {
        try (TXHandle txh = TX.requiresNew();){
            try {
                this.setFormRootAp(metadata);
                IDataEntityType runtimeFormMetaType = OrmUtils.getDataEntityType(RuntimeFormMeta.class);
                List a = this.formMetadata.buildRuntimeMetadata(version);
                this.deleteRuntimeForm(runtimeFormMetaType, this.formMetadata.getId());
                BusinessDataWriter.save((IDataEntityType)runtimeFormMetaType, (Object[])a.toArray());
                IDataEntityType runtimeEntityMetaType = OrmUtils.getDataEntityType(RuntimeEntityMeta.class);
                this.deleteRuntimeMeta(runtimeEntityMetaType, this.entityMetadata.getId());
                this.clearCache((AbstractMetadata)this.entityMetadata);
                this.entityMetadata.beginInit();
                List entityRuntimeMetas = this.entityMetadata.buildRuntimeMetadata(version);
                BusinessDataWriter.save((IDataEntityType)runtimeEntityMetaType, (Object[])entityRuntimeMetas.toArray());
                List errorInfoList = this.entityMetadata.getBuildErrors();
                if (errorInfoList != null && errorInfoList.size() > 0) {
                    for (ErrorInfo errorInfo : errorInfoList) {
                        System.out.println(errorInfo.getError());
                        LogUtil.info(NextCloudOrm.class, (String)errorInfo.getError());
                    }
                }
                this.entityMetadata.endInit();
                this.clearCache((AbstractMetadata)this.entityMetadata);
            }
            catch (Throwable e) {
                LogUtil.info(this.getClass(), (Throwable)e);
                txh.markRollback();
            }
        }
    }

    private void deleteRuntimeMeta(IDataEntityType runtimeMetaType, String id) {
        final ArrayList sqlParams = new ArrayList();
        DBRoute dbRoute = new DBRoute(runtimeMetaType.getDBRouteKey());
        String readSql = "select fnumber, fkey, ftype from " + runtimeMetaType.getAlias() + " where FID = ? ";
        SqlParameter idParam = new SqlParameter("FID", 12, (Object)id.toLowerCase());
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String number = rs.getString(1);
                    String key = rs.getString(2);
                    int type = rs.getInt(3);
                    SqlParameter[] params = new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)number), new SqlParameter("FKEY", 12, (Object)key), new SqlParameter("FTYPE", 4, (Object)type)};
                    sqlParams.add(params);
                }
                return true;
            }
        };
        DB.query((DBRoute)dbRoute, (String)readSql, (Object[])new SqlParameter[]{idParam}, (ResultSetHandler)action);
        if (!sqlParams.isEmpty()) {
            String deleteSql = "delete from " + runtimeMetaType.getAlias() + " where fnumber = ? and fkey = ? and ftype = ?";
            DB.executeBatch((DBRoute)dbRoute, (String)deleteSql, sqlParams);
        }
    }

    private void deleteRuntimeForm(IDataEntityType runtimeFormMetaType, String id) {
        DBRoute dbRoute = new DBRoute(runtimeFormMetaType.getDBRouteKey());
        String deleteSql = "delete from " + runtimeFormMetaType.getAlias() + " where FID = ? ";
        Object[] param = new SqlParameter[]{new SqlParameter("FID", 12, (Object)id.toLowerCase())};
        DB.execute((DBRoute)dbRoute, (String)deleteSql, (Object[])param);
    }

    private void clearCache(AbstractMetadata metadata) {
        if (metadata instanceof EntityMetadata) {
            EntityMetadata entityMetadata = (EntityMetadata)metadata;
            MetaCacheUtils.removeDistributeCache((String[])new String[]{entityMetadata.getOldKey()});
            MetaCacheUtils.removeDistributeCache((String[])new String[]{entityMetadata.getKey()});
            MetaCacheUtils.removeDistributeCache((String)metadata.getId(), (String)"entitynumber", (int)0);
            EntityMetadataCache.removeDataEntityTypeLocalCache((String)entityMetadata.getKey());
            MainEntity rootEntity = entityMetadata.getRootEntity();
            if (StringUtils.isNotBlank((CharSequence)rootEntity.getTableName())) {
                DataEntityCacheManager cm = new DataEntityCacheManager(rootEntity.getTableName());
                cm.removeByDt();
            }
        }
    }

    static {
        _BillTypeMap.put(BillDataType.BaseData.getValue(), "BaseFormModel");
        _BillTypeMap.put(BillDataType.BillData.getValue(), "BillFormModel");
        _BillTypeMap.put(BillDataType.Custom.getValue(), "DynamicFormModel");
    }
}

