/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.orm.nextcloud.field;

import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.property.RefProp;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.metadata.Field;
import kd.occ.ocepfp.core.orm.nextcloud.field.IOrmFieldBuilder;

public class BaseDataFieldBuilder
implements IOrmFieldBuilder {
    @Override
    public Object create(Field field, Object newInstance, PageView pageView) {
        BasedataField newField = (BasedataField)newInstance;
        newField.setId(field.getId());
        newField.setKey(field.getId());
        newField.setFieldName(field.getField());
        newField.setDisplayProp("name");
        newField.setMustInput(field.isRequired());
        if (StringUtil.isNotNull((String)field.getBaseViewId())) {
            newField.setBaseEntityId(field.getBaseViewId().toLowerCase());
            this.setCache(field.getBaseViewId().toLowerCase());
        }
        newField.setBizBasedata(true);
        newField.setNumberProp("number");
        this.addRefProp(field, newField);
        newField.setSuffix(field.getSplitTable());
        LocaleString localeString = new LocaleString();
        localeString.setLocaleValue(field.getName());
        newField.setName(localeString);
        newField.setParentId(field.getParentId());
        return newField;
    }

    private void addRefProp(Field field, BasedataField newField) {
        if (StringUtil.isNotNull((String)field.getReform())) {
            String[] refOrms = field.getReform().split(",");
            RefProp refProp = null;
            for (String orm : refOrms) {
                refProp = new RefProp();
                refProp.setName(orm);
                newField.getRefProps().add(refProp);
            }
        }
    }

    private void setCache(final String id) {
        ThreadCache.get((Object)(id + ".entitynumber"), (CacheLoader)new CacheLoader<String>(){

            public String load() {
                String num = MetaCacheUtils.getDistributeCache((String)id, (String)"entitynumber", (int)0);
                if (num != null) {
                    return num;
                }
                num = id;
                if (num != null) {
                    MetaCacheUtils.putDistributeCache((String)id, (String)"entitynumber", (int)0, (String)num);
                }
                return num;
            }
        });
    }
}

