/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.orm.nextcloud.field;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.billstatusfield.StatusItem;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.metadata.Field;
import kd.occ.ocepfp.core.orm.nextcloud.field.IOrmFieldBuilder;

public class BillStatusFieldBuilder
implements IOrmFieldBuilder {
    @Override
    public Object create(Field field, Object newInstance, PageView pageView) {
        return this.createBaseField(field, newInstance);
    }

    private Object createBaseField(Field field, Object newInstance) {
        BillStatusField newField = (BillStatusField)newInstance;
        newField.setId(field.getId());
        newField.setKey(field.getId());
        newField.setFieldName(field.getField());
        newField.setSuffix(field.getSplitTable());
        newField.setMustInput(field.isRequired());
        LocaleString localeString = new LocaleString();
        localeString.setLocaleValue(field.getName());
        newField.setName(localeString);
        newField.setParentId(field.getParentId());
        this.setMaxLength(field, (kd.bos.metadata.entity.commonfield.Field<?>)newField);
        List<StatusItem> statusItems = this.getStatus(field);
        if (statusItems != null) {
            newField.setStatusItems(statusItems);
        }
        return newField;
    }

    private List<StatusItem> getStatus(Field field) {
        List<SimpleMap<String, Object>> values = field.getValues();
        int size = field.getValues().size();
        if (size > 0) {
            ArrayList<StatusItem> statusItems = new ArrayList<StatusItem>(size);
            for (SimpleMap<String, Object> value : values) {
                StatusItem statusItem = new StatusItem();
                statusItem.setStatusKey(value.getString("value"));
                statusItem.setOperationDateKey(value.getString("operationdate"));
                statusItem.setOperationerKey(value.getString("operationer"));
                statusItem.setClearOperationKey(value.getBoolean("isclear", Boolean.valueOf(false)).booleanValue());
                statusItems.add(statusItem);
            }
            return statusItems;
        }
        return null;
    }

    private void setMaxLength(Field field, kd.bos.metadata.entity.commonfield.Field<?> newField) {
        switch (field.getFieldType()) {
            case "Input": {
                ((TextField)newField).setMaxLength(field.getMaxLength());
            }
        }
    }
}

