/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.service.admindivision;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.entity.Country;
import kd.occ.ocepfp.common.entity.RegionChild;
import kd.occ.ocepfp.common.entity.RegionLevel;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.StringUtil;

public class AdminDivisionProcessor {
    private static final String ADMINDIVISIONLEVEL = "bd_admindivisionlevel";
    private static final String ADMINDIVISION = "bd_admindivision";
    private static final String COUNTRY = "bd_country";
    private static final String COUNTRY_COLNAMES = "id,name,fullname,number,simplespell,description,twocountrycode";
    private static Log logger = LogFactory.getLog(AdminDivisionProcessor.class);

    public Country getAdminDivisionLevels(long countryId) {
        Country country = new Country();
        DynamicObject countryInfo = this.getCountryInfoById(countryId);
        if (countryInfo != null) {
            country.setId(countryInfo.getLong("id"));
            country.setName(countryInfo.getString("name"));
        }
        List<DynamicObject> levelInfoList = this.getAdminDivisionLevelByCountry(country.getId());
        ArrayList<RegionLevel> regionLevels = new ArrayList<RegionLevel>(4);
        for (DynamicObject levelInfo : levelInfoList) {
            RegionLevel regionLevel = new RegionLevel(levelInfo.getLong("id"), levelInfo.getString("name"));
            regionLevels.add(regionLevel);
        }
        country.setRegionLevelList(regionLevels);
        return country;
    }

    public RegionLevel getDivisionListByParent(long parentRegionId, long levelId) {
        DynamicObjectCollection divisionList = this.getNextDivisionList(parentRegionId, levelId);
        ArrayList<RegionChild> childList = new ArrayList<RegionChild>(10);
        int isLeaf = 0;
        for (DynamicObject division : divisionList) {
            isLeaf = division.getBoolean("isleaf") ? 1 : 0;
            RegionChild child = new RegionChild(division.getLong("id"), division.getString("name"), isLeaf);
            childList.add(child);
        }
        return new RegionLevel(parentRegionId, levelId, childList);
    }

    public List<DynamicObject> getAdminDivisionLevelByCountry(long countryId) {
        QFilter filter;
        ORM orm = ORM.create();
        DynamicObjectCollection levelList = orm.query(ADMINDIVISIONLEVEL, (filter = new QFilter("country.id", "=", (Object)countryId)).toArray());
        if (levelList.size() > 0) {
            return levelList.stream().sorted(Comparator.comparing(r -> r.getInt("level"))).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>(0);
    }

    public Object getCountryList() {
        DynamicObjectCollection countries = this.getCountryInfoList();
        if (countries == null || countries.size() == 0) {
            return null;
        }
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (DynamicObject country : countries) {
            JSONObject json = new JSONObject();
            json.put("id", (Object)country.getString("id"));
            json.put("name", (Object)country.getString("name"));
            jsonList.add(json);
        }
        return JSONObject.toJSON(jsonList);
    }

    public DynamicObject getCountryInfoById(long countryId) {
        DynamicObject countryInfo = this.getCountryInfo(countryId);
        if (countryInfo == null) {
            return this.getDefaultCountry();
        }
        return countryInfo;
    }

    public DynamicObject getDefaultCountry() {
        DynamicObjectCollection countries = this.getCountryInfoList();
        if (CollectionUtils.isEmpty((Collection)countries)) {
            return null;
        }
        return (DynamicObject)countries.get(0);
    }

    public DynamicObjectCollection getCountryInfoList() {
        QFilter filters = new QFilter("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)COUNTRY, (String)COUNTRY_COLNAMES, (QFilter[])filters.toArray(), (String)"id");
    }

    public DynamicObject getCountryInfo(Object countryId) {
        QFilter filters = new QFilter("enable", "=", (Object)"1");
        filters.and(new QFilter("id", "=", countryId));
        return QueryServiceHelper.queryOne((String)COUNTRY, (String)COUNTRY_COLNAMES, (QFilter[])filters.toArray());
    }

    public DynamicObject getAdminDivisionById(long regionId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)regionId);
        return orm.queryOne(ADMINDIVISION, filter.toArray());
    }

    public DynamicObjectCollection getNextDivisionList(Object parentId, Object levelId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("parent.id", "=", parentId);
        filter.and(new QFilter("basedatafield.id", "=", levelId));
        return orm.query(ADMINDIVISION, filter.toArray());
    }

    public RegionLevel getFirstLevelDivisionList(long countryId) {
        List<DynamicObject> levelInfoList = this.getAdminDivisionLevelByCountry(countryId);
        if (!CollectionUtils.isEmpty(levelInfoList)) {
            long firstLevel = levelInfoList.get(0).getLong("id");
            return this.getDivisionListByParent(0L, firstLevel);
        }
        return new RegionLevel();
    }

    public List<DynamicObject> getParentDivisionList(long adminDivisionId) {
        ArrayList<DynamicObject> divisionList = new ArrayList<DynamicObject>(4);
        this.addParentDivision(divisionList, adminDivisionId);
        return divisionList;
    }

    private void addParentDivision(List<DynamicObject> divisionList, long adminDivisionId) {
        DynamicObject adminDivision = this.getAdminDivision(adminDivisionId);
        if (adminDivision != null) {
            divisionList.add(adminDivision);
            DynamicObject parentAdminDivision = adminDivision.getDynamicObject("parent");
            if (parentAdminDivision != null) {
                this.addParentDivision(divisionList, Convert.toLong((Object)parentAdminDivision.getPkValue()));
            }
        }
    }

    public DynamicObject getAdminDivision(long adminDivisionId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)adminDivisionId);
        return orm.queryOne(ADMINDIVISION, filter.toArray());
    }

    public Object getParentDivisions(long adminDivisionId) {
        List<DynamicObject> divisionList = this.getParentDivisionList(adminDivisionId);
        if (!CollectionUtils.isEmpty(divisionList)) {
            ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>(4);
            for (DynamicObject division : divisionList) {
                JSONObject json = new JSONObject();
                json.put("id", division.getPkValue());
                json.put("name", (Object)division.getString("name"));
                json.put("levelId", (Object)division.getInt("level"));
                jsonList.add(json);
            }
            return JSONObject.toJSON(jsonList);
        }
        return null;
    }

    public String getDivisionNameById(long adminDivisionId) {
        List<Object> divisionList = this.getParentDivisionList(adminDivisionId);
        divisionList = divisionList.stream().sorted(Comparator.comparing(r -> r.getInt("level"))).collect(Collectors.toList());
        return this.getDivisionFullName(divisionList);
    }

    private String getDivisionFullName(List<DynamicObject> divisionList) {
        if (CollectionUtils.isEmpty(divisionList)) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        for (DynamicObject division : divisionList) {
            name.append(division.getString("name"));
        }
        return name.toString();
    }

    private boolean isUseDefaultName(DynamicObject division) {
        DynamicObject country;
        return division == null || (country = division.getDynamicObject("country")) == null || 1000001L == Convert.toLong((Object)country.getPkValue());
    }

    public DynamicObject getDivisionIdByAddress(String nation, String province, String city, String district) {
        DynamicObject adminDivision = this.getDivisionIdByAddress(nation, province, city, district, true);
        if (adminDivision == null) {
            adminDivision = this.getDivisionIdByAddress(nation, province, city, district, false);
        }
        return adminDivision;
    }

    public DynamicObject getDivisionIdByAddress(String nation, String province, String city, String district, boolean isFull) {
        String provinceName = this.getProvinceName(province, isFull);
        String cityName = this.getCityName(city, isFull);
        String districtName = this.getDistrictName(district, isFull);
        StringBuilder nameBuffer = new StringBuilder();
        if (StringUtil.isNotNull((String)provinceName)) {
            nameBuffer.append(provinceName).append("_");
        }
        if (StringUtil.isNotNull((String)cityName)) {
            nameBuffer.append(cityName).append("_");
        }
        if (StringUtil.isNotNull((String)districtName)) {
            nameBuffer.append(districtName).append("_");
        }
        String fullName = "";
        if (nameBuffer.length() > 1) {
            fullName = nameBuffer.toString().substring(0, nameBuffer.length() - 1);
        }
        QFilter filters = new QFilter("fullname", "=", (Object)fullName);
        logger.info(String.format("\u5fae\u4fe1\u5730\u56fe\u67e5\u8be2\u65b0\u653f\u533a\u5212\u7684fulname:%s", fullName));
        DynamicObject adminDivision = ORM.create().queryOne(ADMINDIVISION, filters.toArray());
        long id = adminDivision == null ? 0L : DynamicObjectUtils.getPkValue((DynamicObject)adminDivision);
        logger.info(String.format("\u5fae\u4fe1\u5730\u56fe\u67e5\u8be2\u65b0\u653f\u533a\u5212\u7684ID:%s", id));
        return adminDivision;
    }

    private String getProvinceName(String nationName, boolean isFull) {
        return this.getAdminDivisionName(nationName, (isFull ? "(\\S)" : "") + "([\u7701]|[\u7279][\u522b][\u884c][\u653f][\u533a]|[\u81ea][\u6cbb][\u533a]|[\u5e02])", isFull);
    }

    private String getCityName(String cityName, boolean isFull) {
        return this.getAdminDivisionName(cityName, (isFull ? "(\\S)" : "") + "([\u81ea\u6cbb\u5dde]|[\u533a]|[\u5e02])", isFull);
    }

    private String getDistrictName(String districtName, boolean isFull) {
        return this.getAdminDivisionName(districtName, (isFull ? "(\\S)" : "") + "([\u53bf]|[\u533a]|[\u5e02]|[\u6d77][\u57df]|[\u65d7])", isFull);
    }

    private String getAdminDivisionName(String name, String regex, boolean isFull) {
        Matcher m = Pattern.compile(regex).matcher(name);
        String divisionName = "";
        if (m.find()) {
            divisionName = m.group();
        }
        return isFull ? name : (StringUtil.isNotNull((String)name) ? name.replace(divisionName, "") : "");
    }
}

