/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.service.auxpty;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.flex.FlexService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocepfp.common.entity.Auxpty;
import kd.occ.ocepfp.common.entity.AuxptyValue;
import kd.occ.ocepfp.common.entity.FlexEntity;
import kd.occ.ocepfp.common.entity.FlexMeta;
import kd.occ.ocepfp.common.entity.SpuDetail;
import kd.occ.ocepfp.common.entity.SpuGroup;
import kd.occ.ocepfp.common.util.CollectionUtil;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;

public class AuxptyProcessor {
    private static Log logger = LogFactory.getLog(AuxptyProcessor.class);
    private static final String F_BD_MATERIAL = "bd_material";
    private static final String QUERY_MATERIAL_COLS = "id,isuseauxpty,auxptyentry,auxptyentry.auxpty.id,auxptyentry.iscomcontrol,auxptyentry.isaffectinv,auxptyentry.isaffectprice,auxptyentry.isaffectplan";
    private static final String F_BD_FLEXAUXPROP = "bd_flexauxprop";
    private static final String F_BD_AUXPROPERTY = "bd_auxproperty";
    private static final String F_BD_AUXPTYVALUE = "bd_auxptyvalue";
    private static final String F_DBD_SPU = "ocdbd_spu";
    private static final String sku_detail = "entryentity_specmap";
    private static final String query_spu_cols = "id,name,entryentity_spec,entryentity_spec.specid,entryentity_spec.specvalueid,entryentity_spec.subentryentity_spec,entryentity_spec.subentryentity_spec.specvalueid,entryentity_specmap,entryentity_specmap.id,entryentity_specmap.materielid,entryentity_specmap.auxptyid,entryentity_specmap.itemid,entryentity_specmap.spumapname,entryentity_specmap.spumapnumber";

    public List<FlexProperty> getFlexPropertyByMaterialId(long materialId) {
        DynamicObjectCollection useAuxptyList = this.getUseAuxptyByMaterialId(materialId);
        if (CollectionUtil.isNull((List)useAuxptyList)) {
            return new ArrayList<FlexProperty>();
        }
        List flexList = useAuxptyList.stream().map(r -> r.getLong("auxptyentry.auxpty.id")).collect(Collectors.toList());
        return FlexEntityMetaUtils.getFlexProperty(flexList);
    }

    public DynamicObjectCollection getUseAuxptyByMaterialId(long materialId) {
        QFilter filter = new QFilter("id", "=", (Object)materialId);
        filter.and("isuseauxpty", "=", (Object)"1");
        return QueryServiceHelper.query((String)F_BD_MATERIAL, (String)QUERY_MATERIAL_COLS, (QFilter[])filter.toArray());
    }

    public long getAuxptyId(long materialId, List<LinkedHashMap<String, String>> flexDataList) {
        try {
            FlexEntityType flexFieldEntityType = this.getFlexFieldEntityType(materialId);
            DynamicObject flexFieldVal = new DynamicObject((DynamicObjectType)flexFieldEntityType);
            this.fixFlexValue(flexFieldEntityType, flexDataList, flexFieldVal);
            FlexEntireData flexEntireData = new FlexEntireData();
            flexEntireData.setFlexData((MainEntityType)flexFieldEntityType, flexFieldVal);
            long id = FlexService.saveFlexData((MainEntityType)flexFieldEntityType, (FlexEntireData)flexEntireData);
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)flexFieldEntityType);
            cacheManager.removeByPrimaryKey(new Object[]{flexFieldEntityType.getPrimaryKey().getValue((Object)flexFieldVal)});
            return id;
        }
        catch (Exception e) {
            LogUtil.info(this.getClass(), (Throwable)e);
            logger.error("\u83b7\u53d6\u5f39\u6027\u57dfid\u5931\u8d25\uff0c\u5931\u8d25\u7684\u539f\u56e0\u662f:\n" + e);
            return 0L;
        }
    }

    public FlexEntityType getFlexFieldEntityType(long materialId) {
        List flexPropertyIds = FlexService.getBaseUseFlexProperties((String)F_BD_MATERIAL, (Object)materialId, (String)"auxpty");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocbsoc_saleorder");
        FlexProp flexFieldProperty = (FlexProp)entityType.findProperty("auxptyid");
        int flexTypeId = flexFieldProperty.getFlexTypeId();
        FlexEntityType flexFieldEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)"ocbsoc_saleorder", (String)"auxptyid", (int)flexTypeId, (List)flexPropertyIds);
        return flexFieldEntityType;
    }

    public Auxpty getAuxptyName(long auxptyId) {
        LinkedHashMap<String, String> auxptyValueMap = this.getFlexAuxpropDataMap(auxptyId);
        return new Auxpty(Convert.toString((Object)auxptyId), this.getFlexAuxpropDataName(auxptyValueMap));
    }

    public Map<Long, String> getAuxptyName(List<Long> auxptyIds) {
        Map<Long, String> auxptyValueMap = this.getFlexAuxpropDataMap(auxptyIds);
        return this.getFlexAuxpropDataNameList(auxptyValueMap);
    }

    public List<String> getAuxptyNameList(long auxptyId) {
        LinkedHashMap<String, String> auxptyValueMap = this.getFlexAuxpropDataMap(auxptyId);
        return this.getFlexAuxpropDataNameList(auxptyValueMap);
    }

    private Map<Long, String> getFlexAuxpropDataNameList(Map<Long, String> auxptyValueMap) {
        HashMap<Long, String> result = new HashMap<Long, String>();
        if (auxptyValueMap == null || auxptyValueMap.isEmpty()) {
            return result;
        }
        ArrayList<String> auxpties = new ArrayList<String>();
        for (Map.Entry<Long, String> auxptyValueEntry : auxptyValueMap.entrySet()) {
            LinkedHashMap values = (LinkedHashMap)JsonUtil.readValue((String)auxptyValueEntry.getValue(), LinkedHashMap.class);
            if (values == null || values.isEmpty()) continue;
            for (Map.Entry auxptyValue : values.entrySet()) {
                auxpties.add((String)auxptyValue.getKey());
            }
        }
        DynamicObjectCollection auxPropertyList = this.getAuxPropertyListByFlexfield(auxpties);
        Map<String, DynamicObject> flexValueMap = auxPropertyList.stream().collect(Collectors.toMap(k -> k.getString("flexfield"), v -> v, (r1, r2) -> r1));
        for (Map.Entry<Long, String> auxptyValueEntry : auxptyValueMap.entrySet()) {
            LinkedHashMap values = (LinkedHashMap)JsonUtil.readValue((String)auxptyValueEntry.getValue(), LinkedHashMap.class);
            if (values == null || values.isEmpty()) continue;
            DynamicObjectCollection flexProperty = new DynamicObjectCollection();
            for (Map.Entry value : values.entrySet()) {
                flexProperty.add((Object)flexValueMap.get(value.getKey()));
            }
            List<String> nameList = this.getNameListByAuxPropertyList(flexProperty, values);
            if (nameList == null || nameList.size() <= 0) continue;
            result.put(auxptyValueEntry.getKey(), kd.occ.ocbase.common.util.CollectionUtil.tranSet2String(nameList));
        }
        return result;
    }

    private List<String> getFlexAuxpropDataNameList(LinkedHashMap<String, String> auxptyValueMap) {
        if (auxptyValueMap == null || auxptyValueMap.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> auxpties = new ArrayList<String>(16);
        for (Map.Entry<String, String> auxptyValueEntry : auxptyValueMap.entrySet()) {
            auxpties.add(auxptyValueEntry.getKey());
        }
        DynamicObjectCollection auxPropertyList = this.getAuxPropertyListByFlexfield(auxpties);
        return this.getNameListByAuxPropertyList(auxPropertyList, auxptyValueMap);
    }

    private List<String> getNameListByAuxPropertyList(DynamicObjectCollection auxPropertyList, LinkedHashMap<String, String> auxptyValueMap) {
        ArrayList<String> nameList = new ArrayList<String>();
        if (CollectionUtil.isNull((List)auxPropertyList) || auxptyValueMap == null || auxptyValueMap.isEmpty()) {
            return nameList;
        }
        for (DynamicObject auxProperty : auxPropertyList) {
            if (auxProperty == null) continue;
            String auxPropertyName = auxProperty.getString("name");
            String valueName = "";
            String valueType = auxProperty.getString("valuetype");
            String flexField = auxProperty.getString("flexfield");
            if ("3".equalsIgnoreCase(valueType)) {
                valueName = auxptyValueMap.get(flexField);
            } else {
                BasedataEntityType sourceType = null;
                if ("1".equalsIgnoreCase(valueType)) {
                    DynamicObject valueSource = auxProperty.getDynamicObject("valuesource");
                    sourceType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)valueSource.getString("number"));
                } else if ("2".equalsIgnoreCase(valueType)) {
                    sourceType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_assistantdata_detail");
                }
                if (sourceType != null) {
                    QFilter filters = new QFilter("id", "=", (Object)auxptyValueMap.get(flexField));
                    DynamicObject dataEntity = this.getValueSource(sourceType.getName(), filters.toArray());
                    if (dataEntity != null) {
                        valueName = dataEntity.getString("name");
                    }
                }
            }
            nameList.add(String.format("%s:%s", auxPropertyName, valueName));
        }
        return nameList;
    }

    private String getFlexAuxpropDataName(LinkedHashMap<String, String> auxptyValueMap) {
        if (auxptyValueMap == null || auxptyValueMap.isEmpty()) {
            return "";
        }
        ArrayList<String> auxpties = new ArrayList<String>(16);
        for (Map.Entry<String, String> auxptyValueEntry : auxptyValueMap.entrySet()) {
            auxpties.add(auxptyValueEntry.getKey());
        }
        DynamicObjectCollection auxPropertyList = this.getAuxPropertyListByFlexfield(auxpties);
        List<String> nameList = this.getNameListByAuxPropertyList(auxPropertyList, auxptyValueMap);
        if (nameList == null || nameList.size() == 0) {
            return "";
        }
        return kd.occ.ocbase.common.util.CollectionUtil.tranSet2String(nameList);
    }

    private DynamicObject getValueSource(String name, QFilter[] filters) {
        return ORM.create().queryOne(name, filters);
    }

    public DynamicObjectCollection getAuxPropertyListByFlexfield(List<String> auxpties) {
        QFilter apFilters = new QFilter("flexfield", "in", auxpties);
        return ORM.create().query(F_BD_AUXPROPERTY, apFilters.toArray());
    }

    public DynamicObjectCollection getAuxPropertyListByIds(List<Long> ids) {
        QFilter apFilters = new QFilter("id", "in", ids);
        return ORM.create().query(F_BD_AUXPROPERTY, apFilters.toArray());
    }

    public Map<Long, String> getFlexAuxpropDataMap(List<Long> auxptyIds) {
        QFilter filters = new QFilter("id", "in", auxptyIds);
        DynamicObjectCollection auxptyList = ORM.create().query(F_BD_FLEXAUXPROP, filters.toArray());
        if (auxptyList == null) {
            return new LinkedHashMap<Long, String>();
        }
        Map<Long, String> auxptyMap = auxptyList.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("value"), (r1, r2) -> r1));
        return auxptyMap;
    }

    public LinkedHashMap<String, String> getFlexAuxpropDataMap(long auxptyId) {
        QFilter filters = new QFilter("id", "=", (Object)auxptyId);
        DynamicObject auxpty = ORM.create().queryOne(F_BD_FLEXAUXPROP, filters.toArray());
        if (auxpty == null) {
            return new LinkedHashMap<String, String>();
        }
        return (LinkedHashMap)JsonUtil.readValue((String)auxpty.getString("value"), LinkedHashMap.class);
    }

    public DynamicObjectCollection getAuxPropertiesByMaterialId(long materialId) {
        DynamicObjectCollection auxptyList = this.getUseAuxptyByMaterialId(materialId);
        ArrayList<Long> auxptyIds = new ArrayList<Long>(auxptyList.size());
        auxptyList.forEach(item -> auxptyIds.add(item.getLong("auxptyentry.auxpty.id")));
        return this.getAuxPropertyListByIds(auxptyIds);
    }

    public FlexMeta getFlexMetaByMaterialId(long materialId) {
        FlexMeta flexMeta = new FlexMeta();
        DynamicObjectCollection auxProperties = this.getAuxPropertiesByMaterialId(materialId);
        if (CollectionUtil.isNull((List)auxProperties)) {
            return null;
        }
        ArrayList<FlexEntity> flexEntities = new ArrayList<FlexEntity>(auxProperties.size());
        for (DynamicObject auxProperty : auxProperties) {
            FlexEntity flexEntity = new FlexEntity();
            flexEntity.setId(auxProperty.getString("id"));
            String valueType = auxProperty.getString("valuetype");
            if ("3".equalsIgnoreCase(valueType)) {
                flexEntity = (FlexEntity)JSONObject.parseObject((String)auxProperty.getString("manuallydatatype"), FlexEntity.class);
            } else {
                flexEntity.setType("basedata");
            }
            flexEntity.setName(auxProperty.getString("name"));
            flexEntity.setFlexfield(auxProperty.getString("flexfield"));
            flexEntities.add(flexEntity);
        }
        flexMeta.setFlexEntities(flexEntities);
        flexMeta.setId(Convert.toString((Object)materialId));
        return flexMeta;
    }

    public List<Auxpty> getAuxptyListByMaterialId(long materialId) {
        if (materialId == 0L) {
            return new ArrayList<Auxpty>();
        }
        List flexPropertyIds = FlexService.getBaseUseFlexProperties((String)F_BD_MATERIAL, (Object)materialId, (String)"auxpty");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocbsoc_saleorder");
        FlexProp flexFieldProperty = (FlexProp)entityType.findProperty("auxptyid");
        int flexTypeId = flexFieldProperty.getFlexTypeId();
        FlexEntityType flexFieldEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)"ocbsoc_saleorder", (String)"auxptyid", (int)flexTypeId, (List)flexPropertyIds);
        List flexProperty = flexFieldEntityType.getFlexProperties();
        ArrayList<Auxpty> auxptyList = new ArrayList<Auxpty>(flexProperty.size());
        block10: for (FlexProperty prop : flexProperty) {
            String valueType;
            String flexField = "";
            long flexId = 0L;
            String flexName = "";
            ArrayList<AuxptyValue> valueList = new ArrayList<AuxptyValue>();
            switch (valueType = prop.getValueType()) {
                case "1": {
                    break;
                }
                case "2": {
                    flexField = prop.getFlexField();
                    flexId = prop.getId();
                    flexName = prop.getName().getLocaleValue();
                    String assistantType = prop.getAssistantType();
                    if (StringUtil.isNull((String)assistantType)) continue block10;
                    QFilter filters = new QFilter("group", "=", (Object)Long.parseLong(assistantType));
                    Map dataMap = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (QFilter[])filters.toArray());
                    if (dataMap == null || dataMap.size() <= 0) break;
                    for (Map.Entry entry : dataMap.entrySet()) {
                        valueList.add(new AuxptyValue(((DynamicObject)entry.getValue()).getString("id"), ((DynamicObject)entry.getValue()).getString("name")));
                    }
                    break;
                }
                case "3": {
                    break;
                }
            }
            Auxpty useAuxpty = new Auxpty(flexId + "", flexName, flexField, valueList);
            auxptyList.add(useAuxpty);
        }
        return auxptyList;
    }

    public DynamicObjectCollection getAuxptyValueByMaterialId(long materialId) {
        QFilter filters = new QFilter("material", "=", (Object)materialId);
        filters.and(new QFilter("entryentity.isenable", "=", (Object)"1"));
        filters.and(new QFilter("material.isuseauxpty", "=", (Object)"1"));
        return ORM.create().query(F_BD_AUXPTYVALUE, filters.toArray());
    }

    public Map<String, DynamicObject> saveFlexData(long materialId, LinkedHashMap<String, List<LinkedHashMap<String, String>>> flexDataMap) {
        FlexEntityType flexFieldEntityType = this.getFlexFieldEntityType(materialId);
        HashMap<String, DynamicObject> auxptyMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<String, List<LinkedHashMap<String, String>>> entry : flexDataMap.entrySet()) {
            FlexEntireData flexEntireData = new FlexEntireData();
            DynamicObject flexFieldVal = new DynamicObject((DynamicObjectType)flexFieldEntityType);
            this.fixFlexValue(flexFieldEntityType, entry.getValue(), flexFieldVal);
            flexEntireData = new FlexEntireData();
            flexEntireData.setFlexData((MainEntityType)flexFieldEntityType, flexFieldVal);
            long auxptyId = 0L;
            try {
                auxptyId = FlexService.saveFlexData((MainEntityType)flexFieldEntityType, (FlexEntireData)flexEntireData);
                DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)flexFieldEntityType);
                cacheManager.removeByPrimaryKey(new Object[]{flexFieldEntityType.getPrimaryKey().getValue((Object)flexFieldVal)});
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5f39\u6027\u57dfid\u5931\u8d25\u3002");
            }
            auxptyMap.put(entry.getKey(), this.getAuxptyDynamicObject(auxptyId));
        }
        return auxptyMap;
    }

    public FlexEntireData createFlexEntireData(long materialId, List<LinkedHashMap<String, String>> flexDataEntityList) {
        List flexPropertyIds = FlexService.getBaseUseFlexProperties((String)F_BD_MATERIAL, (Object)materialId, (String)"auxpty");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocbsoc_saleorder");
        FlexProp flexFieldProperty = (FlexProp)entityType.findProperty("auxptyid");
        int flexTypeId = flexFieldProperty.getFlexTypeId();
        FlexEntityType flexFieldEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)"ocbsoc_saleorder", (String)"auxptyid", (int)flexTypeId, (List)flexPropertyIds);
        DynamicObject flexFieldVal = new DynamicObject((DynamicObjectType)flexFieldEntityType);
        this.fixFlexValue(flexFieldEntityType, flexDataEntityList, flexFieldVal);
        FlexEntireData flexEntireData = new FlexEntireData();
        flexEntireData.setFlexData((MainEntityType)flexFieldEntityType, flexFieldVal);
        return flexEntireData;
    }

    private void fixFlexValue(FlexEntityType flexFieldEntityType, List<LinkedHashMap<String, String>> flexDataEntityList, DynamicObject flexFieldVal) {
        Map<String, String> flexValueMap = flexDataEntityList.stream().collect(Collectors.toMap(k -> (String)k.get("flexProperty"), v -> (String)v.get("value"), (r1, r2) -> r1));
        List flexPropertyList = flexFieldEntityType.getFlexProperties();
        DataEntityPropertyCollection properties = flexFieldEntityType.getProperties();
        HashMap<String, DynamicObject> flexFieldValueMap = new HashMap<String, DynamicObject>();
        for (FlexProperty flexProperty : flexPropertyList) {
            String valueType;
            String flexField = "";
            switch (valueType = flexProperty.getValueType()) {
                case "1": {
                    break;
                }
                case "2": {
                    flexField = flexProperty.getFlexField();
                    DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(flexValueMap.get(flexField)), (String)"bos_assistantdata_detail");
                    flexFieldValueMap.put(flexField, data);
                    break;
                }
                case "3": {
                    break;
                }
            }
        }
        for (IDataEntityProperty prop : properties) {
            String key = prop.getName();
            if ("id".equals(key)) continue;
            if (!(prop instanceof BasedataProp)) {
                if (!key.endsWith("_id")) continue;
                continue;
            }
            String subKey = key;
            key = subKey.split("__")[1];
            prop.setValue((Object)flexFieldVal, flexFieldValueMap.get(key));
        }
    }

    public DynamicObject getAuxptyDynamicObject(long auxptyId) {
        DynamicObject auxpty = null;
        try {
            auxpty = BusinessDataServiceHelper.loadSingle((Object)auxptyId, (String)F_BD_FLEXAUXPROP);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return auxpty;
    }

    public DynamicObject getAuxptyDynamicObject(long auxptyId, long materialId) {
        ArrayList<LinkedHashMap<String, String>> flexDataEntityList = new ArrayList<LinkedHashMap<String, String>>();
        QFilter filters = new QFilter("id", "=", (Object)auxptyId);
        DynamicObject auxpty = ORM.create().queryOne(F_BD_FLEXAUXPROP, filters.toArray());
        if (auxpty == null) {
            return null;
        }
        LinkedHashMap auxptyMap = (LinkedHashMap)JsonUtil.readValue((String)auxpty.getString("value"), LinkedHashMap.class);
        if (auxptyMap != null) {
            for (Map.Entry entry : auxptyMap.entrySet()) {
                LinkedHashMap flexDataMap = new LinkedHashMap();
                flexDataMap.put("flexProperty", entry.getKey());
                flexDataMap.put("value", entry.getValue().toString());
                flexDataEntityList.add(flexDataMap);
            }
        }
        List flexPropertyIds = FlexService.getBaseUseFlexProperties((String)F_BD_MATERIAL, (Object)materialId, (String)"auxpty");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocbsoc_saleorder");
        FlexProp flexFieldProperty = (FlexProp)entityType.findProperty("auxptyid");
        int flexTypeId = flexFieldProperty.getFlexTypeId();
        FlexEntityType flexFieldEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)"ocbsoc_saleorder", (String)"auxptyid", (int)flexTypeId, (List)flexPropertyIds);
        FlexEntireData flexEntireData = new FlexEntireData();
        flexEntireData = this.createFlexEntireData(materialId, flexDataEntityList);
        long id = FlexService.saveFlexData((MainEntityType)flexFieldEntityType, (FlexEntireData)flexEntireData);
        DynamicObject flexObject = (DynamicObject)flexFieldProperty.getComplexType().createInstance();
        flexObject.set("id", (Object)id);
        Map values = flexEntireData.getFlexValue();
        flexObject.set("value", (Object)SerializationUtils.toJsonString((Object)values));
        return flexObject;
    }

    public FlexMeta getSpuItemListByItemId(long itemId) {
        QFilter qfFilter = new QFilter("entryentity_specmap.itemid.id", "=", (Object)itemId);
        DynamicObject spuDetail = ORM.create().queryOne(F_DBD_SPU, qfFilter.toArray());
        if (spuDetail == null) {
            return null;
        }
        FlexMeta flexMeta = new FlexMeta();
        flexMeta.setType(FlexMeta.FlexMetaType.SPU.getValue());
        ArrayList<FlexEntity> flexEntities = new ArrayList<FlexEntity>();
        FlexEntity item = new FlexEntity();
        item.setId(spuDetail.getString("id"));
        item.setName(spuDetail.getString("name"));
        flexEntities.add(item);
        flexMeta.setFlexEntities(flexEntities);
        flexMeta.setId(Convert.toString((Object)itemId));
        return flexMeta;
    }

    public List<Auxpty> getSpuAuxptyByItemId(long itemId) {
        QFilter qfFilter = new QFilter("entryentity_specmap.itemid.id", "=", (Object)itemId);
        DynamicObject spu = ORM.create().queryOne(F_DBD_SPU, qfFilter.toArray());
        if (spu == null) {
            return null;
        }
        DynamicObjectCollection detailList = spu.getDynamicObjectCollection("entryentity_spec");
        ArrayList<Auxpty> auxptyList = new ArrayList<Auxpty>();
        for (DynamicObject detail : detailList) {
            DynamicObject spec = detail.getDynamicObject("specid");
            Auxpty auxpty = new Auxpty(spec.getString("id"), spec.getString("name"));
            DynamicObjectCollection specDetail = detail.getDynamicObjectCollection("subentryentity_spec");
            ArrayList<AuxptyValue> auxptyValues = new ArrayList<AuxptyValue>(specDetail.size());
            for (DynamicObject specModel : specDetail) {
                AuxptyValue auxptyValue = new AuxptyValue(specModel.getString("specvalueid.id"), specModel.getString("specvalueid.name"));
                auxptyValues.add(auxptyValue);
            }
            auxpty.setAuxptyValues(auxptyValues);
            auxptyList.add(auxpty);
        }
        return auxptyList;
    }

    public DynamicObject getSpuDynamicObject(long spuId) {
        return BusinessDataServiceHelper.loadSingle((Object)spuId, (String)F_DBD_SPU, (String)"id,name");
    }

    public Auxpty getSpuDetail(long spuDetailId) {
        QFilter qfFilter = new QFilter("entryentity_specmap.id", "=", (Object)spuDetailId);
        DynamicObject spuDetail = BusinessDataServiceHelper.loadSingle((String)F_DBD_SPU, (String)query_spu_cols, (QFilter[])qfFilter.toArray());
        if (spuDetail == null) {
            return null;
        }
        Auxpty auxpty = null;
        for (DynamicObject detail : spuDetail.getDynamicObjectCollection(sku_detail)) {
            if (spuDetailId != detail.getLong("id")) continue;
            auxpty = new Auxpty(detail.getString("id"), detail.getString("spumapname"));
            break;
        }
        return auxpty;
    }

    public DynamicObject getAuxptyDynamicObjectByDetailId(long detailId) {
        QFilter qfFilter = new QFilter("entryentity_specmap.id", "=", (Object)detailId);
        DynamicObject spu = ORM.create().queryOne(F_DBD_SPU, qfFilter.toArray());
        DynamicObjectCollection sepcList = spu == null ? new DynamicObjectCollection() : spu.getDynamicObjectCollection(sku_detail);
        for (DynamicObject detail : sepcList) {
            if (detailId != detail.getLong("id")) continue;
            return detail;
        }
        return null;
    }

    public List<Auxpty> getSpuAuxptyListById(long spuId, long itemId) {
        DynamicObject spu = BusinessDataServiceHelper.loadSingle((Object)spuId, (String)F_DBD_SPU);
        if (spu == null) {
            return null;
        }
        Map<String, String> curentSpuMap = this.getSpuMap(spu.getDynamicObjectCollection(sku_detail), itemId);
        DynamicObjectCollection detailList = spu.getDynamicObjectCollection("entryentity_spec");
        ArrayList<Auxpty> auxptyList = new ArrayList<Auxpty>();
        for (DynamicObject detail : detailList) {
            DynamicObject spec = detail.getDynamicObject("specid");
            Auxpty auxpty = new Auxpty(spec.getString("id"), spec.getString("name"));
            String selectedAuxptyValue = curentSpuMap.get(auxpty.getAuxptyId());
            DynamicObjectCollection specDetail = detail.getDynamicObjectCollection("subentryentity_spec");
            ArrayList<AuxptyValue> auxptyValues = new ArrayList<AuxptyValue>(specDetail.size());
            for (DynamicObject specModel : specDetail) {
                AuxptyValue auxptyValue;
                auxptyValue.setSelected((auxptyValue = new AuxptyValue(specModel.getString("specvalueid.id"), specModel.getString("specvalueid.name"))).getId().equals(selectedAuxptyValue) ? 1 : 0);
                auxptyValues.add(auxptyValue);
            }
            auxpty.setAuxptyValues(auxptyValues);
            auxptyList.add(auxpty);
        }
        return auxptyList;
    }

    private Map<String, String> getSpuMap(DynamicObjectCollection specMapList, long itemId) {
        if (itemId > 0L) {
            for (DynamicObject mapInfo : specMapList) {
                if ((Long)mapInfo.getDynamicObject("itemid").getPkValue() != itemId) continue;
                JSONArray groupJson = JSONArray.parseArray((String)mapInfo.getString("spumapids"));
                if (groupJson == null || groupJson.size() == 0) break;
                Map<String, String> specMap = groupJson.stream().collect(Collectors.toMap(x -> ((JSONObject)x).getString("key"), x -> ((JSONObject)x).getString("value")));
                return specMap;
            }
        }
        return new HashMap<String, String>(1);
    }

    public DynamicObjectCollection getEnableSpecValue(long specId) {
        QFilter filter = new QFilter("group", "=", (Object)specId);
        return QueryServiceHelper.query((String)"dbd_spu_specvalue", (String)"number,name,enable,group,id", (QFilter[])filter.toArray(), (String)"id");
    }

    public SpuGroup getSpecGroupMap(long spuId) {
        QFilter filter = new QFilter("id", "=", (Object)spuId);
        DynamicObject spu = ORM.create().queryOne(F_DBD_SPU, filter.toArray());
        if (spu == null) {
            return null;
        }
        DynamicObjectCollection detailList = spu.getDynamicObjectCollection(sku_detail);
        if (CollectionUtil.isNull((List)detailList)) {
            return null;
        }
        SpuGroup spuGroup = new SpuGroup();
        spuGroup.setSpuId(spu.getLong("id"));
        HashMap groupMap = new HashMap();
        HashMap itemAuxptyMap = new HashMap();
        for (DynamicObject detail : detailList) {
            JSONArray groupJson = JSONArray.parseArray((String)detail.getString("spumapids"));
            if (groupJson == null || groupJson.size() == 0) continue;
            HashMap specMap = new HashMap();
            groupJson.stream().forEach(jsonobejct -> this.addToMap((JSONObject)jsonobejct, specMap));
            groupMap.put(detail.getLong("id"), specMap);
            HashMap<String, Long> iaMap = new HashMap<String, Long>();
            iaMap.put("itemId", detail.getLong("itemid.id"));
            iaMap.put("auxptyId", detail.getLong("auxptyid.id"));
            itemAuxptyMap.put(detail.getLong("id"), iaMap);
        }
        spuGroup.setItemAuxptyMap(itemAuxptyMap);
        spuGroup.setGroupMap(groupMap);
        return spuGroup;
    }

    private void addToMap(JSONObject specValue, Map<Long, Long> specMap) {
        specMap.put(specValue.getLong("key"), specValue.getLong("value"));
    }

    public SpuDetail findSpecInfoByGroupValue(long spuId, Map<Long, Long> selectGroupMap) {
        SpuDetail spuDetail = new SpuDetail();
        if (selectGroupMap != null && selectGroupMap.size() > 0) {
            SpuGroup spuGroup = this.getSpecGroupMap(spuId);
            Map groupMap = spuGroup.getGroupMap();
            for (Map.Entry entry : groupMap.entrySet()) {
                Map value = (Map)entry.getValue();
                int dimensionSize = value.size();
                if (dimensionSize != selectGroupMap.size()) continue;
                int i = 0;
                for (Map.Entry<Long, Long> valueEntry : selectGroupMap.entrySet()) {
                    if (!value.containsKey(valueEntry.getKey()) || ((Long)value.get(valueEntry.getKey())).longValue() != valueEntry.getValue().longValue()) break;
                    ++i;
                }
                if (i != dimensionSize) continue;
                Map infoMap = (Map)spuGroup.getItemAuxptyMap().get(entry.getKey());
                spuDetail.setDetailId(((Long)entry.getKey()).longValue());
                spuDetail.setItemId(((Long)infoMap.get("itemId")).longValue());
                spuDetail.setSkuId(((Long)infoMap.get("auxptyId")).longValue());
                return spuDetail;
            }
        }
        return spuDetail;
    }

    public JSONArray getEnableSpecValue(long spuId, Map<Long, Long> selectedMap) {
        SpuGroup spuGroup = this.getSpecGroupMap(spuId);
        Map groupMap = spuGroup.getGroupMap();
        for (Map.Entry<Long, Long> entry : selectedMap.entrySet()) {
            Iterator it = groupMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry groupEntry = it.next();
                if (((Map)groupEntry.getValue()).containsKey(entry.getKey()) && ((Long)((Map)groupEntry.getValue()).get(entry.getKey())).longValue() == entry.getValue().longValue()) continue;
                it.remove();
            }
        }
        HashMap resultMap = new HashMap();
        for (Map.Entry entry : groupMap.entrySet()) {
            Map groupValues = (Map)entry.getValue();
            for (Map.Entry groupDetail : groupValues.entrySet()) {
                String keyStr = Convert.toString(groupDetail.getKey());
                String valueStr = Convert.toString(groupDetail.getValue());
                ArrayList<String> valueList = (ArrayList<String>)resultMap.get(keyStr);
                if (CollectionUtil.isNull((List)valueList)) {
                    valueList = new ArrayList<String>(1);
                }
                if (!valueList.contains(valueStr)) {
                    valueList.add(valueStr);
                }
                resultMap.put(keyStr, valueList);
            }
        }
        JSONArray enableGroupList = new JSONArray();
        for (Map.Entry resultDetail : resultMap.entrySet()) {
            JSONObject enableDetail = new JSONObject();
            enableDetail.put((String)resultDetail.getKey(), resultDetail.getValue());
            enableGroupList.add((Object)enableDetail);
        }
        return enableGroupList;
    }
}

