/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.service.miniprogram;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.UUID;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.business.helper.UserHelper;
import kd.occ.ocbase.common.pojo.dto.member.user.BindMobileDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.RegisterByWechatDTO;
import kd.occ.ocbase.common.util.EmojiCharUtils;
import kd.occ.ocepfp.common.constant.ExtDbRouter;
import kd.occ.ocepfp.common.entity.ExtResponse;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.InvokeResult;
import kd.occ.ocepfp.common.entity.MiniProgramResponse;
import kd.occ.ocepfp.common.util.Base64Util;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.ExtAppCache;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.SHA1Util;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.common.util.WebUtil;
import kd.occ.ocepfp.core.portal.AbstractPortalGateWay;
import kd.occ.ocepfp.core.service.portal.ExtPortalServiceHelper;
import org.apache.commons.lang.StringEscapeUtils;

public class MiniProgramLoginProcessor {
    private static Log logger = LogFactory.getLog(MiniProgramLoginProcessor.class);
    private static final String JSCODE2SESSION_URL = "https://api.weixin.qq.com/sns/jscode2session";

    public ExtResponse miniProgramMemberRegister(ExtWebContext extCtx, JSONObject registerParam, String token, long orgId) {
        try {
            return this.memberRegister(extCtx, registerParam, token, orgId);
        }
        catch (Exception e) {
            LogUtil.info(this.getClass(), (Throwable)e);
            MiniProgramResponse miniProgramResponse = new MiniProgramResponse();
            miniProgramResponse.setCode(500);
            miniProgramResponse.setMessage(e.getMessage());
            logger.error("\u5c0f\u7a0b\u5e8f\u6ce8\u518c\u4f1a\u5458\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f:\n" + e);
            return miniProgramResponse;
        }
    }

    private ExtResponse memberRegister(ExtWebContext extCtx, JSONObject registerParam, String token, long orgId) {
        JSONObject addInfo;
        DynamicObject loginInfo = this.getLoginUserInfoByToken(token);
        if (loginInfo == null) {
            throw new KDBizException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002");
        }
        String signature = registerParam.getString("signature");
        String session_key = loginInfo.getString("sessionkey");
        String signature2 = this.sha1Hex(StringEscapeUtils.unescapeHtml((String)registerParam.getString("rawData")), session_key);
        if (!signature2.equalsIgnoreCase(signature)) {
            throw new KDBizException("\u8bf7\u68c0\u67e5\u7528\u6237\u6570\u636e\u5b8c\u6574\u6027\u3002");
        }
        String encryptedData = registerParam.getString("encryptedData");
        String iv = registerParam.getString("iv");
        if (StringUtils.isNull((String)iv) || StringUtil.isNull((String)encryptedData) || StringUtil.isNull((String)signature2)) {
            throw new KDBizException("\u89e3\u5bc6\u6570\u636e\u6709\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u3002");
        }
        String decryptData = Base64Util.decryptData((String)encryptedData, (String)session_key, (String)iv);
        JSONObject decryptUserInfo = JSONObject.parseObject((String)decryptData);
        if (decryptUserInfo == null) {
            throw new KDBizException("\u89e3\u5bc6\u7528\u6237\u4fe1\u606f\u6709\u8bef\u3002");
        }
        JSONObject userInfo = registerParam.getJSONObject("userInfo");
        if (userInfo == null) {
            throw new KDBizException("\u7528\u6237\u4fe1\u606f\u53c2\u6570\u6709\u8bef\u3002");
        }
        RegisterByWechatDTO dto = new RegisterByWechatDTO();
        dto.setAppId(loginInfo.getString("appid"));
        dto.setOpenId(loginInfo.getString("openid"));
        dto.setUnionId(loginInfo.getString("unionid"));
        String avatarUrl = userInfo.getString("avatarUrl");
        String nickName = StringEscapeUtils.unescapeHtml((String)(userInfo.getString("nickName") != null ? userInfo.getString("nickName") : ""));
        dto.setName(nickName);
        dto.setAvatarUrl(avatarUrl);
        dto.setAppTypeNum("wechat_mini_program");
        dto.setSrcAppType("B");
        logger.info("addInfo\u539f\u59cb\u5730\u7406\u4f4d\u7f6e\u4fe1\u606f\u53c2\u6570\u6570\u636e:%s" + registerParam.getString("addInfo"));
        String addInfoStr = registerParam.getString("addInfo");
        JSONObject jSONObject = addInfo = StringUtil.isNotNull((String)addInfoStr) && !addInfoStr.equalsIgnoreCase("\"\"") ? JSONObject.parseObject((String)addInfoStr) : null;
        if (addInfo != null) {
            logger.info("addInfo\u5730\u7406\u4f4d\u7f6e\u4fe1\u606f\u53c2\u6570\u6570\u636e:%s" + addInfo.toJSONString());
            dto.setCountry(addInfo.getString("nation"));
            dto.setProvince(addInfo.getString("province"));
            dto.setCity(addInfo.getString("city"));
            dto.setDistrict(addInfo.getString("district"));
        }
        dto.setOrgId(Long.valueOf(orgId));
        logger.info(String.format("\u4f1a\u5458\u6570\u636e:openid[%s],unionid[%s],avatarUrl[%s],nickName[%s]", loginInfo.getString("openid"), loginInfo.getString("unionid"), avatarUrl, nickName));
        AbstractPortalGateWay loginGateWay = ExtPortalServiceHelper.getPortalPlugin(extCtx);
        logger.info("miniprogram reg:" + extCtx.getForm().getPortalIdentity() + "," + (loginGateWay != null));
        if (loginGateWay != null) {
            loginGateWay.beforeRegisterFirst(extCtx, dto);
        }
        JSONObject result = UserHelper.registerByWechat((RegisterByWechatDTO)dto);
        logger.info("2021\u5e741\u670819\u65e5\u4fee\u6b63\u7248\u672c\u3010\u6784\u5efa\u4f1a\u5458\u6ce8\u518c\u53c2\u6570\uff0c\u8c03\u7528\u6ce8\u518c\u4f1a\u5458\u5fae\u670d\u52a1\u3011\uff1a" + result.toString());
        InvokeResult invokeResult = this.translateIntoInvokeResult(result);
        ExtResponse miniProgramResponse = new ExtResponse();
        if (!invokeResult.isSuccess()) {
            miniProgramResponse.setCode(500);
            miniProgramResponse.setMessage(String.format("\u4f1a\u5458\u6ce8\u518c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f\uff1a%s", invokeResult.getMessage()));
        } else {
            if (StringUtil.isNotNull((String)nickName)) {
                nickName = EmojiCharUtils.filterEmoji((String)nickName, (String)"");
            }
            loginInfo.set("headimage", (Object)avatarUrl);
            loginInfo.set("nickname", (Object)nickName);
            loginInfo.set("logintime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.update((DynamicObject)loginInfo);
        }
        return miniProgramResponse;
    }

    public ExtResponse updateMemberPhoneNumber(ExtWebContext extCtx, JSONObject memberParams, String token, long orgId) {
        try {
            return this.updatePhoneNumber(extCtx, memberParams, token, orgId);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            MiniProgramResponse miniProgramResponse = new MiniProgramResponse();
            miniProgramResponse.setCode(500);
            miniProgramResponse.setMessage(e.getMessage());
            logger.error("\u66f4\u65b0\u4f1a\u5458\u6863\u6848\u7684\u624b\u673a\u53f7\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f:\n" + e);
            return miniProgramResponse;
        }
    }

    private ExtResponse updatePhoneNumber(ExtWebContext extCtx, JSONObject memberParams, String token, long orgId) {
        String iv;
        if (memberParams == null) {
            throw new KDBizException("\u66f4\u65b0\u4f1a\u5458\u624b\u673a\u53f7\u53c2\u6570\u9519\u8bef\u3002");
        }
        String encryptedData = memberParams.getString("encryptedData");
        String phoneNumber = this.getPhoneNumber(encryptedData, iv = memberParams.getString("iv"), token);
        if (StringUtil.isNull((String)phoneNumber)) {
            throw new KDBizException("\u89e3\u5bc6\u83b7\u53d6\u624b\u673a\u53f7\u5931\u8d25\u3002");
        }
        DynamicObject memberLoginInfo = this.getMemberLoginInfoByToken(token);
        InvokeResult invokeResult = this.getUpdateMemberPhoneNumberResult(extCtx, memberLoginInfo, orgId, phoneNumber);
        MiniProgramResponse miniProgramResponse = new MiniProgramResponse();
        if ("0".equalsIgnoreCase(invokeResult.getCode()) && invokeResult.isSuccess()) {
            LinkedHashMap registerMap = (LinkedHashMap)invokeResult.getData();
            long memberId = Convert.toLong(registerMap.get("userId"));
            if (memberLoginInfo != null) {
                memberLoginInfo.set("logintime", (Object)TimeServiceHelper.now());
                memberLoginInfo.set("member", (Object)memberId);
                SaveServiceHelper.update((DynamicObject)memberLoginInfo);
                extCtx.setAppId(memberLoginInfo.getString("appid"));
            }
            extCtx.setToken(token);
            extCtx.setMemberId(memberId);
            miniProgramResponse.setCode(200);
            miniProgramResponse.setData((Object)"\u66f4\u65b0\u4f1a\u5458\u624b\u673a\u53f7\u670d\u52a1\u8c03\u7528\u6210\u529f\u3002");
        } else {
            miniProgramResponse.setCode(500);
            miniProgramResponse.setMessage(String.format("\u66f4\u65b0\u4f1a\u5458\u624b\u673a\u53f7\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s", invokeResult.getMessage()));
        }
        return miniProgramResponse;
    }

    private InvokeResult getUpdateMemberPhoneNumberResult(ExtWebContext ctx, DynamicObject memberLoginInfo, long orgId, String phoneNumber) {
        BindMobileDTO dto = new BindMobileDTO();
        dto.setOrgId(Long.valueOf(orgId));
        dto.setMobile(phoneNumber);
        dto.setAppId(memberLoginInfo.getString("appid"));
        dto.setOpenId(memberLoginInfo.getString("openid"));
        AbstractPortalGateWay loginGateWay = ExtPortalServiceHelper.getPortalPlugin(ctx);
        if (loginGateWay != null) {
            loginGateWay.beforeUpdateMobile(ctx, dto);
        }
        JSONObject result = UserHelper.bindMobile((BindMobileDTO)dto);
        logger.info("2021\u5e741\u670820\u65e5\u4fee\u6b63\u7248\u672c\u3010\u6784\u5efa\u66f4\u65b0\u4f1a\u5458\u624b\u673a\u53f7\u53c2\u6570\uff0c\u8c03\u7528\u66f4\u65b0\u4f1a\u5458\u624b\u673a\u53f7\u5fae\u670d\u52a1\u3011\uff1a" + result.toString());
        InvokeResult invokeResult = this.translateIntoInvokeResult(result);
        return invokeResult;
    }

    public ExtResponse getAutoLoginResponse(ExtWebContext extCtx, String appId, String secret, String js_code) {
        MiniProgramResponse miniProgramResponse = new MiniProgramResponse();
        try {
            DynamicObject loginInfo = this.getUserLoginInfo(extCtx, appId, secret, js_code);
            extCtx.getForm().put((Object)"loginUserInfo", (Object)loginInfo);
            miniProgramResponse.setToken(loginInfo.getString("token"));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            miniProgramResponse.setCode(500);
            miniProgramResponse.setMessage(e.getMessage());
            logger.error("\u5c0f\u7a0b\u5e8f\u81ea\u52a8\u767b\u5f55\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f:\n" + e);
        }
        return miniProgramResponse;
    }

    public InvokeResult translateIntoInvokeResult(JSONObject resultJson) {
        try {
            logger.info("\u8c03\u7528\u4f1a\u5458\u5fae\u670d\u52a1\u63a5\u53e3\u7ed3\u679c\uff1a" + resultJson.toString());
            return (InvokeResult)JsonUtil.readValue((String)resultJson.toString(), InvokeResult.class);
        }
        catch (Exception ex) {
            logger.error("\u8c03\u7528\u4f1a\u5458\u5fae\u670d\u52a1\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f:\n" + StringUtil.getErrorMsg((Exception)ex));
            InvokeResult invokeResult = new InvokeResult();
            invokeResult.setCode("-1");
            invokeResult.setSuccess(false);
            invokeResult.setMessage("\u8c03\u7528\u4f1a\u5458\u5fae\u670d\u52a1\u63a5\u53e3\u5931\u8d25\u3002");
            return invokeResult;
        }
    }

    private DynamicObject getUserLoginInfo(ExtWebContext extCtx, String appId, String secret, String js_code) throws KDBizException {
        JSONObject sessionResult = this.getUserLoginSessionKey(appId, secret, js_code);
        String unionId = sessionResult.getString("unionid");
        String openId = sessionResult.getString("openid");
        String session_key = sessionResult.getString("session_key");
        return this.saveUserLoginInfo(extCtx, appId, unionId, openId, session_key);
    }

    private JSONObject getUserLoginSessionKey(String appId, String secret, String js_code) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(4);
        params.put("appid", appId);
        params.put("secret", secret);
        params.put("js_code", js_code);
        params.put("grant_type", "authorization_code");
        JSONObject result = WebUtil.getHttpClientPostData((String)JSCODE2SESSION_URL, params);
        if (result == null) {
            throw new KDBizException("\u53d1\u9001auth.code2Session\u8bf7\u6c42\u5931\u8d25\u3002");
        }
        if (StringUtil.isNotNull((Object)result.get((Object)"errcode"))) {
            throw new KDBizException(String.format("\u83b7\u53d6\u7528\u6237\u767b\u5f55\u6001\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s", result.get((Object)"errmsg")));
        }
        return result;
    }

    private DynamicObject saveUserLoginInfo(ExtWebContext extCtx, String appId, String unionId, String openId, String session_key) {
        Date date = TimeServiceHelper.now();
        DynamicObject userLoginInfo = this.queryMiniprogramUserLoginInfo(appId, openId);
        String token = UUID.randomUUID().toString();
        if (userLoginInfo == null) {
            logger.info("=========autologin appid\uff1a" + appId + ", openid=" + openId + ",unionId=" + unionId + ",first");
            userLoginInfo = BusinessDataServiceHelper.newDynamicObject((String)"ocepfp_memberologininfo");
            userLoginInfo.set("openid", (Object)openId);
            userLoginInfo.set("unionid", (Object)unionId);
            userLoginInfo.set("token", (Object)token);
            userLoginInfo.set("sessionkey", (Object)session_key);
            userLoginInfo.set("logintime", (Object)date);
            userLoginInfo.set("appid", (Object)appId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userLoginInfo});
        } else {
            token = userLoginInfo.getString("token");
            userLoginInfo.set("unionid", (Object)unionId);
            userLoginInfo.set("sessionkey", (Object)session_key);
            userLoginInfo.set("openid", (Object)openId);
            userLoginInfo.set("logintime", (Object)date);
            SaveServiceHelper.update((DynamicObject)userLoginInfo);
            logger.info("=========autologin appid\uff1a" + appId + ", openid=" + openId + ",unionId=" + unionId + "second");
        }
        extCtx.setToken(token);
        extCtx.setOpenId(openId);
        extCtx.setMemberId(userLoginInfo.getLong("member_Id"));
        extCtx.setAppId(userLoginInfo.getString("appid"));
        this.updateSessionKeyCache(token, session_key);
        return userLoginInfo;
    }

    private DynamicObject queryMiniprogramUserLoginInfo(String appId, String openId) {
        QFilter filters = new QFilter("appid", "=", (Object)appId);
        filters.and(new QFilter("openid", "=", (Object)openId));
        return ORM.create().queryOne("ocepfp_memberologininfo", filters.toArray());
    }

    private void updateSessionKeyCache(String appId, String session_key) {
        ExtAppCache.setPrivateValue((String)this.getCacheSessionKey(appId), (Object)session_key);
    }

    private String getSessionKeyCache(String appId) {
        return (String)ExtAppCache.getPrivateValue((String)this.getCacheSessionKey(appId), String.class);
    }

    private String getCacheSessionKey(String appId) {
        return String.format("mp_sessionkey%s", appId);
    }

    public String getPhoneNumber(String encryptedData, String iv, String token) {
        String session_key = "";
        String decryptData = "";
        try {
            session_key = this.getSessionKey(token);
            decryptData = Base64Util.decryptData((String)encryptedData, (String)session_key, (String)iv);
            JSONObject phoneInfo = JSONObject.parseObject((String)decryptData);
            return phoneInfo.getString("purePhoneNumber");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("\u89e3\u5bc6\u83b7\u53d6\u624b\u673a\u53f7\u7801\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f\uff1a\n" + StringUtil.getErrorMsg((Exception)e));
            return "";
        }
    }

    private String getSessionKey(String token) {
        String sessionKey = this.getSessionKeyCache(token);
        if (StringUtil.isNotNull((String)sessionKey)) {
            return sessionKey;
        }
        return this.getMiniProgramUserSessionKey(token);
    }

    public String getMiniProgramUserSessionKey(String token) {
        DynamicObject loginInfo = this.getUserLoginInfo(token);
        String sessionKey = loginInfo == null ? "" : loginInfo.getString("sessionkey");
        return sessionKey;
    }

    public DynamicObject getUserLoginInfo(String token) {
        QFilter filters = new QFilter("token", "=", (Object)token);
        return ORM.create().queryOne("ocepfp_memberologininfo", filters.toArray());
    }

    public DynamicObject updateLoginUserInfo(String headImage, String nickName, String token) throws KDBizException {
        DynamicObject userInfo = this.getLoginUserInfoByToken(token);
        if (userInfo == null) {
            throw new KDBizException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002");
        }
        userInfo.set("headimage", (Object)headImage);
        userInfo.set("nickname", (Object)nickName);
        SaveServiceHelper.update((DynamicObject)userInfo);
        return userInfo;
    }

    public DynamicObject getLoginUserInfoByToken(String token) {
        QFilter filters = new QFilter("token", "=", (Object)token);
        return ORM.create().queryOne("ocepfp_memberologininfo", filters.toArray());
    }

    public String sha1Hex(String rawData, String session_key) {
        String key = String.format("%s%s", rawData, session_key);
        return SHA1Util.getSha1((String)key);
    }

    public long getLoginMemberId(String token) {
        DynamicObject memberLoginInfo = this.getMemberLoginInfoByToken(token);
        DynamicObject member = memberLoginInfo == null ? null : memberLoginInfo.getDynamicObject("member");
        return member != null ? Convert.toLong((Object)member.getPkValue()) : 0L;
    }

    public DynamicObject getMemberLoginInfoByToken(String token) {
        QFilter filter = new QFilter("token", "=", (Object)token);
        return ORM.create().queryOne("ocepfp_memberologininfo", filter.toArray());
    }

    public void clearMemberLoginInfo(String appId, long memberId) {
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(3);
        params.add(new SqlParameter(":FAPPID", 12, (Object)appId));
        params.add(new SqlParameter(":FMEMBERID", -5, (Object)memberId));
        DB.execute((DBRoute)ExtDbRouter.EXT, (String)"UPDATE T_OCEPFP_MEMBERLOGININFO SET FMEMBERID=0 WHERE FAPPID=? AND FMEMBERID=?", (Object[])params.toArray(new SqlParameter[params.size()]));
    }
}

