/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.service.portal;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocepfp.common.constant.ExtDbRouter;
import kd.occ.ocepfp.common.entity.CardDetail;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.LoadCardRequest;
import kd.occ.ocepfp.common.entity.LoginContext;
import kd.occ.ocepfp.common.entity.MainPortal;
import kd.occ.ocepfp.common.enums.CardTypeEnum;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.PortalAppCacheUtil;
import kd.occ.ocepfp.core.form.control.controls.Card;
import kd.occ.ocepfp.core.form.control.controls.CardItem;
import kd.occ.ocepfp.core.portal.AbstractPortalGateWay;
import kd.occ.ocepfp.core.service.portal.PortalPluginUtil;
import kd.occ.ocepfp.core.service.portal.card.AbstractCardProvider;
import kd.occ.ocepfp.core.service.portal.card.CardProviderFactory;

public class ExtPortalServiceHelper {
    private static final String VIEW_GOODSEXHIBITIONLIST = "goodsexhibitionlist";

    public static final MainPortal getMainPortal(ExtWebContext extCtx) {
        MainPortal mainPortal = null;
        if (mainPortal == null) {
            char clientType = extCtx.isFromMobile() ? (char)'5' : '1';
            SqlParameter param = new SqlParameter(":clienttype", 1, (Object)Character.valueOf(clientType));
            List mainPortalList = (List)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FID,FNUMBER,FHOMEPAGE,FPLUGIN,FMINIPLOGINPAGE,FPCLOGINPAGE,FMOBILELOGINPAGE FROM T_OCEPFP_PLATFORM WHERE FENABLE='1' and FCLIENTTYPE=? ORDER BY FPRIORITY", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<List<MainPortal>>(){

                public List<MainPortal> handle(ResultSet resultSet) throws Exception {
                    ArrayList<MainPortal> data = new ArrayList<MainPortal>(5);
                    while (resultSet.next()) {
                        MainPortal portal = new MainPortal();
                        String plugin = resultSet.getString("FPLUGIN");
                        portal.setPortalId(resultSet.getLong("FID"));
                        portal.setNumber(resultSet.getString("FNUMBER"));
                        portal.setPlugin(plugin);
                        portal.setIndexViewId(resultSet.getString("FHOMEPAGE"));
                        portal.setMobileloginpage(resultSet.getString("FMOBILELOGINPAGE"));
                        portal.setMiniploginpage(resultSet.getString("FMINIPLOGINPAGE"));
                        portal.setPcloginpage(resultSet.getString("FPCLOGINPAGE"));
                        data.add(portal);
                    }
                    return data;
                }
            });
            for (MainPortal portal : mainPortalList) {
                AbstractPortalGateWay portalGateWay = PortalPluginUtil.getPortalGateWay(extCtx, portal.getPlugin());
                if (portalGateWay == null || !portalGateWay.checkRole(extCtx, portal)) continue;
                LoginContext.get().putCommon("portalid", Long.toString(portal.getPortalId()));
                portalGateWay.afterRoleChecked(extCtx, portal);
                mainPortal = portal;
                break;
            }
            if (mainPortal != null) {
                PortalAppCacheUtil.setCurrentPortal(mainPortal);
            }
        }
        return mainPortal;
    }

    public static final AbstractPortalGateWay getPortalPlugin(final ExtWebContext extCtx) {
        String p = extCtx.getForm().getPortalIdentity();
        SqlParameter param = new SqlParameter(":number", 12, (Object)p);
        AbstractPortalGateWay plugin = (AbstractPortalGateWay)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FPLUGIN FROM T_OCEPFP_PLATFORM WHERE FNUMBER = ?", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<AbstractPortalGateWay>(){

            public AbstractPortalGateWay handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return PortalPluginUtil.getPortalGateWay(extCtx, resultSet.getString("FPLUGIN"));
                }
                return null;
            }
        });
        return plugin;
    }

    public static final String getPortalConfig(ExtWebContext extCtx, long platformId) {
        SqlParameter param = new SqlParameter(":platformId", -5, (Object)platformId);
        return (String)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FCARDDETAIL FROM T_OCEPFP_PLTF_CONFIG WHERE FPLATFORMID=?", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getString("FCARDDETAIL");
                }
                return "";
            }
        });
    }

    public static List<Card> buildPortalCardList(ExtWebContext extCtx, long platformId) {
        DynamicObject portalCfg = ExtPortalServiceHelper.getPortalCardCfg(extCtx, platformId);
        return ExtPortalServiceHelper.buildPortalCardCfgDetail(portalCfg);
    }

    public static DynamicObject getPortalCardCfg(ExtWebContext extCtx, long platformId) {
        String pageType = extCtx.isFromMobile() ? "B" : "A";
        QFilter[] filters = new QFilter[]{new QFilter("portal", "=", (Object)platformId), new QFilter("pagetype", "=", (Object)pageType)};
        ORM orm = ORM.create();
        return orm.queryOne("ocdbd_firstpageconfig", filters);
    }

    private static List<Card> buildPortalCardCfgDetail(DynamicObject portalcfg) {
        if (portalcfg == null) {
            return new ArrayList<Card>(0);
        }
        DynamicObjectCollection cardTypeList = portalcfg.getDynamicObjectCollection("usecardtypeentity");
        long typeId = 0L;
        ArrayList<Card> cardList = new ArrayList<Card>(cardTypeList.size());
        for (DynamicObject cardTypeObj : cardTypeList) {
            Card card = new Card();
            DynamicObject cardType = cardTypeObj.getDynamicObject("cardtype");
            if (cardType == null) continue;
            typeId = Convert.toLong((Object)cardType.getPkValue());
            String cardTypeName = CardTypeEnum.getName((long)typeId);
            card.setCardType(cardTypeName);
            card.setId(Convert.toString((Object)cardTypeObj.getPkValue()));
            if (Long.parseLong(card.getId()) == 955577536442777607L) {
                card.setDirection("h");
            }
            card.setName(cardTypeObj.getString("cardname"));
            card.setX(cardTypeObj.getInt("location_x"));
            card.setY(cardTypeObj.getInt("location_y"));
            card.setH(cardTypeObj.getInt("location_h"));
            card.setCols24(cardTypeObj.getInt("location_w"));
            if (Long.parseLong(card.getId()) == 955577536442777607L) {
                card.setCardData(ExtPortalServiceHelper.getAccountCartDetail(portalcfg));
            } else {
                DynamicObjectCollection cfgDetails = cardTypeObj.getDynamicObjectCollection("carddetailentity");
                int size = cfgDetails.size();
                ArrayList<CardDetail> detailList = new ArrayList<CardDetail>(size);
                for (DynamicObject cfg : cfgDetails) {
                    CardDetail cardDetail = new CardDetail();
                    cardDetail.setId(Convert.toLong((Object)cfg.getPkValue()));
                    cardDetail.setName(cfg.getString("contentname"));
                    cardDetail.setField(cfg.getString("field"));
                    cardDetail.setFilter(cfg.getString("filter"));
                    cardDetail.setFormid(cfg.getString("formid"));
                    cardDetail.setFunc(cfg.getString("func"));
                    cardDetail.setGroupby(cfg.getString("groupby"));
                    cardDetail.setIcon(cfg.getString("icon"));
                    cardDetail.setShow(cfg.getString("show"));
                    cardDetail.setSkipform(cfg.getString("skipform"));
                    cardDetail.setType(cfg.getString("type"));
                    cardDetail.setUrl(cfg.getString("pictureurl"));
                    cardDetail.setPlugin(cfg.getString("plugin"));
                    detailList.add(cardDetail);
                }
                if (detailList.size() > 0) {
                    card.setCardData(detailList);
                }
            }
            if (CardTypeEnum.GoodsExhibition.name().equalsIgnoreCase(cardTypeName)) {
                DynamicObjectCollection useTypeList = portalcfg.getDynamicObjectCollection("usetypeentity");
                if (useTypeList.size() > 0) {
                    for (DynamicObject useType : useTypeList) {
                        CardItem cardItem = new CardItem();
                        cardItem.setId(Convert.toString((Object)useType.getPkValue()));
                        cardItem.setName(useType.getString("itemtype"));
                        cardItem.setViewId(VIEW_GOODSEXHIBITIONLIST);
                        card.addChild(cardItem);
                    }
                } else {
                    CardItem cardItem = new CardItem();
                    cardItem.setId(null);
                    cardItem.setName(ResManager.loadKDString((String)"\u6700\u8fd11\u4e2a\u6708\u4e0b\u5355\u6700\u591a\u768410\u4e2a\u5546\u54c1", (String)"ExtPortalServiceHelper_1", (String)"drp-epfp-core", (Object[])new Object[0]));
                    cardItem.setViewId(VIEW_GOODSEXHIBITIONLIST);
                    card.addChild(cardItem);
                }
            }
            cardList.add(card);
        }
        return cardList;
    }

    private static List<CardDetail> getAccountCartDetail(DynamicObject portalcfg) {
        DynamicObjectCollection useCardAccountList = portalcfg.getDynamicObjectCollection("accountentry");
        ArrayList<CardDetail> detailList = null;
        if (useCardAccountList != null && (long)useCardAccountList.size() > 0L) {
            detailList = new ArrayList<CardDetail>(useCardAccountList.size());
            for (DynamicObject account : useCardAccountList) {
                if (!Checked.YES.toString().equals(account.getString("accountenable"))) continue;
                CardDetail cardDetail = new CardDetail();
                cardDetail.setId(Convert.toLong((Object)account.getPkValue()));
                cardDetail.setName(account.getString("accountname"));
                cardDetail.setField("");
                cardDetail.setFilter("");
                cardDetail.setFormid("ocepfp_rebateaccountlist");
                cardDetail.setFunc("");
                cardDetail.setGroupby("");
                cardDetail.setIcon("");
                cardDetail.setShow("");
                cardDetail.setSkipform("");
                cardDetail.setType("");
                cardDetail.setUrl("");
                if (StringUtils.isEmpty((String)account.getString("dataplugin"))) {
                    cardDetail.setPlugin("kd.occ.ocbmall.formplugin.b2b.home.PublicAccountPlugin");
                } else {
                    cardDetail.setPlugin(account.getString("dataplugin"));
                }
                detailList.add(cardDetail);
            }
        }
        return detailList;
    }

    public static final Object getCardData(ExtWebContext webCtx, LoadCardRequest loadCardParam) {
        AbstractCardProvider cardProvider = CardProviderFactory.getCardProvider(loadCardParam.getCardType());
        if (cardProvider != null) {
            return cardProvider.getData(webCtx, loadCardParam);
        }
        return "";
    }

    public static final Map<String, String> getPortalUseCardCfgdl(ExtWebContext extCtx, long id) {
        SqlParameter param = new SqlParameter(":id", -5, (Object)id);
        return (Map)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FFORMID,FSKIPFORM FROM T_OCDBD_USECARDCFGDL WHERE FDETAILID=?", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet resultSet) throws Exception {
                HashMap<String, String> data = new HashMap<String, String>(2);
                if (resultSet.next()) {
                    data.put("formid", resultSet.getString("FFORMID"));
                    data.put("skipform", resultSet.getString("FSKIPFORM"));
                }
                return data;
            }
        });
    }
}

