/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.service.portal.card;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.event.filter.QueryFilter;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.service.portal.card.AbstractCardProvider;
import kd.occ.ocepfp.core.service.portal.card.util.SubTotalRequest;
import kd.occ.ocepfp.core.service.portal.card.util.SubTotalResponse;

public abstract class AbstractSubTotalProvider
extends AbstractCardProvider {
    protected Object loadData(ExtWebContext webCtx, SubTotalRequest rankTableRequest) {
        Object data = null;
        PageView listView = super.getListView(webCtx, rankTableRequest.getFormId());
        if (listView == null) {
            return null;
        }
        QueryFilter queryFilter = super.buildQueryFilter(listView, rankTableRequest.getFilter());
        data = this.doLoadData(webCtx, rankTableRequest, queryFilter);
        return data;
    }

    protected Object doLoadData(ExtWebContext webCtx, SubTotalRequest request, QueryFilter queryFilter) {
        String selectFields = this.getSelectFields(request);
        if ("ocepfp_demandorder".equals(request.getFormId())) {
            selectFields = selectFields + ",goodslist.unitid.name";
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)request.getFormId().toLowerCase(), (String)selectFields, (QFilter[])queryFilter.toQFilter());
        Map<Object, List<DynamicObject>> groupByResult = dynamicObjectCollection.stream().collect(Collectors.groupingBy(r -> super.buildFunc(request.getFunc(), r.get(request.getGroupby()))));
        ArrayList sumDataList = new ArrayList();
        groupByResult.forEach((k, slist) -> {
            SubTotalResponse rankTableResponse = new SubTotalResponse();
            rankTableResponse.setName(StringUtil.isNotNull((String)request.getShow()) ? ((DynamicObject)slist.get(0)).getString(request.getShow()) : k.toString());
            BigDecimal sumData = slist.stream().map(r -> r.getBigDecimal(request.getField())).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(0, 1);
            rankTableResponse.setOvalue(sumData);
            if ("ocepfp_demandorder".equals(request.getFormId())) {
                String unitname = ((DynamicObject)slist.get(0)).getString("goodslist.unitid.name");
                rankTableResponse.setValue(sumData.toString() + unitname);
            }
            sumDataList.add(rankTableResponse);
        });
        List sortList = sumDataList.stream().sorted(Comparator.comparing(SubTotalResponse::getOvalue).reversed()).collect(Collectors.toList());
        if (sortList != null && sortList.size() > 6) {
            return sortList.subList(0, 5);
        }
        return sortList;
    }

    protected String getSelectFields(SubTotalRequest request) {
        SelectField selectField = new SelectField();
        selectField.select(request.getShow());
        selectField.select(request.getField());
        selectField.select(request.getGroupby());
        return selectField.toString();
    }

    private static class SelectField {
        StringBuffer str = new StringBuffer(50);

        private SelectField() {
        }

        public void select(String field) {
            if (StringUtil.isNotNull((String)field)) {
                this.str.append(field).append(",");
            }
        }

        public String toString() {
            int len = this.str.length();
            return len > 0 ? this.str.deleteCharAt(len - 1).toString() : "";
        }
    }
}

