/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.service.portal.card;

import java.util.HashMap;
import java.util.Map;
import kd.occ.ocepfp.common.constant.PortalCardType;
import kd.occ.ocepfp.core.service.portal.card.AbstractCardProvider;
import kd.occ.ocepfp.core.service.portal.card.DataStatisticsProvider;
import kd.occ.ocepfp.core.service.portal.card.GoodsExhibitionProvider;
import kd.occ.ocepfp.core.service.portal.card.NoticeCardProvider;
import kd.occ.ocepfp.core.service.portal.card.QuickNavigationProvider;
import kd.occ.ocepfp.core.service.portal.card.RankTableProvider;
import kd.occ.ocepfp.core.service.portal.card.SwiperCardProvider;
import kd.occ.ocepfp.core.service.portal.card.TrendCardProvider;

public class CardProviderFactory {
    private static final Map<String, AbstractCardProvider> _ProviderCache = new HashMap<String, AbstractCardProvider>();

    public static final AbstractCardProvider getCardProvider(String cardType) {
        return _ProviderCache.get(cardType);
    }

    static {
        _ProviderCache.put(PortalCardType.SwiperCard.getValue(), new SwiperCardProvider());
        _ProviderCache.put(PortalCardType.DataStatistics.getValue(), new DataStatisticsProvider());
        _ProviderCache.put(PortalCardType.RankTable.getValue(), new RankTableProvider());
        _ProviderCache.put(PortalCardType.TrendChart.getValue(), new TrendCardProvider());
        _ProviderCache.put(PortalCardType.NoticeCard.getValue(), new NoticeCardProvider());
        _ProviderCache.put(PortalCardType.GoodsExhibition.getValue(), new GoodsExhibitionProvider());
        _ProviderCache.put(PortalCardType.QuickNavigation.getValue(), new QuickNavigationProvider());
    }
}

