/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.service.portal.card;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.LoadCardRequest;
import kd.occ.ocepfp.common.util.BigDecimalUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.event.filter.QueryFilter;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.portal.IDataStatisticsPlugin;
import kd.occ.ocepfp.core.service.portal.DataStatisticsPluginUtil;
import kd.occ.ocepfp.core.service.portal.card.AbstractCardProvider;
import kd.occ.ocepfp.core.service.portal.card.util.DataStatisticsRequest;
import kd.occ.ocepfp.core.service.portal.card.util.DataStatisticsResponse;

public class DataStatisticsProvider
extends AbstractCardProvider {
    Log logger = LogFactory.getLog(DataStatisticsProvider.class);

    @Override
    public Object getData(ExtWebContext webCtx, LoadCardRequest loadCardParam) {
        List<DataStatisticsRequest> dataStatisticsRequestList = DataStatisticsRequest.decodeFromList(loadCardParam.getCardData());
        if (dataStatisticsRequestList == null || dataStatisticsRequestList.size() == 0) {
            return null;
        }
        return this.loadData(webCtx, dataStatisticsRequestList);
    }

    private Object loadData(ExtWebContext webCtx, List<DataStatisticsRequest> dataStatisticsRequestList) {
        Object data = "";
        ArrayList<DataStatisticsResponse> resultList = new ArrayList<DataStatisticsResponse>(dataStatisticsRequestList.size());
        for (DataStatisticsRequest request : dataStatisticsRequestList) {
            DataStatisticsResponse result = new DataStatisticsResponse();
            String customePlugin = request.getCustomePlugin();
            if (StringUtil.isNotNull((String)customePlugin)) {
                IDataStatisticsPlugin plugin = DataStatisticsPluginUtil.getDataStatisticsPlugin(webCtx, customePlugin);
                if (plugin != null) {
                    data = plugin.getLoadData(webCtx, request);
                } else {
                    this.logger.info("\u672a\u627e\u5230\u63d2\u4ef6\uff1a" + customePlugin);
                }
            } else {
                PageView listView = super.getListView(webCtx, request.getFormId());
                if (listView == null) {
                    this.logger.error(String.format("listView:%s\u627e\u4e0d\u5230", request.getFormId()));
                    continue;
                }
                QueryFilter queryFilter = super.buildQueryFilter(listView, request.getFilter());
                data = this.doLoadData(webCtx, request, queryFilter);
            }
            result.setName(request.getName());
            result.setValue(data == null ? "0" : BigDecimalUtil.getPlainString((Object)data));
            result.setId(request.getId());
            resultList.add(result);
        }
        return resultList;
    }

    protected Object doLoadData(ExtWebContext webCtx, DataStatisticsRequest request, QueryFilter queryFilter) {
        switch (request.getType().toLowerCase(Locale.ENGLISH)) {
            case "sum": {
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)request.getFormId().toLowerCase(), (String)request.getFieldOrm(), (QFilter[])queryFilter.toQFilter());
                BigDecimal sumData = dynamicObjectCollection.stream().map(r -> r.getBigDecimal(request.getFieldOrm())).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b)).setScale(2, RoundingMode.HALF_UP);
                return sumData;
            }
            case "count": {
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)request.getFormId().toLowerCase(), (String)request.getFieldOrm(), (QFilter[])queryFilter.toQFilter());
                return dynamicObjectCollection.size();
            }
        }
        return 0;
    }
}

