/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.service.portal.card;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.LoadCardRequest;
import kd.occ.ocepfp.common.util.DateUtil;
import kd.occ.ocepfp.core.service.portal.card.AbstractCardProvider;
import kd.occ.ocepfp.core.servicehelper.userinfo.UserInfoHelper;

public class NoticeCardProvider
extends AbstractCardProvider {
    private static final String SELECTFIELD = String.join((CharSequence)",", "id", "name", String.join((CharSequence)".", "group", "name"), "channelbutton", "userbutton", "usergroup", "channelgroup", String.join((CharSequence)".", "userentity", "usernumber"), String.join((CharSequence)".", "channelentity", "channel"), "createtime");

    @Override
    public Object getData(ExtWebContext webCtx, LoadCardRequest loadCardParam) {
        ArrayList dataList = new ArrayList();
        DynamicObjectCollection channelAnnounceList = this.getChannelAnnounceList();
        if (channelAnnounceList != null && !channelAnnounceList.isEmpty()) {
            int announceSize = channelAnnounceList.size();
            int showSize = channelAnnounceList.size() > 5 ? 5 : announceSize;
            int i = 0;
            int j = 0;
            String userNum = UserUtil.getUserInfo().getString("number");
            long customerId = UserInfoHelper.getLoginCustomerId();
            while (i < showSize && j < announceSize) {
                HashMap<String, String> data = new HashMap<String, String>();
                DynamicObject channelAnnounce = (DynamicObject)channelAnnounceList.get(j);
                boolean containChannel = false;
                boolean containUser = false;
                boolean publishByUser = channelAnnounce.getBoolean("userbutton");
                boolean publishByChannel = channelAnnounce.getBoolean("channelbutton");
                boolean isAllUser = channelAnnounce.getString("usergroup").equals("1");
                boolean isAllChannel = channelAnnounce.getString("channelgroup").equals("1");
                if (!publishByUser && !publishByChannel) {
                    ++j;
                    continue;
                }
                if (publishByUser && (isAllUser || channelAnnounce.getString(String.join((CharSequence)".", "userentity", "usernumber")).equals(userNum))) {
                    containUser = true;
                }
                if (publishByChannel && (isAllChannel || channelAnnounce.getLong(String.join((CharSequence)".", "channelentity", "channel")) == customerId)) {
                    containChannel = true;
                }
                if (containUser && !publishByChannel || containChannel && containUser || containChannel && !publishByUser) {
                    data.put("id", channelAnnounce.getString("id"));
                    data.put("text", channelAnnounce.getString("name"));
                    data.put("type", channelAnnounce.getString(String.join((CharSequence)".", "group", "name")));
                    Date createTime = channelAnnounce.getDate("createtime");
                    if (createTime != null) {
                        data.put("date", DateUtil.toDate4yyyyMMStr((Date)createTime, (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    dataList.add(data);
                    ++i;
                }
                ++j;
            }
        }
        return dataList;
    }

    private DynamicObjectCollection getChannelAnnounceList() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("publishstatus", "=", (Object)"1"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return QueryServiceHelper.query((String)"occbo_channelannoun", (String)SELECTFIELD, (QFilter[])filter.toArray(), (String)"createtime desc");
    }
}

