/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.service.view;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocepfp.common.constant.ExtDbRouter;
import kd.occ.ocepfp.common.entity.ExtView;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.DateUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.common.util.XMLUtil;
import kd.occ.ocepfp.core.editor.LocalFileSaveUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.ControlFactory;
import kd.occ.ocepfp.core.form.util.ISVUtil;
import kd.occ.ocepfp.core.form.view.parser.JfsXMLDiffer;
import kd.occ.ocepfp.core.form.view.parser.JfsXMLMerger;
import kd.occ.ocepfp.core.form.view.parser.PageViewBuilder;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ExtViewServiceHelper {
    private static Log logger = LogFactory.getLog(ExtViewServiceHelper.class);

    public static final ExtView getView(ExtWebContext webContxt, String viewKey) {
        SqlParameter param = new SqlParameter(":viewKey", 12, (Object)viewKey);
        return (ExtView)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FID,FVIEWKEY,FNAME,FEXTEND,FAPPEND,FDETAIL,FSUBPACKAGE,FVERSION,FISLOGIN,FENABLE,FAPPID,FSORT,FISV FROM T_OCEPFP_VIEW WHERE FVIEWKEY=? ORDER BY FEXTEND,FAPPEND", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<ExtView>(){

            public ExtView handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return ExtViewServiceHelper.buildExtView(resultSet);
                }
                return null;
            }
        });
    }

    public static final Document saveView(ExtWebContext webContxt, String viewKey, String xmlContent, long appId, String isNeedLogin, String loginType) throws Exception {
        Document xml = XMLUtil.getDocument((String)xmlContent, (String[])new String[0]);
        xml.getRootElement().addAttribute("needlogin", isNeedLogin);
        xml.getRootElement().addAttribute("logintype", loginType);
        String appendId = xml.getRootElement().attributeValue("append");
        ExtViewServiceHelper.saveView(webContxt, viewKey, xml, appId);
        return JfsXMLMerger.getJFSFileMerger(webContxt, StringUtil.isNotNull((String)appendId) ? ExtViewServiceHelper.getMainViewId(webContxt, appendId) : viewKey, StringUtil.isNotNull((String)appendId) ? viewKey : "", false, true).merge();
    }

    public static final void updateFileFromJarView(ExtWebContext webContxt, String viewKey, Document xmlContent, long appId) throws Exception {
        ExtViewServiceHelper.saveView(webContxt, viewKey, xmlContent, appId, false, false);
    }

    public static final void saveView(ExtWebContext webContxt, String viewKey, Document xmlContent, long appId) throws Exception {
        ExtViewServiceHelper.saveView(webContxt, viewKey, xmlContent, appId, true, true);
    }

    public static final void saveView(ExtWebContext webContxt, String viewKey, Document xmlContent) throws Exception {
        String appid = xmlContent.getRootElement().attributeValue("appid");
        Long appId = StringUtil.isNotNull((String)appid) ? Long.parseLong(appid) : 0L;
        ExtViewServiceHelper.saveView(webContxt, viewKey, xmlContent, (long)appId, false, false);
    }

    public static final void saveView(ExtWebContext webContxt, String viewKey, Document xmlContent, long appId, boolean needSaveLocalFile, boolean creatNewVersion) throws Exception {
        viewKey = viewKey.toLowerCase();
        String append = null;
        String version = ExtViewServiceHelper.getVersion();
        String xml = " ";
        String isv = ISVUtil.getISV();
        String string = isv = StringUtil.isNull((String)isv) ? " " : isv;
        if (xmlContent != null) {
            Document oldDocument;
            Element root = xmlContent.getRootElement();
            root.addAttribute("isv", isv);
            System.out.println(xmlContent.asXML());
            String isNeedLogin = root.attributeValue("needlogin");
            isNeedLogin = StringUtil.isNotNull((String)isNeedLogin) && ("true".equalsIgnoreCase(isNeedLogin) || "1".equalsIgnoreCase(isNeedLogin)) ? "1" : "0";
            Date currentDate = TimeServiceHelper.now();
            XMLUtil.reSetIndex((Element)root);
            String title = root.attributeValue("name");
            append = root.attributeValue("append");
            String extend = root.attributeValue("extend");
            if (!creatNewVersion && StringUtil.isNotNull((String)root.attributeValue("version"))) {
                version = root.attributeValue("version");
            } else {
                root.setAttributeValue("version", version);
            }
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            String name = StringUtil.isNull((String)title) ? (StringUtil.isNotNull((String)append) ? "\u6269\u5c55" : " ") : title;
            params.add(new SqlParameter(":FNAME", -9, (Object)name));
            params.add(new SqlParameter(":FAPPEND", 12, (Object)(StringUtil.isNull((String)append) ? " " : append.toLowerCase())));
            params.add(new SqlParameter(":FEXTEND", 12, (Object)(StringUtil.isNull((String)extend) ? " " : extend.toLowerCase())));
            Document newDocument = null;
            String mainViewKey = "";
            if (StringUtil.isNotNull((String)append)) {
                mainViewKey = ExtViewServiceHelper.getMainViewId(webContxt, append);
            }
            if ((oldDocument = JfsXMLMerger.getJFSFileMerger(webContxt, StringUtil.isNotNull((String)append) ? mainViewKey : (StringUtil.isNotNull((String)extend) ? extend : ""), StringUtil.isNotNull((String)append) ? viewKey : "", true, false).merge()) != null) {
                Attribute appendAttribute;
                if (StringUtil.isNotNull((String)append)) {
                    appId = Long.parseLong(oldDocument.getRootElement().attributeValue("appid"));
                }
                if ((appendAttribute = oldDocument.getRootElement().attribute("append")) != null) {
                    oldDocument.getRootElement().remove(appendAttribute);
                }
            }
            newDocument = JfsXMLDiffer.getJFSFileDiffer(webContxt).diffXML(xmlContent, oldDocument);
            Element newRoot = newDocument.getRootElement();
            newRoot.addAttribute("appid", Long.toString(appId));
            newRoot.addAttribute("needlogin", isNeedLogin);
            newRoot.addAttribute("logintype", root.attributeValue("logintype"));
            newRoot.addAttribute("name", name);
            xml = XMLUtil.formatXml((Document)newDocument);
            params.add(new SqlParameter(":FDETAIL", 2011, (Object)xml));
            params.add(new SqlParameter(":FVERSION", 12, (Object)version));
            params.add(new SqlParameter(":FAPPID", -5, (Object)appId));
            params.add(new SqlParameter(":FMODIFYTIME", 91, (Object)currentDate));
            params.add(new SqlParameter(":FISLOGIN", 1, (Object)isNeedLogin));
            params.add(new SqlParameter(":VIEWKEY", 12, (Object)viewKey));
            if (!DB.execute((DBRoute)ExtDbRouter.EXT, (String)"UPDATE T_OCEPFP_VIEW SET FNAME=?,FAPPEND=?,FEXTEND=?,FDETAIL=?,FVERSION=?,FAPPID=?,FMODIFYTIME=?,FISLOGIN=? WHERE FVIEWKEY=?", (Object[])params.toArray(new SqlParameter[params.size()]))) {
                params.add(new SqlParameter(":FID", 12, (Object)Uuid16.create().toString()));
                params.add(new SqlParameter(":FCREATETIME", 91, (Object)currentDate));
                params.add(new SqlParameter(":FISV", 12, (Object)isv));
                String mainKey = " ";
                int maxSort = 0;
                if (StringUtil.isNotNull((String)append)) {
                    mainKey = ExtViewServiceHelper.getMainViewId(webContxt, append);
                    if (mainKey.equalsIgnoreCase(viewKey)) {
                        mainKey = " ";
                    }
                    maxSort = ExtViewServiceHelper.getMaxOrder(webContxt, append);
                }
                params.add(new SqlParameter(":FMAINVIEWKEY", 12, (Object)mainKey));
                params.add(new SqlParameter(":FSORT", 4, (Object)maxSort));
                DB.execute((DBRoute)ExtDbRouter.EXT, (String)"INSERT INTO T_OCEPFP_VIEW(FNAME,FAPPEND,FEXTEND,FDETAIL,FVERSION,FAPPID,FMODIFYTIME,FISLOGIN,FVIEWKEY,FID,FCREATETIME,FISV,FMAINVIEWKEY,FSORT) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", (Object[])params.toArray(new SqlParameter[params.size()]));
            }
            ExtViewServiceHelper.addRevision(webContxt, viewKey, appId);
            if (needSaveLocalFile && ISVUtil.isDevelopmentEnv()) {
                ExtViewServiceHelper.saveLocalFile(webContxt, viewKey, newDocument, appId, version);
            }
            PageViewBuilder.rebuildPageView(webContxt, StringUtil.isNotNull((String)append) ? mainViewKey : viewKey);
        }
    }

    private static final String getVersion() {
        return DateUtil.toDate4yyyyMMStr((Date)new Date(System.currentTimeMillis()), (String)"YYYYMMddHHmmssSSS");
    }

    private static final void saveLocalFile(ExtWebContext webContxt, String viewKey, Document xmlContent, long appId, String version) {
        SqlParameter param = new SqlParameter(":FID", -5, (Object)appId);
        String svnPath = (String)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FSVNPATH FROM T_OCEPFP_APP WHERE FID =?", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getString("FSVNPATH");
                }
                return "";
            }
        });
        LocalFileSaveUtil.save2Local(svnPath, viewKey, xmlContent, appId, version);
    }

    public static final List<ExtView> getAllViews(ExtWebContext webContxt) {
        return (List)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FID,FVIEWKEY,FNAME,FEXTEND,FAPPEND,FDETAIL,FSUBPACKAGE,FVERSION,FISLOGIN,FENABLE,FAPPID,FSORT,FISV FROM T_OCEPFP_VIEW ORDER BY FEXTEND,FAPPEND", (ResultSetHandler)new ResultSetHandler<List<ExtView>>(){

            public List<ExtView> handle(ResultSet resultSet) throws Exception {
                ArrayList<ExtView> extViewList = new ArrayList<ExtView>(16);
                while (resultSet.next()) {
                    ExtView extView = ExtViewServiceHelper.buildExtView(resultSet);
                    extViewList.add(extView);
                }
                return extViewList;
            }
        });
    }

    public static final Map<String, Long> getAllViewVersions() {
        return (Map)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FVIEWKEY,FVERSION FROM T_OCEPFP_VIEW ORDER BY FEXTEND,FAPPEND", (ResultSetHandler)new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet resultSet) throws Exception {
                HashMap<String, Long> map = new HashMap<String, Long>(10);
                while (resultSet.next()) {
                    map.put(resultSet.getString("FVIEWKEY"), resultSet.getLong("FVERSION"));
                }
                return map;
            }
        });
    }

    private static final ExtView buildExtView(ResultSet resultSet) throws Exception {
        ExtView extView = new ExtView();
        extView.setFid(resultSet.getString("FID"));
        extView.setViewKey(resultSet.getString("FVIEWKEY").toLowerCase());
        extView.setName(resultSet.getString("FNAME"));
        extView.setExtend(StringUtil.isNotNull((String)resultSet.getString("FEXTEND")) ? resultSet.getString("FEXTEND") : "");
        extView.setAppend(StringUtil.isNotNull((String)resultSet.getString("FAPPEND")) ? resultSet.getString("FAPPEND") : "");
        extView.setDetail(XMLUtil.getDocument((String)resultSet.getString("FDETAIL"), (String[])new String[0]));
        extView.setSubPackage(resultSet.getString("FSUBPACKAGE"));
        extView.setVersion(resultSet.getString("FVERSION"));
        extView.setLogin(resultSet.getString("FISLOGIN"));
        extView.setEnableStatus(resultSet.getString("FENABLE"));
        extView.setAppId(resultSet.getLong("FAPPID"));
        extView.setSort(resultSet.getInt("FSORT"));
        extView.setIsv(resultSet.getString("FISV"));
        return extView;
    }

    public static final List<Map<String, String>> loadApp() {
        final ArrayList list = new ArrayList(4);
        SqlParameter param = new SqlParameter(":LOCALEID", 12, (Object)RequestContext.get().getLang().getLocale().toString());
        return (List)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FID,FNAME FROM T_OCEPFP_APP_L WHERE FLOCALEID=?", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<List<Map<String, String>>>(){

            public List<Map<String, String>> handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    HashMap<String, String> data = new HashMap<String, String>(2);
                    data.put("id", resultSet.getString("FID"));
                    data.put("name", resultSet.getString("FNAME"));
                    list.add(data);
                }
                return list;
            }
        });
    }

    public static final List<ExtView> getAppendViewByMainKey(ExtWebContext webContxt, String viewKey) {
        SqlParameter param = new SqlParameter(":viewKey", 12, (Object)viewKey);
        return (List)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FID,FVIEWKEY,FNAME,FEXTEND,FAPPEND,FDETAIL,FSUBPACKAGE,FVERSION,FISLOGIN,FENABLE,FAPPID,FSORT,FISV FROM T_OCEPFP_VIEW WHERE FMAINVIEWKEY=? ORDER BY FSORT", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<List<ExtView>>(){
            List<ExtView> appendViews = new ArrayList<ExtView>();

            public List<ExtView> handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    this.appendViews.add(ExtViewServiceHelper.buildExtView(resultSet));
                }
                return this.appendViews;
            }
        });
    }

    public static final List<ExtView> getAppendViewByKey(ExtWebContext webContxt, String viewKey) {
        SqlParameter param = new SqlParameter(":viewKey", 12, (Object)viewKey);
        return (List)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FID,FVIEWKEY,FNAME,FEXTEND,FAPPEND,FDETAIL,FSUBPACKAGE,FVERSION,FISLOGIN,FENABLE,FAPPID,FSORT,FISV FROM T_OCEPFP_VIEW WHERE FAPPEND=? ORDER BY FSORT", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<List<ExtView>>(){
            List<ExtView> appendViews = new ArrayList<ExtView>();

            public List<ExtView> handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    this.appendViews.add(ExtViewServiceHelper.buildExtView(resultSet));
                }
                return this.appendViews;
            }
        });
    }

    public static final List<ExtView> getExtendViewByKey(ExtWebContext webContxt, String viewKey) {
        SqlParameter param = new SqlParameter(":viewKey", 12, (Object)viewKey);
        return (List)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FID,FVIEWKEY,FNAME,FEXTEND,FAPPEND,FDETAIL,FSUBPACKAGE,FVERSION,FISLOGIN,FENABLE,FAPPID,FSORT,FISV FROM T_OCEPFP_VIEW WHERE FEXTEND=? ORDER BY FID", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<List<ExtView>>(){
            List<ExtView> appendViews = new ArrayList<ExtView>();

            public List<ExtView> handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    this.appendViews.add(ExtViewServiceHelper.buildExtView(resultSet));
                }
                return this.appendViews;
            }
        });
    }

    public static final List<String> getAllAffectedViews(String viewKey) {
        ArrayList<String> affectedViews = new ArrayList<String>(2);
        ExtViewServiceHelper.doGetAllAffectedViews(Collections.singletonList(viewKey), affectedViews);
        return affectedViews;
    }

    public static final List<String> getAllAffectedViews(List<String> viewKeys) {
        ArrayList<String> affectedViews = new ArrayList<String>(viewKeys.size());
        ExtViewServiceHelper.doGetAllAffectedViews(viewKeys, affectedViews);
        return affectedViews;
    }

    private static final void doGetAllAffectedViews(List<String> viewKeys, List<String> affectedViews) {
        if (viewKeys.size() == 0) {
            return;
        }
        Object[] params = new SqlParameter[viewKeys.size()];
        StringBuffer paramsStr = new StringBuffer();
        int i = 0;
        for (String viewKey : viewKeys) {
            if (i > 0) {
                paramsStr.append(",");
            }
            paramsStr.append("?");
            params[i] = new SqlParameter(":viewKey", 12, (Object)viewKey);
            ++i;
        }
        List currentAffectedViews = (List)DB.query((DBRoute)ExtDbRouter.EXT, (String)("SELECT FVIEWKEY FROM T_OCEPFP_VIEW WHERE FEXTEND in (" + paramsStr + ")"), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){
            List<String> viewsList = new ArrayList<String>();

            public List<String> handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    this.viewsList.add(resultSet.getString("FVIEWKEY"));
                }
                return this.viewsList;
            }
        });
        affectedViews.addAll(currentAffectedViews);
        if (currentAffectedViews.size() > 0) {
            ExtViewServiceHelper.doGetAllAffectedViews(currentAffectedViews, affectedViews);
        }
    }

    public static final Map<String, Object> getControls() {
        ArrayList controls = new ArrayList(10);
        for (Map.Entry<String, ControlFactory.Face> controlsFace : ControlFactory.getControls().entrySet()) {
            HashMap<String, Object> controlMap = new HashMap<String, Object>();
            controlMap.put("id", controlsFace.getKey().toLowerCase());
            controlMap.put("name", controlsFace.getValue().getName());
            controlMap.put("platform", controlsFace.getValue().getPlatform());
            controlMap.put("category", controlsFace.getValue().getCategory());
            controlMap.put("properties", ((Control)controlsFace.getValue().getControlInstance()).getPrivateProperties());
            controls.add(controlMap);
        }
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        Control control = new Control();
        data.put("commonProperties", control.getCommonProperties());
        data.put("controls", controls);
        return data;
    }

    public static final List<Map<String, Object>> getFiles(Long appId) {
        Collection<Map<String, Object>> valueCollection = ExtViewServiceHelper.getAllFiles(appId).values();
        return new ArrayList<Map<String, Object>>(valueCollection);
    }

    private static final Map<String, Map<String, Object>> getAllFiles(Long appId) {
        SqlParameter param = new SqlParameter(":appId", -5, (Object)appId);
        return (Map)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FID,FVIEWKEY,FNAME,FEXTEND,FAPPEND,FDETAIL,FSUBPACKAGE,FVERSION,FISLOGIN,FENABLE,FAPPID,FSORT,FISV FROM T_OCEPFP_VIEW WHERE FAPPID=? ORDER BY FSORT,FVIEWKEY", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Object>>>(){
            Map<String, Map<String, Object>> allFiles = new LinkedHashMap<String, Map<String, Object>>(10);
            Map<String, Map<String, Object>> allKey = new HashMap<String, Map<String, Object>>(10);

            public Map<String, Map<String, Object>> handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    try {
                        Map<String, Object> mainInfo;
                        ExtView extView = ExtViewServiceHelper.buildExtView(resultSet);
                        HashMap<String, Object> info = new HashMap<String, Object>(8);
                        info.put("name", extView.getName());
                        info.put("id", extView.getViewKey());
                        info.put("pk", extView.getFid());
                        info.put("package", "\u9875\u9762\u5217\u8868");
                        info.put("standard", true);
                        info.put("editable", true);
                        info.put("extend", extView.getExtend());
                        info.put("platform", "pc");
                        if (StringUtil.isNotNull((String)extView.getAppend()) && (mainInfo = this.allKey.get(extView.getAppend())) != null) {
                            ArrayList<HashMap<String, Object>> appendList = (ArrayList<HashMap<String, Object>>)mainInfo.get("append");
                            if (appendList == null) {
                                appendList = new ArrayList<HashMap<String, Object>>(4);
                                mainInfo.put("append", appendList);
                            }
                            this.allKey.put(extView.getViewKey(), info);
                            appendList.add(info);
                            continue;
                        }
                        this.allKey.put(extView.getViewKey(), info);
                        this.allFiles.put(extView.getViewKey(), info);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                this.allKey.clear();
                return this.allFiles;
            }
        });
    }

    public static final void addRevision(ExtWebContext webContxt, String viewKey, long appId) {
        String mainViewId = ExtViewServiceHelper.getMainViewId(webContxt, viewKey);
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FMODIFYDATE", 91, (Object)TimeServiceHelper.now()));
        params.add(new SqlParameter(":FAPPID", -5, (Object)appId));
        params.add(new SqlParameter(":FUSERID", -5, (Object)Long.parseLong(RequestContext.get().getUserId())));
        params.add(new SqlParameter(":FVIEWID", 12, (Object)mainViewId));
        if (!DB.execute((DBRoute)ExtDbRouter.EXT, (String)"UPDATE T_OCEPFP_VIEW_REVISION SET FMODIFYDATE=?,FAPPID=? WHERE FUSERID=? and FVIEWID=?", (Object[])params.toArray(new SqlParameter[params.size()]))) {
            params.add(new SqlParameter(":FID", -5, (Object)DB.genLongId((String)"T_OCEPFP_VIEW_REVISION")));
            DB.execute((DBRoute)ExtDbRouter.EXT, (String)"INSERT INTO T_OCEPFP_VIEW_REVISION(FMODIFYDATE,FAPPID,FUSERID,FVIEWID,FID) values(?,?,?,?,?)", (Object[])params.toArray(new SqlParameter[params.size()]));
        }
    }

    private static final int getMaxOrder(ExtWebContext webContxt, String viewKey) {
        ExtView view = ExtViewServiceHelper.getView(webContxt, viewKey);
        return view.getSort() + 1;
    }

    private static final String getMainViewId(ExtWebContext webContxt, String viewKey) {
        ExtView view = ExtViewServiceHelper.getView(webContxt, viewKey);
        String append = view.getDetail().getRootElement().attributeValue("append");
        if (StringUtil.isNull((String)append)) {
            return view.getViewKey();
        }
        return ExtViewServiceHelper.getMainViewId(webContxt, append);
    }

    public static final List<Map<String, Object>> getHistory(ExtWebContext webContxt, long appId) {
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":appId", -5, (Object)appId));
        params.add(new SqlParameter(":userId", -5, (Object)Long.parseLong(RequestContext.get().getUserId())));
        List simpleHistory = (List)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FVIEWID FROM T_OCEPFP_VIEW_REVISION WHERE FAPPID=? and FUSERID=? ORDER BY FMODIFYDATE DESC", (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)new ResultSetHandler<List<String>>(){
            List<String> list = new ArrayList<String>(10);

            public List<String> handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    this.list.add(resultSet.getString("FVIEWID"));
                }
                return this.list;
            }
        });
        Map<String, Map<String, Object>> allFiles = ExtViewServiceHelper.getAllFiles(appId);
        ArrayList<Map<String, Object>> historyList = new ArrayList<Map<String, Object>>(simpleHistory.size());
        for (String s : simpleHistory) {
            historyList.add(allFiles.get(s));
        }
        return historyList;
    }

    public static final ApiResult createFileContent(ExtWebContext webContxt, String extendId, String appendId, String platform, String viewKey, String name) {
        ApiResult apiResult;
        Document document = null;
        try {
            if (StringUtil.isNotNull((String)extendId)) {
                document = JfsXMLMerger.getJFSFileMerger(webContxt, extendId, "").merge();
                Element root = document.getRootElement();
                root.addAttribute("extend", extendId);
                Attribute append = root.attribute("append");
                if (append != null) {
                    root.remove(append);
                }
            } else if (StringUtil.isNotNull((String)appendId)) {
                String mainViewId = ExtViewServiceHelper.getMainViewId(webContxt, appendId);
                document = JfsXMLMerger.getJFSFileMerger(webContxt, mainViewId, appendId, false, true).merge();
                document.getRootElement().addAttribute("append", appendId);
            } else {
                document = ExtViewServiceHelper.createBlankFileContent(webContxt);
            }
            document.getRootElement().setAttributeValue("name", name);
            apiResult = ApiResult.success((Object)XMLUtil.formatXml((Document)document));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            apiResult = ApiResult.fail((String)e.getMessage());
        }
        return apiResult;
    }

    public static final ApiResult getFileContent(ExtWebContext webContxt, String viewKey, String appendId) {
        ApiResult apiResult;
        Document document = null;
        try {
            if (StringUtil.isNotNull((String)appendId)) {
                String mainViewId = ExtViewServiceHelper.getMainViewId(webContxt, viewKey);
                document = JfsXMLMerger.getJFSFileMerger(webContxt, mainViewId, viewKey, false, true).merge();
                document.getRootElement().addAttribute("append", appendId);
            } else {
                document = JfsXMLMerger.getJFSFileMerger(webContxt, viewKey, "").merge();
            }
            apiResult = ApiResult.success((Object)XMLUtil.formatXml((Document)document));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            apiResult = ApiResult.fail((String)e.getMessage());
        }
        return apiResult;
    }

    private static final Document createBlankFileContent(ExtWebContext webCtx) {
        Document mainDocument = DocumentHelper.createDocument();
        Element pageView = mainDocument.addElement("pageview");
        String type = webCtx.getForm().getString("type");
        type = type.equals("billView") || type.equals("listView") ? type : "billView";
        pageView.addAttribute("type", type);
        pageView.addAttribute("datatype", webCtx.getForm().getString("datatype"));
        pageView.addAttribute("logintype", webCtx.getForm().getString("logintype"));
        pageView.addAttribute("name", webCtx.getForm().getString("name"));
        pageView.addAttribute("needlogin", webCtx.getForm().getBoolean("needlogin") != false ? "1" : "0");
        pageView.addAttribute("platform", webCtx.getForm().getString("platform"));
        pageView.addElement("view");
        return mainDocument;
    }

    public static final List<Map<String, String>> getApps(ExtWebContext webContxt) {
        SqlParameter param = new SqlParameter(":localeid", 12, (Object)RequestContext.get().getLang().name());
        List result = (List)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FID,FNAME FROM T_OCEPFP_APP_L WHERE FLOCALEID =? ORDER BY FID DESC", (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<List<Map<String, String>>>(){

            public List<Map<String, String>> handle(ResultSet resultSet) throws Exception {
                ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(10);
                while (resultSet.next()) {
                    HashMap<String, String> data = new HashMap<String, String>(2);
                    data.put("id", resultSet.getString("FID"));
                    data.put("FNAME", resultSet.getString("FNAME"));
                    dataList.add(data);
                }
                return dataList;
            }
        });
        HashMap<String, String> noAppItem = new HashMap<String, String>(2);
        noAppItem.put("id", "0");
        noAppItem.put("FNAME", "\u6e38\u79bb\u5e94\u7528");
        result.add(noAppItem);
        return result;
    }

    public static final ApiResult deleteView(ExtWebContext webContxt, String viewId) {
        ApiResult apiResult = ApiResult.success((Object)"");
        String mainViewId = ExtViewServiceHelper.getMainViewId(webContxt, viewId);
        if (ExtViewServiceHelper.getAppendViewByKey(webContxt, viewId).size() > 0) {
            apiResult.setSuccess(false);
            apiResult.setMessage("\u5b58\u5728\u6269\u5c55\u7684\u9875\u9762\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u6269\u5c55\u7684\u6587 \u4ef6");
        } else if (ExtViewServiceHelper.getExtendViewByKey(webContxt, viewId).size() > 0) {
            apiResult.setSuccess(false);
            apiResult.setMessage("\u5df2\u88ab\u5176\u5b83\u7684\u9875\u9762\u7ee7\u627f\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u7ee7\u627f\u51fa\u6765\u7684\u6587\u4ef6");
        } else {
            ExtView view = ExtViewServiceHelper.getView(webContxt, viewId);
            if (!ISVUtil.getISV().equalsIgnoreCase(view.getIsv())) {
                apiResult.setSuccess(false);
                apiResult.setMessage("\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u4e0d\u80fd\u5220\u9664");
            } else if (ExtViewServiceHelper.delete(webContxt, viewId)) {
                apiResult.setMessage("\u5220\u9664\u6210\u529f");
                try {
                    PageViewBuilder.rebuildPageView(webContxt, mainViewId);
                }
                catch (IllegalAccessException | InstantiationException | DocumentException e) {
                    logger.error(e.getMessage(), e);
                }
            } else {
                apiResult.setSuccess(false);
                apiResult.setMessage("\u5220\u9664\u5931\u8d25\uff0c\u53ef\u80fd\u9875\u9762\u4e0d\u5b58\u5728\u3002");
            }
        }
        return apiResult;
    }

    private static final boolean delete(ExtWebContext webContxt, String viewId) {
        SqlParameter param = new SqlParameter(":FVIEWKEY", 12, (Object)viewId);
        return DB.execute((DBRoute)ExtDbRouter.EXT, (String)"DELETE  FROM T_OCEPFP_VIEW WHERE FVIEWKEY=?", (Object[])new SqlParameter[]{param});
    }
}

