/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.servicehelper;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.CollectionUtil;
import kd.occ.ocepfp.core.form.control.controls.Operation;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.filter.QueryFilter;
import kd.occ.ocepfp.core.metadata.MetadataFactory;
import kd.occ.ocepfp.core.orm.nextcloud.NextCloudEntityMetadataCache;
import kd.occ.ocepfp.core.service.metadata.ExtQueryFormServiceHelper;
import org.apache.commons.lang.reflect.MethodUtils;

public class ExtFormServiceHelper {
    private static Log logger = LogFactory.getLog(ExtFormServiceHelper.class);

    public static final DynamicObject queryOne(String viewId, String selectFields, Object pkValue) {
        return ExtFormServiceHelper.queryOne(viewId, selectFields, new QFilter("id", "=", (Object)Long.parseLong(pkValue.toString())).toArray());
    }

    public static final DynamicObject queryOne(String viewId, String selectFields, QFilter[] filters) {
        return QueryServiceHelper.queryOne((String)viewId.toLowerCase(), (String)selectFields, (QFilter[])filters);
    }

    public static final DynamicObject[] queryList(String viewId, String selectFields, Object[] pkValue) {
        return BusinessDataServiceHelper.load((String)viewId, (String)selectFields, (QFilter[])new QFilter("id", "in", (Object)CollectionUtil.convertToLong(Arrays.asList(pkValue))).toArray());
    }

    public static final DynamicObject[] queryList(String viewId, String selectFields, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)viewId, (String)selectFields, (QFilter[])filters);
    }

    public static final DynamicObject loadSingle(ExtWebContext extCtx, String viewId, Object pkValue, String selectFields) {
        return BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)viewId, (String)selectFields);
    }

    public static final DynamicObject loadSingle(ExtWebContext extCtx, String viewId, Object pkValue) {
        return BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)NextCloudEntityMetadataCache.getDataEntityType(extCtx, viewId));
    }

    public static final OperationResult executeOperate(ExtWebContext extCtx, String viewId, String operationKey, DynamicObject[] dataObjects) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        if ((operationKey.equals("save") || operationKey.equals("submit")) && MetadataFactory.getMetadata(extCtx).getBillNoField() != null) {
            option.setVariableValue("skipbillnovalidator_value", MetadataFactory.getMetadata(extCtx).getBillNoField().getId());
            option.setVariableValue("skipbillnovalidator", String.valueOf(true));
        }
        if (!(operationResult = OperationServiceHelper.executeOperate((String)operationKey.toLowerCase(), (String)viewId, (DynamicObject[])dataObjects, (OperateOption)option)).isSuccess()) {
            return operationResult;
        }
        ExtFormServiceHelper.sendWorkflowMsg(extCtx, operationKey, dataObjects, option);
        return operationResult;
    }

    public static final void save(ExtWebContext extCtx, String viewId, DynamicObject dataObject) {
        DynamicObject[] dataObjects = new DynamicObject[]{dataObject};
        ExtFormServiceHelper.save(extCtx, viewId, dataObjects);
    }

    public static final void save(ExtWebContext extCtx, String viewId, DynamicObject[] dataObjects) {
        SaveServiceHelper.save((DynamicObject[])dataObjects);
    }

    public static final ListDataSet<DynamicObjectCollection> loadList(ExtWebContext extCtx, String viewId, QueryFilter queryFilter, int page, int pageSize) {
        return ExtQueryFormServiceHelper.loadList(extCtx, viewId, queryFilter, page, pageSize);
    }

    public static final int getRecordCount(ExtWebContext extCtx, String viewId, QueryFilter queryFilter) {
        return ExtQueryFormServiceHelper.getRecordCount(extCtx, viewId, queryFilter);
    }

    public static final DynamicObjectCollection loadListById(ExtWebContext extCtx, String viewId, String selectFields, List<Object> ids) {
        return ExtQueryFormServiceHelper.loadListById(extCtx, viewId, selectFields, ids);
    }

    private static final void sendWorkflowMsg(ExtWebContext extCtx, String operationKey, DynamicObject[] srcDataObjects, OperateOption option) {
        Map<String, Operation> operations = extCtx.getCurrentPageView().getOperatios();
        if (operations == null) {
            return;
        }
        Operation operation = operations.get(operationKey);
        if (operation == null) {
            return;
        }
        if (operation.isSubmitWorkFlow()) {
            Object[] pkValues = new Object[srcDataObjects.length];
            int i = 0;
            for (DynamicObject srcDataObject : srcDataObjects) {
                pkValues[i++] = srcDataObject.getPkValue();
            }
            DynamicObject[] dataObjects = BusinessDataServiceHelper.load((Object[])pkValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)operation.getWorkFlowObject()));
            ExtFormServiceHelper.sendWorkflowMsg(dataObjects, operationKey, option);
        }
    }

    private static final void sendWorkflowMsg(DynamicObject[] objs, String operationKey, OperateOption option) {
        logger.info("EntityOperateService.sendWorkflowMsg(objs) begin.");
        if (objs == null || objs.length == 0) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                String entityNumber;
                Object obj = TypesContainer.createInstance((String)"kd.bos.workflow.service.TryTriggerProcessTask");
                if (obj != null && ((Boolean)MethodUtils.invokeMethod((Object)obj, (String)"canSendWfMsg", (Object[])new Object[]{entityNumber = objs[0].getDataEntityType().getName(), operationKey, option.getVariables()})).booleanValue()) {
                    MethodUtils.invokeMethod((Object)obj, (String)"sendTriggerProcessMsg", (Object[])new Object[]{objs, operationKey, option.getVariables()});
                }
            }
            catch (Exception e) {
                h.markRollback();
                logger.error((Throwable)e);
            }
        }
        logger.info("EntityOperateService.sendWorkflowMsg(objs) end.");
    }
}

