/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.servicehelper.userinfo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.b2b.ChannelUserHelper;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.UserSettingInfo;

public class UserInfoProcessor {
    private static final String loginInfoSelectField = String.join((CharSequence)",", "id", "channel", String.join((CharSequence)".", "channel", "id"), String.join((CharSequence)".", "channel", "name"), "user", "logintime", "isdefaluttheme", "iscustomtheme", "themecolor", "tabshowtype", "pageopentype", "supplierid", String.join((CharSequence)".", "supplierid", "id"), String.join((CharSequence)".", "supplierid", "name"));
    private static final String loginInfoSaveField = String.join((CharSequence)",", "isdefaluttheme", "iscustomtheme", "themecolor", "tabshowtype", "pageopentype");

    public long getLoginCustomerId() {
        ExtDynamicObject loginInfo = this.getLoginCustomerEntity();
        if (loginInfo != null) {
            return loginInfo.getLong("channel");
        }
        return 0L;
    }

    public ExtDynamicObject getLoginCustomerEntity() {
        ExtDynamicObject loginInfoCache = this.getLoginInfoCache();
        List<Object> customers = this.getLoginAuthrizedCustomer();
        if (customers == null || customers.size() == 0) {
            return null;
        }
        if (loginInfoCache == null || !customers.contains(loginInfoCache.getLong("channel"))) {
            QFilter filter = new QFilter("user", "=", (Object)UserUtil.getCurrUserId());
            filter.and("channel.enable", "=", (Object)Checked.YES.toString());
            DynamicObject loginInfo = QueryServiceHelper.queryOne((String)"ocepfp_logininfo", (String)loginInfoSelectField, (QFilter[])filter.toArray());
            if (loginInfo != null && customers.contains(loginInfo.getLong("channel"))) {
                return this.setLoginInfoCache(loginInfo);
            }
            long loginCustomerId = Long.parseLong(customers.toArray()[0].toString());
            this.saveLoginCustomer(loginCustomerId, loginInfo);
            loginInfo = QueryServiceHelper.queryOne((String)"ocepfp_logininfo", (String)loginInfoSelectField, (QFilter[])filter.toArray());
            return this.setLoginInfoCache(loginInfo);
        }
        return loginInfoCache;
    }

    public List<Object> getLoginAuthrizedCustomer() {
        return new ArrayList<Object>(CUserHelper.getAuthorizedChannelIdListByRole((long)1252179574154954752L));
    }

    public List<Long> getUserSetChannelIds() {
        return CUserHelper.getAuthorizedChannelIdListByRole((long)1252179574154954752L);
    }

    public long getChannelAuthByOrderChannelId(long orderChannelId) {
        long id = 0L;
        QFilter filter = new QFilter("orderchannel", "=", (Object)orderChannelId);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection customerAuthorizes = QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)"id", (QFilter[])filter.toArray(), (String)"isdefault desc");
        if (customerAuthorizes != null && customerAuthorizes.size() > 0) {
            id = ((DynamicObject)customerAuthorizes.get(0)).getLong("id");
        }
        return id;
    }

    public DynamicObject getLoginCustomerEntityNoCache() {
        QFilter filter = new QFilter("user", "=", (Object)UserUtil.getCurrUserId());
        DynamicObject loginInfo = QueryServiceHelper.queryOne((String)"ocepfp_logininfo", (String)loginInfoSelectField, (QFilter[])filter.toArray());
        return loginInfo;
    }

    public UserSettingInfo getUserSettingInfo() {
        UserSettingInfo userSettingInfo = new UserSettingInfo();
        ExtDynamicObject loginInfoCache = this.getLoginCustomerEntity();
        if (loginInfoCache != null) {
            userSettingInfo.setCustomThemeColor(loginInfoCache.getString("themecolor"));
            userSettingInfo.setDefaultTheme(loginInfoCache.getBoolean("isdefaluttheme").booleanValue());
            userSettingInfo.setTabShowType(loginInfoCache.getString("tabshowtype"));
            userSettingInfo.setPageOpenType(loginInfoCache.getString("pageopentype"));
        }
        return userSettingInfo;
    }

    private ExtDynamicObject setLoginInfoCache(DynamicObject loginInfoEntity) {
        if (loginInfoEntity != null) {
            ExtDynamicObject extData = new ExtDynamicObject();
            extData.put("channel", (Object)loginInfoEntity.getLong(String.join((CharSequence)".", "channel", "id")));
            extData.put(String.join((CharSequence)".", "channel", "name"), (Object)loginInfoEntity.getString(String.join((CharSequence)".", "channel", "name")));
            extData.put("isdefaluttheme", (Object)loginInfoEntity.getString("isdefaluttheme"));
            extData.put("iscustomtheme", (Object)loginInfoEntity.getString("iscustomtheme"));
            extData.put("themecolor", (Object)loginInfoEntity.getString("themecolor"));
            extData.put("tabshowtype", (Object)loginInfoEntity.getString("tabshowtype"));
            extData.put("pageopentype", (Object)loginInfoEntity.getString("pageopentype"));
            extData.put("supplierid", (Object)loginInfoEntity.getLong(String.join((CharSequence)".", "supplierid", "id")));
            return extData;
        }
        return null;
    }

    private ExtDynamicObject getLoginInfoCache() {
        return null;
    }

    public void saveLoginCustomer(long loginCustomerId, DynamicObject oldLoginCustomer) {
        this.saveLoginCustomer(loginCustomerId, 0L, oldLoginCustomer);
    }

    public void saveLoginCustomer(long loginCustomerId, long supplierId, DynamicObject oldLoginCustomer) {
        if (supplierId == 0L) {
            supplierId = this.getChannelAuthByOrderChannelId(loginCustomerId);
        }
        DynamicObject logincustomer = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ocepfp_logininfo"));
        if (oldLoginCustomer != null) {
            QFilter filter = new QFilter("user", "=", (Object)UserUtil.getCurrUserId());
            logincustomer = BusinessDataServiceHelper.loadSingle((String)"ocepfp_logininfo", (String)String.join((CharSequence)",", "id", "user", "channel", "supplierid", "logintime"), (QFilter[])filter.toArray());
        }
        logincustomer.set("user", (Object)UserUtil.getCurrUserId());
        logincustomer.set("channel", (Object)loginCustomerId);
        logincustomer.set("logintime", (Object)new Date());
        logincustomer.set("supplierid", (Object)supplierId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logincustomer});
    }

    public boolean updateLoginCustomer(long loginCustomerId) {
        return this.updateLoginCustomer(loginCustomerId, 0L);
    }

    public boolean updateLoginCustomer(long loginCustomerId, long supplierId) {
        QFilter filter = new QFilter("user", "=", (Object)UserUtil.getCurrUserId());
        DynamicObject[] loginInfoArray = BusinessDataServiceHelper.load((String)"ocepfp_logininfo", (String)loginInfoSelectField, (QFilter[])filter.toArray());
        if (loginInfoArray == null) {
            this.saveLoginCustomer(loginCustomerId, supplierId, null);
            DynamicObject logincustomer = BusinessDataServiceHelper.loadSingle((String)"ocepfp_logininfo", (String)loginInfoSelectField, (QFilter[])filter.toArray());
            this.setLoginInfoCache(logincustomer);
            return true;
        }
        if (loginInfoArray.length > 1) {
            long needDeleteId = loginInfoArray[1].getLong("id");
            QFilter deleteFilter = new QFilter("id", "=", (Object)needDeleteId);
            DeleteServiceHelper.delete((String)"ocepfp_logininfo", (QFilter[])deleteFilter.toArray());
        }
        loginInfoArray[0].set("channel", (Object)loginCustomerId);
        if (supplierId == 0L) {
            supplierId = this.getChannelAuthByOrderChannelId(loginCustomerId);
        }
        loginInfoArray[0].set("supplierid", (Object)supplierId);
        loginInfoArray[0].set("logintime", (Object)new Date());
        SaveServiceHelper.save((IDataEntityType)loginInfoArray[0].getDataEntityType(), (Object[])new DynamicObject[]{loginInfoArray[0]});
        DynamicObject logincustomer = BusinessDataServiceHelper.loadSingle((String)"ocepfp_logininfo", (String)loginInfoSelectField, (QFilter[])filter.toArray());
        this.setLoginInfoCache(logincustomer);
        return true;
    }

    public boolean updateUserSettingInfo(UserSettingInfo userSettingInfo) {
        QFilter filter = new QFilter("user", "=", UserUtil.getUserID());
        DynamicObject loginUserInfo = BusinessDataServiceHelper.loadSingle((String)"ocepfp_logininfo", (String)loginInfoSaveField, (QFilter[])filter.toArray());
        if (loginUserInfo != null) {
            loginUserInfo.set("themecolor", (Object)userSettingInfo.getCustomThemeColor());
            loginUserInfo.set("isdefaluttheme", (Object)userSettingInfo.isDefaultTheme());
            loginUserInfo.set("iscustomtheme", (Object)(!userSettingInfo.isDefaultTheme() ? 1 : 0));
            loginUserInfo.set("tabshowtype", (Object)userSettingInfo.getTabShowType());
            loginUserInfo.set("pageopentype", (Object)userSettingInfo.getPageOpenType());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loginUserInfo});
            loginUserInfo = BusinessDataServiceHelper.loadSingle((String)"ocepfp_logininfo", (String)loginInfoSelectField, (QFilter[])filter.toArray());
            this.setLoginInfoCache(loginUserInfo);
        } else {
            long loginCustomerId = this.getLoginCustomerId();
            this.saveLoginCustomer(loginCustomerId, null);
            this.updateUserSettingInfo(userSettingInfo);
        }
        return true;
    }

    public DynamicObject getCustomerEntryById(long channelId) {
        QFilter filter = new QFilter("id", "=", (Object)channelId);
        DynamicObject logincustomer = QueryServiceHelper.queryOne((String)"ocdbd_channel", (String)String.join((CharSequence)",", "id", "number", "name", "currency", "customer", String.join((CharSequence)".", "currency", "sign"), String.join((CharSequence)".", "currency", "amtprecision"), String.join((CharSequence)".", "currency", "priceprecision")), (QFilter[])filter.toArray());
        return logincustomer;
    }

    public DynamicObject getDefaultCustomerAddressById(long channelId) {
        QFilter filter = new QFilter("customer", "=", (Object)channelId);
        filter.and(new QFilter("isdefault", "=", (Object)"1"));
        DynamicObject channelAddress = QueryServiceHelper.queryOne((String)"ocdbd_channel_address", (String)"id,contactname,telephone,fixedtel,email,address,address2", (QFilter[])filter.toArray());
        return channelAddress;
    }

    public DynamicObject getCustomerAddressById(long addressId) {
        QFilter filter = new QFilter("id", "=", (Object)addressId);
        DynamicObject customerAddress = QueryServiceHelper.queryOne((String)"ocdbd_channel_address", (String)"id,contactname,telephone,fixedtel,email,address,address2", (QFilter[])filter.toArray());
        return customerAddress;
    }

    public DynamicObjectCollection getAuthorityCustomerList() {
        DynamicObjectCollection authrizedCustomers = ChannelUserHelper.getAuthorityCustomerList();
        return authrizedCustomers;
    }

    public DynamicObjectCollection getSalerInfo(long orderCustomerId, long saleCustomerId) {
        QFilter filter = new QFilter("owner", "=", (Object)saleCustomerId);
        filter.and("customer", "=", (Object)orderCustomerId);
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection salerList = QueryServiceHelper.query((String)"mdr_cust_saler_relation", (String)"user,user.name,user.entryentity.dpt", (QFilter[])filter.toArray(), (String)"isdefault desc");
        return salerList;
    }

    public DynamicObjectCollection getUserPositionByUserId(long userId) {
        QFilter filter = new QFilter("user", "=", (Object)userId);
        DynamicObjectCollection userPositionList = QueryServiceHelper.query((String)"bos_userposition", (String)"id,user,org", (QFilter[])filter.toArray());
        return userPositionList;
    }

    public DynamicObject getSaleOrgById(long saleOrgId) {
        QFilter filter = new QFilter("id", "=", (Object)saleOrgId);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)String.join((CharSequence)",", "id", "name"), (QFilter[])filter.toArray());
        return org;
    }
}

