/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.formplugin.home;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;

public class SalesRankingList
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        String datarange = param.get("datarange").toString();
        String order = param.get("orderby").toString();
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        switch (datarange) {
            case "A": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfMonth((Date)TimeServiceHelper.today()));
                break;
            }
            case "B": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getBeforeMonth((int)3));
                break;
            }
            case "C": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfYear((Date)TimeServiceHelper.today()));
                break;
            }
            case "D": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfWeek((Date)TimeServiceHelper.today()));
                break;
            }
            case "E": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getTodayWee());
                break;
            }
        }
        DataSet dataSet = this.buildDataSet(new String[]{"2", "3"}, qFilter);
        dataSet = dataSet.orderBy(new String[]{"ticketvalue desc"});
        DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(dataSet);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Object[] branchIds = (Long[])dynamicObjectCollection.stream().map(s -> Long.parseLong(s.getString("branchid"))).toArray(Long[]::new);
        DynamicObject[] branchs = BusinessDataServiceHelper.load((Object[])branchIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ocdbd_channel"));
        int index = 0;
        block22: for (DynamicObject dyo : dynamicObjectCollection) {
            if (dyo.get("branchid").equals(0L) || !(dyo.get("branchid") instanceof Long)) continue;
            switch (order) {
                case "B": {
                    if (!dyo.get("opertype").equals("2")) break;
                    DynamicObject dynamicObject = new DynamicObject(entryEntity.getDynamicObjectType());
                    for (DynamicObject branch : branchs) {
                        if (!branch.getString("id").equals(dyo.getString("branchid"))) continue;
                        dynamicObject.set("branch", (Object)branch);
                        break;
                    }
                    if (dynamicObject.get("branch") == null) continue block22;
                    dynamicObject.set("ranking", (Object)(++index));
                    if (dyo.getBigDecimal("ticketvalue").compareTo(BigDecimal.ZERO) > 0) {
                        dynamicObject.set("writeoffamount", (Object)new BigDecimal(dyo.get("ticketvalue").toString()).intValue());
                    } else {
                        dynamicObject.set("writeoffamount", (Object)BigDecimal.ZERO);
                    }
                    dynamicObject.set("writeoffnember", dyo.get("id"));
                    for (DynamicObject dyo1 : dynamicObjectCollection) {
                        if (!dyo1.getString("branchid").equals(dynamicObject.getDynamicObject("branch").getString("id")) || !dyo1.getString("opertype").equals("3")) continue;
                        dynamicObject.set("publishamount", (Object)new BigDecimal(dyo1.get("ticketvalue").toString()).intValue());
                        dynamicObject.set("publishnumber", dyo1.get("id"));
                    }
                    entryEntity.add((Object)dynamicObject);
                    break;
                }
                case "A": {
                    if (!dyo.get("opertype").equals("3")) break;
                    DynamicObject dynamicObject = new DynamicObject(entryEntity.getDynamicObjectType());
                    for (DynamicObject branch : branchs) {
                        if (!branch.getString("id").equals(dyo.get("branchid").toString())) continue;
                        dynamicObject.set("branch", (Object)branch);
                        break;
                    }
                    if (dynamicObject.get("branch") == null) continue block22;
                    dynamicObject.set("ranking", (Object)(++index));
                    if (dyo.getBigDecimal("ticketvalue").compareTo(BigDecimal.ZERO) > 0) {
                        dynamicObject.set("publishamount", (Object)new BigDecimal(dyo.get("ticketvalue").toString()).intValue());
                    } else {
                        dynamicObject.set("publishamount", (Object)BigDecimal.ZERO);
                    }
                    dynamicObject.set("publishnumber", dyo.get("id"));
                    for (DynamicObject dyo1 : dynamicObjectCollection) {
                        if (!dyo1.getString("branchid").equals(dynamicObject.getDynamicObject("branch").getString("id")) || !dyo1.getString("opertype").equals("2")) continue;
                        dynamicObject.set("writeoffamount", (Object)new BigDecimal(dyo1.get("ticketvalue").toString()).intValue());
                        dynamicObject.set("writeoffnember", dyo1.get("id"));
                    }
                    entryEntity.add((Object)dynamicObject);
                    break;
                }
            }
            this.getView().updateView();
        }
    }

    private String getSelectFild() {
        return String.join((CharSequence)",", "branchid", "billformid", "opertype", "tickettypeid.ticketvalue as ticketvalue");
    }

    private DataSet buildDataSet(String[] operType, QFilter qFilter) {
        qFilter.and("opertype", "in", (Object)operType);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocgcm_ticketactionflow", (String)this.getSelectFild(), (QFilter[])qFilter.toArray(), null);
        GroupbyDataSet groupByDataSet = dataSet.groupBy(new String[]{"branchid", "opertype"});
        groupByDataSet = groupByDataSet.sum("ticketvalue").count("id");
        return groupByDataSet.finish();
    }
}

