/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.formplugin.home;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.occ.ocgcm.business.helper.TicketHomeDataHelper;

public class TicketSituationChart
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.drawChart();
    }

    public void drawChart() {
        HistogramChart customchart = this.getMainChart();
        customchart.clearData();
        customchart.setName(new LocaleString("\u793c\u5238\u6570\u636e\u67f1\u72b6\u56fe"));
        customchart.setShowTooltip(true);
        customchart.setShowLegend(true);
        customchart.setMargin(Position.right, "80");
        customchart.setLegendVertical(false);
        List<String> materiaName = this.getMateriaName();
        Map<Group, List<Number>> sortedData = this.getData02();
        sortedData.forEach(this::createBarSeries);
        Axis xAxis = this.createCategoryAxis();
        xAxis.setPosition(Position.insideBottomRight);
        xAxis.setCategorys(materiaName);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>(0);
        axisLabel.put("rotate", 50);
        axisLabel.put("type", "shadow");
        axisLabel.put("show", Boolean.TRUE);
        xAxis.setPropValue("axisLabel", axisLabel);
        Axis yAxis = this.createValueAxis();
        HashMap<String, String> axisLabel1 = new HashMap<String, String>(0);
        axisLabel1.put("formatter", "{value}");
        yAxis.setPropValue("axisLabel", axisLabel1);
        yAxis.setPropValue("minInterval", (Object)1);
        HashMap<String, Object> yAxisPointer = new HashMap<String, Object>(0);
        yAxisPointer.put("show", Boolean.TRUE);
        yAxisPointer.put("type", "line");
        Label yAxisLabel = new Label();
        yAxisLabel.setShow(true);
        yAxisLabel.setBackgroundColor("black");
        yAxisPointer.put("axisLabel", yAxisLabel);
        HashMap<String, String> lineStyle = new HashMap<String, String>(0);
        lineStyle.put("type", "dotted");
        yAxisPointer.put("lineStyle", lineStyle);
        yAxisPointer.put("triggerTooltip", Boolean.FALSE);
        yAxis.setPropValue("axisPointer", yAxisPointer);
        customchart.refresh();
    }

    private void createBarSeries(Group group, List<Number> data) {
        BarSeries barSeries = this.getMainChart().createBarSeries(group.groupName);
        barSeries.setBarWidth("25px");
        barSeries.setColor(group.color);
        barSeries.setType(group.chartType);
        barSeries.setAnimationDuration(2000);
        barSeries.setPropValue("yAxisIndex", (Object)group.yAxisIndex);
        barSeries.setData(data.toArray(new Number[0]));
    }

    private List<String> getMateriaName() {
        List result = TicketHomeDataHelper.getTicketTypeData();
        ArrayList<String> materiaName = new ArrayList<String>(result.size());
        for (Map map : result) {
            materiaName.add(map.get("name").toString());
        }
        return materiaName;
    }

    private Map<Group, List<Number>> getData02() {
        LinkedHashMap<Group, List<Number>> summaryResult = new LinkedHashMap<Group, List<Number>>();
        List<Group> groups = this.getDefaultGroups();
        ArrayList<Number> list01 = new ArrayList<Number>();
        List result = TicketHomeDataHelper.getTicketTypeData();
        for (Map map : result) {
            if (map.get("publishnumber") == null) {
                list01.add(0);
                continue;
            }
            list01.add(Long.parseLong(map.get("publishnumber").toString()));
        }
        summaryResult.put(groups.get(0), list01);
        ArrayList<Number> list02 = new ArrayList<Number>();
        for (Map map : result) {
            if (map.get("writeoffnember") == null) {
                list02.add(0);
                continue;
            }
            list02.add(Long.parseLong(map.get("writeoffnember").toString()));
        }
        summaryResult.put(groups.get(1), list02);
        return summaryResult;
    }

    private Axis createCategoryAxis() {
        Axis axis = this.getMainChart().createXAxis("\u793c\u5238\u7c7b\u578b", AxisType.category);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>(0);
        axisTick.put("interval", 0);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis);
        return axis;
    }

    private Axis createValueAxis() {
        Axis axis = this.getMainChart().createYAxis("\u6570\u76ee/\u5f20", AxisType.value);
        HashMap axisTick = new HashMap(0);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap(0);
        HashMap<String, String> lineStyle = new HashMap<String, String>(0);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis);
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private void setLineColor(Axis axix) {
        HashMap axisLineMap = new HashMap(0);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(0);
        lineStyleMap.put("color", "#b2b2b2");
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl("histogramchartap");
    }

    private List<Group> getDefaultGroups() {
        ArrayList<Group> defaultGroupList = new ArrayList<Group>(4);
        defaultGroupList.add(new Group("\u53d1\u552e\u6570", "#648cf9", ChartType.bar, 0));
        defaultGroupList.add(new Group("\u6838\u9500\u6570", "#48a4f6", ChartType.bar, 0));
        return defaultGroupList;
    }

    static class Group {
        private final String groupName;
        private final String color;
        private final ChartType chartType;
        private final Integer yAxisIndex;

        public Group(String groupName, String color, ChartType chartType, Integer yAxisIndex) {
            this.groupName = groupName;
            this.color = color;
            this.chartType = chartType;
            this.yAxisIndex = yAxisIndex;
        }

        public String toString() {
            return "Group{groupName='" + this.groupName + '\'' + ", color='" + this.color + '\'' + ", chartType=" + this.chartType + ", yAxisIndex=" + this.yAxisIndex + '}';
        }
    }
}

