/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.formplugin.ticketpublish;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.business.helper.changemodel.CurrencyHelper;
import kd.occ.ocbase.common.enums.DataStatusEnum;
import kd.occ.ocbase.common.enums.TicketStatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdbd.common.util.OwnerUtil;

public class TicketsPublishEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ticketEdit = (BasedataEdit)this.getView().getControl("ticketid");
        ticketEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit branchEdit = (BasedataEdit)this.getView().getControl("branchid");
        branchEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void initDefaultLocalCurrency() {
        long orgId = RequestContext.get().getOrgId();
        if (orgId <= 0L) {
            return;
        }
        DynamicObject CurrencyDyn = CurrencyHelper.getCurrency((Long)orgId);
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)CurrencyDyn);
        this.getView().getModel().setItemValueByID("flocalcurrencyid", (Object)currencyId);
        DynamicObject branch = (DynamicObject)this.getModel().getValue("branchid");
        long setcurrencyid = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"currency");
        this.getView().getModel().setItemValueByID("settlecurrencyid", (Object)setcurrencyid);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            this.initDefaultBranchID();
            this.initDefaultLocalCurrency();
            this.getView().setEnable(Boolean.FALSE, new String[]{"discountamount"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"discountrate"});
        }
    }

    private void initDefaultBranchID() {
        DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("org");
        if (doBizOrg != null) {
            List lstOwner = OwnerUtil.getOwnerIds((long)DynamicObjectUtils.getPkValue((DynamicObject)doBizOrg), (boolean)true);
            Object ownerId = OwnerUtil.getDefaultOwnerId((List)lstOwner);
            this.getView().getModel().setValue("branchid", ownerId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "ticketid": {
                this.setQytAndAmount();
                break;
            }
            case "org": 
            case "branchid": {
                this.initDefaultLocalCurrency();
                break;
            }
            case "realsaleamount": {
                this.setRealAmount();
                break;
            }
            case "exchangerateid": {
                this.setRate(e);
                break;
            }
            case "discountrate": {
                this.setDiscountRate();
                break;
            }
            case "discountamount": {
                this.setDiscountAmount();
                break;
            }
            case "payamount": {
                this.setPayAmount(e);
                break;
            }
            case "paymodeid": {
                this.setPayWayType(e);
                break;
            }
            case "paycurrencyid": {
                this.setRate(e);
                break;
            }
        }
    }

    private void setPayWayType(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject payMode = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (payMode == null) {
            this.getModel().setValue("paywaytypeid", null, rowIndex);
            this.getModel().setValue("paycurrencyid", null, rowIndex);
            return;
        }
        DynamicObjectCollection payWayCol = payMode.getDynamicObjectCollection("paywaytype");
        if (payWayCol != null && payWayCol.size() > 0) {
            this.getModel().setValue("paywaytypeid", (Object)((DynamicObject)payWayCol.get(0)).getDynamicObject("fbasedataid"), rowIndex);
            this.getView().updateView("paywaytypeid", rowIndex);
        } else {
            this.getModel().setValue("paywaytypeid", null, rowIndex);
        }
        DynamicObject branch = (DynamicObject)this.getModel().getValue("branchid");
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        if (branch != null) {
            qFilter.and("treeentryentity.branch.Id", "=", branch.getPkValue());
        }
        qFilter.and("entryentity.channel.Id", "=", payMode.getPkValue());
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"dbd_payconfigs", (String)"id,entryentity.currencyid", (QFilter[])new QFilter[]{qFilter});
        if (dyn == null) {
            QFilter filter = new QFilter("entryentity.channel.Id", "=", payMode.getPkValue());
            filter.and("status", "=", (Object)"C");
            filter.and("controlmode", "=", (Object)"0");
            dyn = BusinessDataServiceHelper.loadSingle((String)"dbd_payconfigs", (String)"id,entryentity.currencyid", (QFilter[])new QFilter[]{filter});
        }
        if (dyn != null && dyn.getDynamicObjectCollection("entryentity") != null && dyn.getDynamicObjectCollection("entryentity").size() > 0 && ((DynamicObject)dyn.getDynamicObjectCollection("entryentity").get(0)).get("currencyid") != null) {
            this.getModel().setValue("paycurrencyid", ((DynamicObject)dyn.getDynamicObjectCollection("entryentity").get(0)).get("currencyid"), rowIndex);
            this.getView().updateView("paycurrencyid", rowIndex);
            this.setRate(e);
        }
    }

    private void setPayAmount(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal payAmt = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (payAmt == null || BigDecimal.ZERO.compareTo(payAmt) == 0) {
            this.getModel().setValue("localcrypayamount", null, rowIndex);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int rowIndex = e.getRowDataEntities()[0].getRowIndex();
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"paymodeentry")) {
            DynamicObject exrateTable;
            DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("org");
            if (doBizOrg != null && (exrateTable = CurrencyHelper.getExRateTable((Long)((Long)doBizOrg.getPkValue()))) != null) {
                this.getModel().setValue("exchangerateid", exrateTable.getPkValue(), rowIndex);
            }
            this.getModel().setValue("exchangetype", (Object)1, rowIndex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"entryentity")) {
            this.setQytAndAmount();
        }
    }

    public void afterCopyData(EventObject e) {
        BigDecimal discountrate;
        BigDecimal discountamount;
        Integer qty;
        BigDecimal realamount;
        BigDecimal amount;
        DynamicObjectCollection payEntryColl;
        super.afterCopyData(e);
        DynamicObjectCollection ticketInfoEntryColl = this.getModel().getEntryEntity("entryentity");
        if (ticketInfoEntryColl.size() > 0) {
            this.getModel().deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
        }
        if ((payEntryColl = this.getModel().getEntryEntity("paymodeentry")).size() > 0) {
            this.getModel().deleteEntryData("paymodeentry");
            this.getView().updateView("paymodeentry");
        }
        if ((amount = (BigDecimal)this.getModel().getValue("amount")) != null && BigDecimal.ZERO.compareTo(amount) < 0) {
            this.getModel().setValue("amount", null);
            this.getView().updateView("amount");
        }
        if ((realamount = (BigDecimal)this.getModel().getValue("realamount")) != null && BigDecimal.ZERO.compareTo(realamount) < 0) {
            this.getModel().setValue("realamount", null);
            this.getView().updateView("realamount");
        }
        if ((qty = (Integer)this.getModel().getValue("publishqty")) != null && qty > 0) {
            this.getModel().setValue("publishqty", null);
            this.getView().updateView("publishqty");
        }
        if ((discountamount = (BigDecimal)this.getModel().getValue("discountamount")) != null && BigDecimal.ZERO.compareTo(discountamount) < 0) {
            this.getModel().setValue("discountamount", null);
            this.getView().updateView("discountamount");
        }
        if ((discountrate = (BigDecimal)this.getModel().getValue("discountrate")) != null && BigDecimal.ZERO.compareTo(discountrate) < 0) {
            this.getModel().setValue("discountrate", null);
            this.getView().updateView("discountrate");
        }
    }

    private void setRealAmount() {
        BigDecimal realAmount = BigDecimal.ZERO;
        DynamicObjectCollection ticketInfoEntryColl = this.getModel().getEntryEntity("entryentity");
        if (ticketInfoEntryColl.size() > 0) {
            for (DynamicObject ticketInfoEntry : ticketInfoEntryColl) {
                if (ticketInfoEntry.getBigDecimal("realsaleamount") == null) continue;
                realAmount = realAmount.add(ticketInfoEntry.getBigDecimal("realsaleamount"));
            }
            this.getModel().setValue("realamount", (Object)realAmount);
            this.getView().updateView("realamount");
        }
        BigDecimal refsaleAmount = (BigDecimal)this.getModel().getValue("amount");
        this.setDiscountAmtAndDiscountRate(realAmount, refsaleAmount);
    }

    private void setDiscountAmtAndDiscountRate(BigDecimal realAmount, BigDecimal refsaleAmount) {
        if (refsaleAmount.subtract(realAmount).compareTo(new BigDecimal(0)) > 0 && refsaleAmount.compareTo(new BigDecimal(0)) > 0) {
            BigDecimal discountAmount = refsaleAmount.subtract(realAmount);
            BigDecimal discountRate = realAmount.divide(refsaleAmount, 4).multiply(BigDecimal.valueOf(100L));
            this.getModel().setValue("discountamount", (Object)discountAmount);
            this.getModel().setValue("discountrate", (Object)discountRate);
        } else {
            this.getModel().setValue("discountamount", null);
            this.getModel().setValue("discountrate", null);
        }
    }

    private void setQytAndAmount() {
        Integer qty = 0;
        BigDecimal refsaleAmount = BigDecimal.ZERO;
        BigDecimal realAmount = BigDecimal.ZERO;
        DynamicObjectCollection ticketInfoEntryColl = this.getModel().getEntryEntity("entryentity");
        if (ticketInfoEntryColl.size() > 0) {
            for (DynamicObject ticketInfoEntry : ticketInfoEntryColl) {
                long ticketsInfoID = ticketInfoEntry.getLong("ticketid_id");
                if (ticketsInfoID <= 0L) continue;
                qty = qty + 1;
                DynamicObject ticketInfoDyn = ticketInfoEntry.getDynamicObject("ticketid");
                refsaleAmount = refsaleAmount.add(TicketsPublishEdit.getBigDecimal(ticketInfoDyn, "refsaleamount"));
                realAmount = realAmount.add(TicketsPublishEdit.getBigDecimal(ticketInfoEntry, "realsaleamount"));
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"discountamount"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"discountrate"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"discountamount"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"discountrate"});
        }
        this.setValue("publishqty", qty, 0);
        this.setValue("amount", refsaleAmount, 0);
        this.setValue("realamount", refsaleAmount, 0);
        this.setDiscountAmtAndDiscountRate(realAmount, refsaleAmount);
    }

    private void setRate(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            this.setValue("exchangerate", null, rowIndex);
            this.setValue("localcrypayamount", null, rowIndex);
            return;
        }
        Object settleCurrency = this.getValue("paycurrencyid", rowIndex);
        Object exrateTable = this.getValue("exchangerateid", rowIndex);
        Object loCurrency = this.getValue("flocalcurrencyid", 0);
        if (settleCurrency == null || exrateTable == null || loCurrency == null) {
            return;
        }
        Long settleCurrencyId = ((DynamicObject)settleCurrency).getLong("id");
        Long exrateTableId = ((DynamicObject)exrateTable).getLong("id");
        Long loCurrencyId = ((DynamicObject)loCurrency).getLong("id");
        BigDecimal rate = CurrencyHelper.getExChangeRate((Long)settleCurrencyId, (Long)loCurrencyId, (Long)exrateTableId);
        this.setValue("exchangerate", rate, rowIndex);
    }

    private void setDiscountAmount() {
        BigDecimal discountAmount = (BigDecimal)this.getValue("discountamount", 0);
        BigDecimal amount = (BigDecimal)this.getValue("amount", 0);
        if (discountAmount.compareTo(new BigDecimal(0)) > 0 && amount.compareTo(new BigDecimal(0)) > 0) {
            BigDecimal realAmount = amount.subtract(discountAmount);
            BigDecimal discountRate = realAmount.divide(amount, 4).multiply(BigDecimal.valueOf(100L));
            this.updateValue("discountrate", discountRate);
            this.updateValue("realamount", realAmount);
        }
    }

    private void setDiscountRate() {
        BigDecimal discountRate = (BigDecimal)this.getValue("discountrate", 0);
        if (discountRate != null && discountRate.compareTo(new BigDecimal(0)) > 0) {
            BigDecimal amount = (BigDecimal)this.getValue("amount", 0);
            BigDecimal discountAmount = amount.multiply(discountRate).divide(BigDecimal.valueOf(100L), 4);
            BigDecimal realAmount = amount.subtract(discountAmount);
            this.updateValue("discountamount", discountAmount);
            this.updateValue("realamount", realAmount);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel dataModel = this.getModel();
        switch (fieldKey) {
            case "ticketid": {
                DynamicObject customerDyn = (DynamicObject)dataModel.getValue("branchid");
                DynamicObject bizOrgDyn = (DynamicObject)dataModel.getValue("org");
                if (ObjectUtils.isEmpty((Object)customerDyn) || ObjectUtils.isEmpty((Object)bizOrgDyn)) {
                    e.setCancel(true);
                    throw new KDBizException("\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u548c\u53d1\u552e\u95e8\u5e97");
                }
                showParameter.getListFilterParameter().setQFilters(this.ticketInfoFilter(dataModel));
                break;
            }
            case "branchid": {
                QFilter qFilter = this.buildBranchFilter();
                if (qFilter != null) {
                    showParameter.getListFilterParameter().setFilter(qFilter);
                    break;
                }
                e.setCancel(true);
                break;
            }
        }
    }

    private List<QFilter> ticketInfoFilter(IDataModel dataModel) {
        DynamicObject customerDyn = (DynamicObject)dataModel.getValue("branchid");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter branchFilter = new QFilter("publishbranchid", "=", customerDyn.getPkValue());
        branchFilter.or(new QFilter("publishbranchid", "=", (Object)0));
        qFilters.add(branchFilter);
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(TicketStatusEnum.NO_MAKE.getName());
        selectList.add(TicketStatusEnum.RECEIVED.getName());
        QFilter ticketQFilter1 = new QFilter("ticketstatus", "in", selectList);
        QFilter ticketQFilter2 = new QFilter("cancelstatus", "=", (Object)DataStatusEnum.SAVED);
        qFilters.add(ticketQFilter1);
        qFilters.add(ticketQFilter2);
        DynamicObjectCollection ticketInfoEntryColl = dataModel.getEntryEntity("entryentity");
        ArrayList<Long> selectedTicketInfoIds = null;
        if (ticketInfoEntryColl.size() > 0) {
            selectedTicketInfoIds = new ArrayList<Long>(ticketInfoEntryColl.size());
            for (DynamicObject ticketInfoEntry : ticketInfoEntryColl) {
                if (ticketInfoEntry.getLong("ticketid_id") <= 0L) continue;
                selectedTicketInfoIds.add(ticketInfoEntry.getLong("ticketid_id"));
            }
        }
        if (selectedTicketInfoIds != null && selectedTicketInfoIds.size() > 0) {
            QFilter ticketQFilter3 = new QFilter("id", "not in", selectedTicketInfoIds);
            qFilters.add(ticketQFilter3);
        }
        return qFilters;
    }

    private QFilter buildBranchFilter() {
        DynamicObject doBizOrg = (DynamicObject)this.getValue("org", 0);
        if (doBizOrg != null) {
            long bizOrgId = Long.parseLong(String.valueOf(doBizOrg.getPkValue()));
            return OwnerUtil.getOwnerIdsFilter((long)bizOrgId);
        }
        return null;
    }

    public static BigDecimal getBigDecimal(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return BigDecimal.ZERO;
        }
        return item.getBigDecimal(key);
    }

    private void updateValue(String key, Object value) {
        this.getView().getModel().beginInit();
        this.getView().getModel().setValue(key, value);
        this.getView().updateView(key);
        this.getView().getModel().endInit();
    }

    public Object getValue(String key, int rowIndex) {
        if (rowIndex > 0) {
            return this.getModel().getValue(key, rowIndex);
        }
        return this.getModel().getValue(key);
    }

    public void setValue(String key, Object value, int rowIndex) {
        if (rowIndex > 0) {
            this.getModel().setValue(key, value, rowIndex);
        }
        this.getModel().setValue(key, value);
    }
}

