/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.formplugin.ticketsmake;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.OperationException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.occ.ocbase.common.enums.TicketFlowOperTypeEnum;
import kd.occ.ocbase.common.pojo.TicketFlowParamVO;
import kd.occ.ocbase.common.pojo.TicketsInfoVO;
import kd.occ.ocdbd.business.helper.TicketActionFlowHelper;
import kd.occ.ocdbd.business.helper.ticket.TicketsInfoHelper;
import kd.occ.ocgcm.formplugin.ticketsmake.MyTask;

public class TicketMakeProcessFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_BTNSTART = "btnstart";
    private static final String KEY_BTNCLOSE = "btnclose";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    public static final String CACHEKEY_PROGRESS = "progress";
    public static final String CACHEKEY_STARTPROPGRESS = "startprogress";
    public static final String KEY_SIZE = "size";
    public static final String KEY_FID = "fid";
    public static final String KEY_RULEID = "ruleid";
    public static final String KEY_RETURN = "returnvalue";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"TicketMakeProcessFormPlugin", (int)1);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{KEY_BTNSTART, KEY_BTNCLOSE});
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().getModel().setValue("createid", (Object)RequestContext.get().getUserName());
        this.getView().getModel().setValue("createdate", (Object)TimeServiceHelper.now());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_BTNSTART, (CharSequence)source.getKey())) {
            if (this.getPageCache().get(CACHEKEY_PROGRESS) != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u793c\u5238\u5236\u4f5c\u8fc7\u7a0b\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", (String)"TicketMakeProcessFormPlugin_0", (String)"occ-ocgcm-formplugin", (Object[])new Object[0]));
            } else {
                this.start();
            }
        } else if (StringUtils.equals((CharSequence)KEY_BTNCLOSE, (CharSequence)source.getKey())) {
            int progress = 0;
            if (this.getPageCache().get(CACHEKEY_PROGRESS) != null) {
                progress = Integer.parseInt(this.getPageCache().get(CACHEKEY_PROGRESS));
                if (progress < 100) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u793c\u5238\u5236\u4f5c\u8fc7\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u5173\u95ed", (String)"TicketMakeProcessFormPlugin_1", (String)"occ-ocgcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().returnDataToParent((Object)this.getPageCache().get(KEY_RETURN));
                    this.getView().close();
                }
            } else {
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        int progress = 0;
        if (this.getPageCache().get(CACHEKEY_PROGRESS) != null) {
            progress = Integer.parseInt(this.getPageCache().get(CACHEKEY_PROGRESS));
            if (progress == 100) {
                this.getView().returnDataToParent((Object)this.getPageCache().get(KEY_RETURN));
            } else {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u793c\u5238\u5236\u4f5c\u8fc7\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u5173\u95ed", (String)"TicketMakeProcessFormPlugin_1", (String)"occ-ocgcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void onProgress(ProgressEvent arg0) {
        String startProgress = this.getPageCache().get(CACHEKEY_STARTPROPGRESS);
        if (StringUtils.isBlank((CharSequence)startProgress)) {
            arg0.setProgress(0);
            return;
        }
        int progress = 0;
        String cacheProgress = this.getPageCache().get(CACHEKEY_PROGRESS);
        if (StringUtils.isNotBlank((CharSequence)cacheProgress)) {
            progress = Integer.parseInt(cacheProgress);
        }
        if (progress >= 100) {
            this.afterProgress();
        }
        arg0.setProgress(progress);
    }

    private void afterProgress() {
        int size = Integer.parseInt(this.getPageCache().get(KEY_SIZE));
        if (size > 0) {
            this.getModel().setValue("tips", (Object)(ResManager.loadKDString((String)"\u672c\u6b21\u5236\u5238\u5b8c\u6210,\u603b\u5171\u5236\u4f5c\u793c\u5238\u3010", (String)"TicketMakeProcessFormPlugin_2", (String)"occ-ocgcm-formplugin", (Object[])new Object[0]) + size + ResManager.loadKDString((String)"\u3011\u5f20", (String)"TicketMakeProcessFormPlugin_3", (String)"occ-ocgcm-formplugin", (Object[])new Object[0])));
            this.getView().updateView("tips");
        } else {
            this.getModel().setValue("tips", (Object)(ResManager.loadKDString((String)"\u672c\u6b21\u5236\u5238\u5931\u8d25,\u603b\u5171\u5236\u5238\u3010", (String)"TicketMakeProcessFormPlugin_4", (String)"occ-ocgcm-formplugin", (Object[])new Object[0]) + size + ResManager.loadKDString((String)"\u3011\u5f20", (String)"TicketMakeProcessFormPlugin_3", (String)"occ-ocgcm-formplugin", (Object[])new Object[0])));
            this.getView().updateView("tips");
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTNSTART});
    }

    private void start() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.start();
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c...", (String)"TicketMakeProcessFormPlugin_5", (String)"occ-ocgcm-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("tips", (Object)ResManager.loadKDString((String)"\u5f00\u59cb\u5236\u5238.......", (String)"TicketMakeProcessFormPlugin_6", (String)"occ-ocgcm-formplugin", (Object[])new Object[0]));
        this.getView().updateView("tips");
        this.getPageCache().put(CACHEKEY_STARTPROPGRESS, "true");
        this.getPageCache().put(CACHEKEY_PROGRESS, "0");
        this.startMakeCard();
        MyTask myTask = new MyTask(RequestContext.get(), this.getView().getPageId());
        threadPool.execute((Runnable)myTask);
    }

    private void startMakeCard() {
        int vosize;
        List ticketsInfoVOS;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long fid = (Long)formShowParameter.getCustomParam(KEY_FID);
        this.getModel().setValue("tips", (Object)ResManager.loadKDString((String)"\u5f00\u59cb\u5236\u4f5c\u793c\u5238", (String)"TicketMakeProcessFormPlugin_7", (String)"occ-ocgcm-formplugin", (Object[])new Object[0]));
        try (TXHandle h1 = TX.required((String)"ocgcm_ticketmake_view");){
            try {
                ArrayList<Long> billIdList = new ArrayList<Long>(1);
                billIdList.add(fid);
                ticketsInfoVOS = TicketsInfoHelper.saveTicketsInfo(billIdList, (String)"ocgcm_ticketsmake", (String)"");
                vosize = ticketsInfoVOS.size();
                if (vosize == 0) {
                    h1.markRollback();
                }
                ArrayList<Long> ticketids = new ArrayList<Long>(vosize);
                for (TicketsInfoVO ticketsInfoVO : ticketsInfoVOS) {
                    ticketids.add(ticketsInfoVO.getId());
                }
                TicketFlowParamVO ticketFlowParamVO = new TicketFlowParamVO();
                ticketFlowParamVO.setBillIdList(ticketids);
                ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_MAKE);
                ticketFlowParamVO.setBillFormId("ocgcm_ticketsmake");
                TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
            }
            catch (OperationException e) {
                h1.markRollback();
                throw e;
            }
        }
        this.getPageCache().put(KEY_SIZE, String.valueOf(vosize));
        this.setCallback(ticketsInfoVOS);
    }

    private void setCallback(List<TicketsInfoVO> ticketsInfoVOS) {
        String ticketsstartvalue = ticketsInfoVOS.get(0).getNumber();
        String ticketsendvalue = ticketsInfoVOS.get(ticketsInfoVOS.size() - 1).getNumber();
        String returnvalue = String.join((CharSequence)",", ticketsstartvalue, ticketsendvalue);
        this.getPageCache().put(KEY_RETURN, returnvalue);
    }
}

