/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.formplugin.validitychallenge;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class ValidityChallengeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ticketEdit = (BasedataEdit)this.getView().getControl("ticket");
        ticketEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ticketsEdit = (BasedataEdit)this.getView().getControl("ticketstype");
        ticketsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.adjustmentTypeChange("0");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (fieldKey = e.getProperty().getName()) {
            case "adjustmenttype": {
                this.adjustmentTypeChange(newValue);
                break;
            }
            case "ticket": {
                this.ticketChange(rowIndex);
                break;
            }
            case "ticketstype": {
                this.ticketTypeChange(rowIndex);
                break;
            }
        }
        this.getView().updateView("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (rowIndex != 0) {
            entryGrid.selectRows(rowIndex);
        }
    }

    private void ticketTypeChange(int rowIndex) {
        DynamicObject changeRowDyo = (DynamicObject)this.getView().getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity").get(rowIndex);
        DynamicObject ticketType = changeRowDyo.getDynamicObject("ticketstype");
        changeRowDyo.set("oldstartdate", ticketType.get("startdate"));
        changeRowDyo.set("oldenddate", ticketType.get("enddate"));
        changeRowDyo.set("usagemode", ticketType.get("usagemode"));
    }

    private void ticketChange(int rowIndex) {
        DynamicObject changeRowDyo = (DynamicObject)this.getView().getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity").get(rowIndex);
        DynamicObject ticket = changeRowDyo.getDynamicObject("ticket");
        changeRowDyo.set("oldstartdate", ticket.get("starttime"));
        changeRowDyo.set("oldenddate", ticket.get("endtime"));
        long ticketTypeId = ticket.getDynamicObject("tickettypeid").getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)ticketTypeId);
        DynamicObject ticketType = QueryServiceHelper.queryOne((String)"ocdbd_ticketstype", (String)"usagemode", (QFilter[])qFilter.toArray());
        changeRowDyo.set("usagemode", ticketType.get("usagemode"));
        changeRowDyo.set("usagemode", ticketType.get("usagemode"));
    }

    private void adjustmentTypeChange(Object newValue) {
        switch (ObjectUtils.nullSafeToString((Object)newValue)) {
            case "0": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"ticket", "ticketstatus", "ticketvalue", "maketime"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"ticketstype", "ticketstypename", "tickettypevalue"});
                break;
            }
            case "1": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"ticket", "ticketstatus", "ticketvalue", "maketime"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"ticketstype", "ticketstypename", "tickettypevalue"});
                break;
            }
        }
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("entryentity");
        entryEntity.clear();
        entryEntity.addNew();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "save": 
            case "submit": {
                DynamicObjectCollection dyoCollection = this.getView().getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
                ArrayList<Integer> removeRow = new ArrayList<Integer>(0);
                for (int i = 0; i < dyoCollection.size(); ++i) {
                    DynamicObject dyo = (DynamicObject)dyoCollection.get(i);
                    if (dyo.get("ticketstype") != null || dyo.get("ticket") != null) continue;
                    removeRow.add(i);
                }
                int[] intArray = removeRow.stream().mapToInt(Integer::valueOf).toArray();
                this.getModel().deleteEntryRows("entryentity", intArray);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ArrayList<Long> ids = new ArrayList<Long>(0);
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(Boolean.TRUE.booleanValue());
        String adjustmentType = dataEntity.getString("adjustmenttype");
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        switch (fieldKey) {
            case "ticket": {
                if (!StringUtils.equals((CharSequence)adjustmentType, (CharSequence)"1")) break;
                for (DynamicObject entryRow : entryEntity) {
                    long id = DynamicObjectUtils.getPkValue((DynamicObject)entryRow, (String)"ticket");
                    ids.add(id);
                }
                break;
            }
            case "ticketstype": {
                if (!StringUtils.equals((CharSequence)adjustmentType, (CharSequence)"0")) break;
                for (DynamicObject entryRow : entryEntity) {
                    long id = DynamicObjectUtils.getPkValue((DynamicObject)entryRow, (String)"ticketstype");
                    ids.add(id);
                }
                break;
            }
        }
        QFilter qFilter = new QFilter("id", "not in", ids);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }
}

