/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.mservice.ticketdistribute;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.enums.TicketFlowOperTypeEnum;
import kd.occ.ocbase.common.pojo.TicketDistributeParamVo;
import kd.occ.ocbase.common.pojo.TicketDistributeResVO;
import kd.occ.ocbase.common.pojo.TicketFlowParamVO;
import kd.occ.ocbase.common.pojo.TicketInfoParamVO;
import kd.occ.ocbase.common.pojo.TicketsInfoVO;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.ORMUtil;
import kd.occ.ocdbd.business.dispatch.UserServiceDispatcher;
import kd.occ.ocdbd.business.helper.TicketActionFlowHelper;
import kd.occ.ocdbd.business.helper.ticket.TicketDistributeHelper;
import kd.occ.ocgcm.common.enums.TicketApplyTerminalEnum;
import kd.occ.ocgcm.common.enums.TicketConditionEnum;
import kd.occ.ocgcm.common.result.TicketInfoServiceResult;
import kd.occ.ocgcm.meservice.api.ticketdistribute.ITicketDistributeService;

public class TicketDistributeServiceImpl
implements ITicketDistributeService {
    private static Log logger = LogFactory.getLog(TicketDistributeServiceImpl.class);

    public JSONObject distribute(JSONObject jsonParam) {
        try {
            long ticketDistributeId = jsonParam.getLong("ticketdistributeid");
            long vipID = jsonParam.getLong("vipid");
            long branchId = jsonParam.getLong("branchId");
            DynamicObject distributeDyn = BusinessDataServiceHelper.loadSingle((Object)ticketDistributeId, (String)"ocdbd_issuescheme");
            TicketDistributeParamVo distributeParamVo = (TicketDistributeParamVo)JSONObject.toJavaObject((JSON)jsonParam, TicketDistributeParamVo.class);
            JSONObject vipJsonRes = UserServiceDispatcher.queryUserByCondition((String)String.valueOf(vipID), (long)branchId);
            boolean isVisible = TicketDistributeHelper.filterByMember((DynamicObject)distributeDyn, (TicketDistributeParamVo)distributeParamVo, (JSONObject)vipJsonRes);
            boolean matchBranch = TicketDistributeHelper.filterByBranch((DynamicObject)distributeDyn, (TicketDistributeParamVo)distributeParamVo);
            if (!isVisible || !matchBranch) {
                throw new KDBizException("\u60a8\u4e0d\u5728\u5f53\u524d\u793c\u5238\u9886\u53d6\u8303\u56f4\u5185");
            }
            boolean isExceedTotalQty = TicketDistributeHelper.isExceedTotalQty((DynamicObject)distributeDyn, (TicketDistributeParamVo)distributeParamVo);
            if (isExceedTotalQty) {
                throw new KDBizException("\u9886\u53d6\u6570\u91cf\u5df2\u8fbe\u5230\u4e0a\u9650");
            }
            boolean isExceedVipGetMaxQty = TicketDistributeHelper.isExceedVipGetMaxQty((DynamicObject)distributeDyn, (TicketDistributeParamVo)distributeParamVo);
            if (isExceedVipGetMaxQty) {
                throw new KDBizException("\u5355\u4e2a\u4f1a\u5458\u9886\u53d6\u6570\u91cf\u5df2\u8fbe\u5230\u4e0a\u9650");
            }
            ArrayList<Long> billIdList = new ArrayList<Long>(1);
            billIdList.add(ticketDistributeId);
            TicketInfoParamVO ticketInfoParamVO = new TicketInfoParamVO(billIdList, "ocdbd_issuescheme", "");
            ticketInfoParamVO.setMemberId(Long.valueOf(vipID));
            ticketInfoParamVO.setBranchId(Long.valueOf(branchId));
            List ticketsInfoVos = TicketDistributeHelper.distribute((TicketInfoParamVO)ticketInfoParamVO);
            ArrayList<Long> ticketIds = new ArrayList<Long>(ticketsInfoVos.size());
            for (TicketsInfoVO ticketsInfoVO : ticketsInfoVos) {
                ticketIds.add(ticketsInfoVO.getId());
            }
            TicketFlowParamVO ticketFlowParamVO = new TicketFlowParamVO();
            ticketFlowParamVO.setVipId(Long.valueOf(vipID));
            ticketFlowParamVO.setBranchId(Long.valueOf(branchId));
            ticketFlowParamVO.setBillIdList(ticketIds);
            ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_DISTRIBUTE);
            ticketFlowParamVO.setBillFormId("ocdbd_issuescheme");
            TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
            return TicketInfoServiceResult.success((Object)ticketsInfoVos);
        }
        catch (Throwable e) {
            return TicketInfoServiceResult.fail((String)e.getMessage());
        }
    }

    public JSONObject queryListFromOnLineStore(JSONObject jsonParam) {
        try {
            TicketDistributeParamVo distributeParamVo = (TicketDistributeParamVo)JSONObject.toJavaObject((JSON)jsonParam, TicketDistributeParamVo.class);
            long start = System.currentTimeMillis();
            DynamicObject[] dynamicObjectArr = TicketDistributeHelper.queryList((TicketDistributeParamVo)distributeParamVo);
            logger.info("\u83b7\u53d6\u9886\u53d6\u793c\u5238\u5217\u8868\u8017\u65f6\u7edf\u8ba11  this.queryListFromOnLineStore consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002" + dynamicObjectArr.length);
            long vipID = distributeParamVo.getVipId();
            ArrayList<TicketDistributeResVO> distributeResList = new ArrayList<TicketDistributeResVO>(dynamicObjectArr.length);
            ArrayList<String> distributeNumberList = new ArrayList<String>(dynamicObjectArr.length);
            ArrayList<Long> distributeDynIdList = new ArrayList<Long>(dynamicObjectArr.length);
            for (DynamicObject distributeDyn : dynamicObjectArr) {
                String distributeNumber = distributeDyn.getString("number");
                distributeNumberList.add(distributeNumber);
                distributeDynIdList.add(DynamicObjectUtils.getPkValue((DynamicObject)distributeDyn, (String)"tickettypeid"));
            }
            QFilter filter = new QFilter("billno", "in", (Object)distributeNumberList.toArray());
            start = System.currentTimeMillis();
            DynamicObject[] totalDistributeActionFlowArrAll = BusinessDataServiceHelper.load((String)"ocgcm_ticketactionflow", (String)"id,billno", (QFilter[])filter.toArray());
            logger.info("\u83b7\u53d6\u9886\u53d6\u793c\u5238\u5217\u8868\u8017\u65f6\u7edf\u8ba12  this.queryListFromOnLineStore consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002" + totalDistributeActionFlowArrAll.length);
            Map<String, List<DynamicObject>> totalDistributeActionFlowArrMap = Arrays.asList(totalDistributeActionFlowArrAll).stream().collect(Collectors.groupingBy(p -> p.getString("billno")));
            filter.and("vipid", "=", (Object)vipID);
            start = System.currentTimeMillis();
            DynamicObject[] vipDistributeActionFlowArrAll = BusinessDataServiceHelper.load((String)"ocgcm_ticketactionflow", (String)"id,billno", (QFilter[])filter.toArray());
            logger.info("\u83b7\u53d6\u9886\u53d6\u793c\u5238\u5217\u8868\u8017\u65f6\u7edf\u8ba13  this.queryListFromOnLineStore consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002" + vipDistributeActionFlowArrAll.length);
            Map<String, List<DynamicObject>> vipDistributeActionFlowArrMap = Arrays.asList(vipDistributeActionFlowArrAll).stream().collect(Collectors.groupingBy(p -> p.getString("billno")));
            QFilter qFilter = new QFilter("id", "in", (Object)distributeDynIdList.toArray());
            String selectFields = this.querydistributeDynSelectFields();
            start = System.currentTimeMillis();
            DynamicObject[] ticketTypeDynAll = BusinessDataServiceHelper.load((String)"ocdbd_ticketstype", (String)selectFields, (QFilter[])qFilter.toArray());
            logger.info("\u83b7\u53d6\u9886\u53d6\u793c\u5238\u5217\u8868\u8017\u65f6\u7edf\u8ba14  this.queryListFromOnLineStore consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002" + ticketTypeDynAll.length);
            Map<Long, DynamicObject> ticketTypeDynMap = Arrays.asList(ticketTypeDynAll).stream().collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
            for (DynamicObject distributeDyn : dynamicObjectArr) {
                TicketDistributeResVO distributeResVo = new TicketDistributeResVO();
                String distributeNumber = distributeDyn.getString("number");
                List<DynamicObject> totalDistributeActionFlowArr = totalDistributeActionFlowArrMap.get(distributeNumber);
                List<DynamicObject> vipDistributeActionFlowArr = vipDistributeActionFlowArrMap.get(distributeNumber);
                DynamicObject ticketTypeDyn = ticketTypeDynMap.get(DynamicObjectUtils.getPkValue((DynamicObject)distributeDyn, (String)"tickettypeid"));
                distributeResVo.setVipId(Long.valueOf(vipID));
                distributeResVo.setVipGetMaxQty(Integer.valueOf(distributeDyn.getInt("vipgetmaxqty")));
                distributeResVo.setVipHasReceiveQty(Integer.valueOf(vipDistributeActionFlowArr == null ? 0 : vipDistributeActionFlowArr.size()));
                distributeResVo.setTotalQty(Integer.valueOf(distributeDyn.getInt("totalqty")));
                distributeResVo.setHasDistributeTotalQty(Integer.valueOf(totalDistributeActionFlowArr == null ? 0 : totalDistributeActionFlowArr.size()));
                distributeResVo.setSchemeID((Long)distributeDyn.getPkValue());
                distributeResVo.setSchemeNumber(distributeDyn.getString("number"));
                distributeResVo.setSchemeName(distributeDyn.getString("name"));
                if (ticketTypeDyn != null) {
                    Date endDate;
                    Date startDate;
                    Date dtNow;
                    int validityDays;
                    distributeResVo.setTicketTypeID((Long)ticketTypeDyn.getPkValue());
                    distributeResVo.setTicketTypeNumber(ticketTypeDyn.getString("number"));
                    distributeResVo.setTicketValue(ticketTypeDyn.getBigDecimal("ticketvalue"));
                    distributeResVo.setSaleAmount(ticketTypeDyn.getBigDecimal("saleamount"));
                    distributeResVo.setTicketStyle(ticketTypeDyn.getString("ticketstyle"));
                    distributeResVo.setTicketName(ticketTypeDyn.getString("name"));
                    distributeResVo.setMinConsumeAmount(ticketTypeDyn.getBigDecimal("minconsumeamount"));
                    distributeResVo.setCondition(TicketConditionEnum.getValue((String)ticketTypeDyn.getString("condition")));
                    distributeResVo.setDiscountrate(ticketTypeDyn.getBigDecimal("discountrate"));
                    distributeResVo.setUsagemode(ticketTypeDyn.getString("usagemode"));
                    String startDateStr = "";
                    String endDateStr = "";
                    String validPeriodType = DynamicObjectUtils.getString((DynamicObject)distributeDyn, (String)"validperiodtype");
                    if (StringUtils.isEmpty((Object)validPeriodType)) {
                        validPeriodType = DynamicObjectUtils.getString((DynamicObject)ticketTypeDyn, (String)"validperiodtype");
                        validityDays = DynamicObjectUtils.getInt((DynamicObject)ticketTypeDyn, (String)"validitydays");
                        if ("A".equals(validPeriodType)) {
                            startDate = dtNow = TimeServiceHelper.now();
                            endDate = DateUtil.dayAdd((Date)dtNow, (int)validityDays);
                        } else {
                            startDate = DynamicObjectUtils.getDate((DynamicObject)ticketTypeDyn, (String)"startdate");
                            endDate = DynamicObjectUtils.getDate((DynamicObject)ticketTypeDyn, (String)"enddate");
                        }
                    } else {
                        validityDays = DynamicObjectUtils.getInt((DynamicObject)distributeDyn, (String)"relativedays");
                        if ("A".equals(validPeriodType)) {
                            startDate = dtNow = TimeServiceHelper.now();
                            endDate = DateUtil.dayAdd((Date)dtNow, (int)validityDays);
                        } else {
                            startDate = DynamicObjectUtils.getDate((DynamicObject)distributeDyn, (String)"startdate");
                            endDate = DynamicObjectUtils.getDate((DynamicObject)distributeDyn, (String)"enddate");
                        }
                    }
                    if (startDate != null) {
                        startDateStr = DateUtil.getDateFormat((Date)startDate);
                    }
                    if (endDate != null) {
                        endDateStr = DateUtil.getDateFormat((Date)endDate);
                    }
                    distributeResVo.setValidPeriodType(validPeriodType);
                    distributeResVo.setValidityDays(Integer.valueOf(validityDays));
                    distributeResVo.setStartDate(startDateStr);
                    distributeResVo.setEndDate(endDateStr);
                }
                distributeResList.add(distributeResVo);
            }
            return TicketInfoServiceResult.success(distributeResList);
        }
        catch (Throwable e) {
            return TicketInfoServiceResult.fail((String)e.getMessage());
        }
    }

    private String querydistributeDynSelectFields() {
        return ORMUtil.appendFieldsToStr((String[])new String[]{"id", "number", "ticketvalue", "saleamount", "ticketstyle", "minconsumeamount", "condition", "discountrate", "usagemode", "validperiodtype", "validitydays", "startdate", "enddate", "startdate", "startdate", "name"});
    }

    public JSONObject queryDetailFromOnLineStore(JSONObject jsonParam) {
        try {
            Date endDate;
            Date startDate;
            int validityDays;
            TicketDistributeParamVo distributeParamVo = (TicketDistributeParamVo)JSONObject.toJavaObject((JSON)jsonParam, TicketDistributeParamVo.class);
            DynamicObject distributeDyn = TicketDistributeHelper.queryDetail((TicketDistributeParamVo)distributeParamVo);
            long vipID = distributeParamVo.getVipId();
            TicketDistributeResVO distributeResVo = new TicketDistributeResVO();
            String distributeNumber = distributeDyn.getString("number");
            QFilter filter = new QFilter("billno", "=", (Object)distributeNumber);
            DynamicObject[] totalDistributeActionFlowArr = BusinessDataServiceHelper.load((String)"ocgcm_ticketactionflow", (String)"id", (QFilter[])filter.toArray());
            filter.and("vipid", "=", (Object)vipID);
            DynamicObject[] vipDistributeActionFlowArr = BusinessDataServiceHelper.load((String)"ocgcm_ticketactionflow", (String)"id", (QFilter[])filter.toArray());
            distributeResVo.setVipId(Long.valueOf(vipID));
            distributeResVo.setVipGetMaxQty(Integer.valueOf(distributeDyn.getInt("vipgetmaxqty")));
            distributeResVo.setVipHasReceiveQty(Integer.valueOf(vipDistributeActionFlowArr.length));
            distributeResVo.setTotalQty(Integer.valueOf(distributeDyn.getInt("totalqty")));
            distributeResVo.setHasDistributeTotalQty(Integer.valueOf(totalDistributeActionFlowArr.length));
            distributeResVo.setSchemeID((Long)distributeDyn.getPkValue());
            distributeResVo.setSchemeNumber(distributeDyn.getString("number"));
            distributeResVo.setSchemeName(distributeDyn.getString("name"));
            long ticketTypeId = DynamicObjectUtils.getPkValue((DynamicObject)distributeDyn, (String)"tickettypeid");
            DynamicObject ticketTypeDyn = BusinessDataServiceHelper.loadSingle((Object)ticketTypeId, (String)"ocdbd_ticketstype");
            distributeResVo.setTicketTypeID(Long.valueOf(ticketTypeId));
            distributeResVo.setTicketTypeNumber(ticketTypeDyn.getString("number"));
            distributeResVo.setTicketValue(ticketTypeDyn.getBigDecimal("ticketvalue"));
            distributeResVo.setSaleAmount(ticketTypeDyn.getBigDecimal("saleamount"));
            distributeResVo.setTicketStyle(ticketTypeDyn.getString("ticketstyle"));
            distributeResVo.setTicketName(ticketTypeDyn.getString("name"));
            distributeResVo.setMinConsumeAmount(ticketTypeDyn.getBigDecimal("minconsumeamount"));
            distributeResVo.setCondition(TicketConditionEnum.getValue((String)ticketTypeDyn.getString("condition")));
            distributeResVo.setDiscountrate(ticketTypeDyn.getBigDecimal("discountrate"));
            distributeResVo.setUsagemode(ticketTypeDyn.getString("usagemode"));
            distributeResVo.setTicketApplyTerminal(TicketApplyTerminalEnum.getValue((String)ticketTypeDyn.getString("ticketapplyterminal")));
            String startDateStr = "";
            String endDateStr = "";
            String validPeriodType = DynamicObjectUtils.getString((DynamicObject)distributeDyn, (String)"validperiodtype");
            if (StringUtils.isEmpty((Object)validPeriodType)) {
                validPeriodType = DynamicObjectUtils.getString((DynamicObject)ticketTypeDyn, (String)"validperiodtype");
                validityDays = DynamicObjectUtils.getInt((DynamicObject)ticketTypeDyn, (String)"validitydays");
                if ("A".equals(validPeriodType)) {
                    Date dtNow;
                    startDate = dtNow = TimeServiceHelper.now();
                    endDate = DateUtil.dayAdd((Date)dtNow, (int)validityDays);
                } else {
                    startDate = DynamicObjectUtils.getDate((DynamicObject)ticketTypeDyn, (String)"startdate");
                    endDate = DynamicObjectUtils.getDate((DynamicObject)ticketTypeDyn, (String)"enddate");
                }
            } else {
                validityDays = DynamicObjectUtils.getInt((DynamicObject)distributeDyn, (String)"relativedays");
                if ("A".equals(validPeriodType)) {
                    Date dtNow;
                    startDate = dtNow = TimeServiceHelper.now();
                    endDate = DateUtil.dayAdd((Date)dtNow, (int)validityDays);
                } else {
                    startDate = DynamicObjectUtils.getDate((DynamicObject)distributeDyn, (String)"startdate");
                    endDate = DynamicObjectUtils.getDate((DynamicObject)distributeDyn, (String)"enddate");
                }
            }
            if (startDate != null) {
                startDateStr = DateUtil.getDateFormat((Date)startDate);
            }
            if (endDate != null) {
                endDateStr = DateUtil.getDateFormat((Date)endDate);
            }
            distributeResVo.setValidPeriodType(validPeriodType);
            distributeResVo.setValidityDays(Integer.valueOf(validityDays));
            distributeResVo.setStartDate(startDateStr);
            distributeResVo.setEndDate(endDateStr);
            return TicketInfoServiceResult.success((Object)distributeResVo);
        }
        catch (Throwable e) {
            return TicketInfoServiceResult.fail((String)e.getMessage());
        }
    }
}

