/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.mservice.tickettype;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.enums.ActivityTypeEnum;
import kd.occ.ocbase.common.enums.ticket.TicketCategoryEnum;
import kd.occ.ocbase.common.enums.ticket.TicketMediumEnum;
import kd.occ.ocbase.common.enums.ticket.TicketUsageModeEnum;
import kd.occ.ocbase.common.pojo.TicketParamVO;
import kd.occ.ocbase.common.pojo.TicketTypeParamVO;
import kd.occ.ocdbd.business.helper.ticket.TicketTypeHelper;
import kd.occ.ocgcm.meservice.api.tickettype.ITicketTypeService;

public class TicketTypeServiceImpl
implements ITicketTypeService {
    public DynamicObject[] queryFromOnlineInvitation(JSONObject jsonParam) {
        try {
            TicketTypeParamVO ticketTypeParamVo = (TicketTypeParamVO)JSONObject.toJavaObject((JSON)jsonParam, TicketTypeParamVO.class);
            DynamicObject[] ticketTypeDynColl = TicketTypeHelper.queryList((TicketParamVO)ticketTypeParamVo, (QFilter)TicketTypeServiceImpl.buildFilter(ticketTypeParamVo));
            return ticketTypeDynColl;
        }
        catch (Throwable e) {
            return (DynamicObject[])new DynamicObjectCollection().toArray();
        }
    }

    private static QFilter buildFilter(TicketTypeParamVO ticketTypeParamVo) {
        QFilter filter = new QFilter("isonlineinvitation", "=", (Object)Boolean.TRUE);
        filter.and("medium", "=", (Object)TicketMediumEnum.ELECTRONIC.getName());
        filter.and("category", "=", (Object)TicketCategoryEnum.SELL.getName());
        String invitationType = ticketTypeParamVo.getInvitationType();
        if (ActivityTypeEnum.CASHTICKET.getValue().equals(invitationType)) {
            filter.and("usagemode", "=", (Object)TicketUsageModeEnum.CASH.getName());
        } else if (ActivityTypeEnum.GIFTTICKET.getValue().equals(invitationType)) {
            filter.and("usagemode", "=", (Object)TicketUsageModeEnum.ITEM_CONVERT.getName());
        } else if (ActivityTypeEnum.CASHTICKETORASSIGNGIFT.getValue().equals(invitationType)) {
            filter.and("usagemode", "=", (Object)TicketUsageModeEnum.CASH.getName());
        } else if (ActivityTypeEnum.CASHORGIFTTICKET.getValue().equals(invitationType)) {
            filter.and("usagemode", "=", (Object)TicketUsageModeEnum.CASH.getName());
            filter.or("usagemode", "=", (Object)TicketUsageModeEnum.ITEM_CONVERT.getName());
        }
        return filter;
    }
}

