/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.opplugin.ticketpublish;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.OperationException;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.occ.ocbase.common.enums.OptionDirectEnum;
import kd.occ.ocbase.common.enums.TicketFlowOperTypeEnum;
import kd.occ.ocbase.common.pojo.TicketFlowParamVO;
import kd.occ.ocdbd.business.helper.TicketActionFlowHelper;
import kd.occ.ocdbd.business.helper.ticket.TicketsInfoHelper;

public class TicketPublishAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("paymodeentry");
        e.getFieldKeys().add("realsaleamount");
        e.getFieldKeys().add("realamount");
        e.getFieldKeys().add("payamount");
        e.getFieldKeys().add("ticketid");
        e.getFieldKeys().add("amount");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        HashSet<Long> billIds = new HashSet<Long>(bills.length);
        HashSet<Long> billTicketsIds = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            billIds.add((Long)bill.getPkValue());
            DynamicObjectCollection dynColl = bill.getDynamicObjectCollection("entryentity");
            if (dynColl == null || dynColl.size() < 1) continue;
            for (DynamicObject ticket : dynColl) {
                billTicketsIds.add(ticket.getLong("ticketid_id"));
            }
        }
        try (TXHandle tx = TX.required((String)"ocdbd_ticketinfo");){
            try {
                List infoVOS = TicketsInfoHelper.updateTicketsInfo(new ArrayList(billIds), (String)"ocgcm_ticketspublish", null);
                TicketFlowParamVO ticketFlowParamVO = new TicketFlowParamVO();
                ticketFlowParamVO.setBillIdList(new ArrayList(billTicketsIds));
                ticketFlowParamVO.setOption(OptionDirectEnum.OPTIONDIRECT_RIGHT);
                ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_SEND);
                ticketFlowParamVO.setBillFormId("ocgcm_ticketspublish");
                TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
            }
            catch (OperationException exec) {
                tx.markRollback();
                throw exec;
            }
        }
    }
}

