/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.opplugin.ticketrecovery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.occ.ocbase.common.enums.OptionDirectEnum;
import kd.occ.ocbase.common.enums.TicketFlowOperTypeEnum;
import kd.occ.ocbase.common.pojo.TicketFlowParamVO;
import kd.occ.ocdbd.business.helper.TicketActionFlowHelper;
import kd.occ.ocdbd.business.helper.ticket.TicketsInfoHelper;
import kd.occ.ocgcm.opplugin.ticketrecovery.TicketRecoveryAuditValidator;

public class TicketRecoveryAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("returnamount");
        e.getFieldKeys().add("ticrreturnentry");
        e.getFieldKeys().add("retamount");
        e.getFieldKeys().add("realretamount");
        e.getFieldKeys().add("retdeductionamt");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("ticketid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TicketRecoveryAuditValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        HashSet<Long> billIds = new HashSet<Long>(bills.length);
        HashSet<Long> billTicketsIds = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            long billId = (Long)bill.getPkValue();
            billIds.add(billId);
            DynamicObjectCollection dynColl = bill.getDynamicObjectCollection("entryentity");
            if (dynColl == null || dynColl.size() < 1) continue;
            for (DynamicObject ticket : dynColl) {
                billTicketsIds.add(ticket.getLong("ticketid_id"));
            }
        }
        List infoVOS = TicketsInfoHelper.updateTicketsInfo(new ArrayList(billIds), (String)"ocgcm_ticketsreturn", null);
        TicketFlowParamVO ticketFlowParamVO = new TicketFlowParamVO();
        ticketFlowParamVO.setBillIdList(new ArrayList(billTicketsIds));
        ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_RECOVERY);
        ticketFlowParamVO.setOption(OptionDirectEnum.OPTIONDIRECT_RIGHT);
        ticketFlowParamVO.setBillFormId("ocgcm_ticketsreturn");
        TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
    }
}

