/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.opplugin.ticketrecovery;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.business.payhelper.FinPayTradeHelper;
import kd.occ.ocbase.business.payhelper.PayTradeHelper;
import kd.occ.ocbase.business.payhelper.PaymentFlowHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.pay.config.RefundInfo;
import kd.occ.ocbase.common.pay.config.RefundResult;
import kd.occ.ocbase.common.pay.config.TradeStatus;
import kd.occ.ocbase.common.pay.finpay.util.ResponseEnum;

public class TicketRecoveryRefundOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TicketRecoveryRefundOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("returnamount");
        e.getFieldKeys().add("ticrreturnentry");
        e.getFieldKeys().add("retamount");
        e.getFieldKeys().add("realretamount");
        e.getFieldKeys().add("branchid");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("outorderno");
        e.getFieldKeys().add("refundtime");
        e.getFieldKeys().add("salestatus");
        e.getFieldKeys().add("refundor");
        e.getFieldKeys().add("refundor_id");
        e.getFieldKeys().add("tradereference");
        e.getFieldKeys().add("paytime");
        e.getFieldKeys().add("localcrypayamount");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("publishbillno");
        e.getFieldKeys().add("billno");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        int i = 0;
        while (true) {
            block5: {
                long payWay;
                BigDecimal refundAmount;
                String outOrderNumber;
                String tradeReferenceNo;
                long storeId;
                long billId;
                block8: {
                    StringBuilder errorMessage;
                    block9: {
                        JSONObject refundResponse;
                        block12: {
                            DynamicObject bill;
                            block10: {
                                JSONObject tradeQuery;
                                block11: {
                                    RefundInfo refundInfo;
                                    block6: {
                                        RefundResult refundData;
                                        block7: {
                                            DynamicObjectCollection dynamicObjectCollection;
                                            block4: {
                                                if (i >= bills.length) {
                                                    return;
                                                }
                                                bill = bills[i];
                                                billId = (Long)bill.getPkValue();
                                                refundInfo = new RefundInfo();
                                                refundInfo.setBillNo(bill.getString("billno"));
                                                refundInfo.setOperaTime(new Date());
                                                storeId = bill.getLong("branchid.id");
                                                refundInfo.setStoreId(storeId);
                                                errorMessage = new StringBuilder();
                                                dynamicObjectCollection = bill.getDynamicObjectCollection("ticrreturnentry");
                                                if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) break block4;
                                                errorMessage.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u9000\u6b3e\u5931\u8d25, \u9000\u6b3e\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"TicketRecoveryRefundOp_4", (String)"occ-ocgcm-opplugin", (Object[])new Object[0]), i + 1));
                                                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)billId, i + 1, 0, "errorCode_4", "", errorMessage.toString(), ErrorLevel.Warning);
                                                this.getOperationResult().addErrorInfo((OperateErrorInfo)info);
                                                break block5;
                                            }
                                            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
                                            tradeReferenceNo = "";
                                            outOrderNumber = dynamicObject.getString("outorderno");
                                            refundAmount = bill.getBigDecimal("amount");
                                            payWay = PayTradeHelper.getOlStorePayWay((long)storeId);
                                            if (PaymentModeEnum.getKey((String)"wechatpayment") != payWay) break block6;
                                            refundData = PayTradeHelper.getRefundData((RefundInfo)refundInfo, (long)PaymentModeEnum.getKey((String)"wechatpayment"), (String)tradeReferenceNo, (String)outOrderNumber, (BigDecimal)refundAmount);
                                            if (!TradeStatus.SUCCESS.equals((Object)refundData.getTradeStatus())) break block7;
                                            tradeReferenceNo = refundData.getRefundResponse().getString("transaction_id");
                                            this.updatePublishAndReturnBillInfo(bill, refundAmount, tradeReferenceNo);
                                            break block8;
                                        }
                                        errorMessage.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u9000\u6b3e\u5931\u8d25, \u539f\u56e0:", (String)"TicketRecoveryRefundOp_0", (String)"occ-ocgcm-opplugin", (Object[])new Object[0]), i + 1)).append(refundData.getErrorMessage());
                                        ValidationErrorInfo info = new ValidationErrorInfo("", (Object)billId, i + 1, 0, "errorCode_0", "", errorMessage.toString(), ErrorLevel.Warning);
                                        this.getOperationResult().addErrorInfo((OperateErrorInfo)info);
                                        break block5;
                                    }
                                    if (PaymentModeEnum.getKey((String)"kingdeefinancepay") != payWay) break block9;
                                    refundInfo.setOutTradeNo(outOrderNumber);
                                    RefundResult refundResult = FinPayTradeHelper.kingDeeRefund((RefundInfo)refundInfo, (BigDecimal)refundAmount.abs());
                                    logger.info("\u8ba4\u7b79\u9080\u7ea6\u9000\u6b3erefundResult :" + JSON.toJSONString((Object)refundResult));
                                    TradeStatus tradestatus = refundResult.getTradeStatus();
                                    if (!TradeStatus.SUCCESS.equals((Object)tradestatus)) break block8;
                                    refundResponse = refundResult.getRefundResponse();
                                    tradeReferenceNo = refundResponse.getString("oriPayOrgTransNo");
                                    if (StringUtils.isEmpty((CharSequence)tradeReferenceNo)) {
                                        tradeReferenceNo = refundResponse.getString("thirdNo");
                                    }
                                    logger.info("\u8ba4\u7b79\u9080\u7ea6\u9000\u6b3erefundResponse :" + JSON.toJSONString((Object)refundResponse));
                                    if (!ResponseEnum.TRADE_PROCESSING.getCode().equals(refundResponse.getString("bizCode"))) break block10;
                                    String tradeNo = refundResponse.getString("bizNo");
                                    tradeQuery = FinPayTradeHelper.loopQueryResult((String)tradeNo, (String)"12", (long)refundInfo.getStoreId());
                                    logger.info("\u8ba4\u7b79\u9080\u7ea6\u9000\u6b3e\u67e5\u8be2tradeQuery :" + JSON.toJSONString((Object)tradeQuery) + tradeNo);
                                    if (!ResponseEnum.TRADE_SUCCESS.getCode().equals(tradeQuery.getString("bizCode"))) break block11;
                                    if (StringUtils.isEmpty((CharSequence)tradeReferenceNo)) {
                                        tradeReferenceNo = refundResponse.getString("outNo");
                                    }
                                    this.updatePublishAndReturnBillInfo(bill, refundAmount, tradeReferenceNo);
                                    break block8;
                                }
                                errorMessage.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u9000\u6b3e\u5931\u8d25, \u539f\u56e0:", (String)"TicketRecoveryRefundOp_1", (String)"occ-ocgcm-opplugin", (Object[])new Object[0]), i + 1)).append(tradeQuery.get((Object)"bizMsg")).append(tradeQuery.get((Object)"tunnelRespMsg"));
                                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)billId, i + 1, 0, "errorCode_1", "", errorMessage.toString(), ErrorLevel.Warning);
                                this.getOperationResult().addErrorInfo((OperateErrorInfo)info);
                                break block5;
                            }
                            if (!ResponseEnum.TRADE_SUCCESS.getCode().equals(refundResponse.getString("bizCode"))) break block12;
                            this.updatePublishAndReturnBillInfo(bill, refundAmount, tradeReferenceNo);
                            break block8;
                        }
                        errorMessage.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u9000\u6b3e\u5931\u8d25, \u539f\u56e0:", (String)"TicketRecoveryRefundOp_2", (String)"occ-ocgcm-opplugin", (Object[])new Object[0]), i + 1)).append(refundResponse.get((Object)"bizMsg")).append(refundResponse.get((Object)"tunnelRespMsg"));
                        ValidationErrorInfo info = new ValidationErrorInfo("", (Object)billId, i + 1, 0, "errorCode_2", "", errorMessage.toString(), ErrorLevel.Warning);
                        this.getOperationResult().addErrorInfo((OperateErrorInfo)info);
                        break block5;
                    }
                    errorMessage.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u9000\u6b3e\u5931\u8d25, \u7ebf\u4e0a\u652f\u4ed8\u5f53\u524d\u4ec5\u652f\u6301\u5fae\u4fe1\u652f\u4ed8\u6216\u91d1\u8776\u91d1\u878d\u652f\u4ed8\uff0c\u4e14\u9700\u52fe\u9009'\u9002\u7528\u7ebf\u4e0a\u652f\u4ed8'\uff0c\u8bf7\u524d\u5f80\u540e\u53f0\u914d\u7f6e\u3002", (String)"TicketRecoveryRefundOp_3", (String)"occ-ocgcm-opplugin", (Object[])new Object[0]), i + 1));
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)billId, i + 1, 0, "errorCode_3", "", errorMessage.toString(), ErrorLevel.Warning);
                    this.getOperationResult().addErrorInfo((OperateErrorInfo)info);
                    break block5;
                }
                PaymentFlowHelper.afterPayTicketSuccess((Object)billId, (BigDecimal)refundAmount, (String)outOrderNumber, (String)tradeReferenceNo, (long)storeId, (long)payWay);
            }
            ++i;
        }
    }

    private void updatePublishAndReturnBillInfo(DynamicObject bill, BigDecimal refundAmount, String tradeReferenceNo) {
        Date payTime = TimeServiceHelper.now();
        bill.set("salestatus", (Object)"S");
        bill.set("refundtime", (Object)payTime);
        bill.set("refundor", (Object)UserServiceHelper.getCurrentUserId());
        bill.set("refundor_id", (Object)UserServiceHelper.getCurrentUserId());
        bill.set("realretamount", (Object)refundAmount);
        DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("ticrreturnentry");
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
        dynamicObject.set("tradereference", (Object)tradeReferenceNo);
        dynamicObject.set("paytime", (Object)payTime);
        dynamicObject.set("retamount", (Object)refundAmount);
        dynamicObject.set("localcrypayamount", (Object)refundAmount);
        dynamicObject.set("exchangerate", (Object)1);
        SaveServiceHelper.update((DynamicObject)bill);
        String publishBillNo = bill.getString("publishbillno");
        QFilter qFilter = new QFilter("billno", "=", (Object)publishBillNo);
        DynamicObject ticketOrder = BusinessDataServiceHelper.loadSingle((String)"ocgcm_ticketspublish", (String)"id,isrefund", (QFilter[])qFilter.toArray());
        ticketOrder.set("isrefund", (Object)"1");
        SaveServiceHelper.update((DynamicObject)ticketOrder);
    }
}

