/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.opplugin.ticketrecovery;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class TicketRecoverySubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            BigDecimal returnAmt = BigDecimal.ZERO;
            BigDecimal payAmt = BigDecimal.ZERO;
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject dyn = dataEntity.getDataEntity();
                DynamicObjectCollection ticketCollection = dyn.getDynamicObjectCollection("entryentity");
                if (ticketCollection == null || ticketCollection.size() < 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u793c\u5238\u4fe1\u606f\u680f\u9009\u62e9\u672c\u6b21\u56de\u6536\u7684\u793c\u5238", (String)"TicketRecoverySubmitValidator_0", (String)"occ-ocgcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject ticketEntry : ticketCollection) {
                    if (ticketEntry.getBigDecimal("returnamount") == null) continue;
                    returnAmt = returnAmt.add(ticketEntry.getBigDecimal("returnamount"));
                }
                DynamicObjectCollection returnDynColl = dyn.getDynamicObjectCollection("ticrreturnentry");
                BigDecimal amount = dyn.getBigDecimal("amount");
                if (returnDynColl.size() <= 0 && amount != null && BigDecimal.ZERO.compareTo(amount) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u9000\u6b3e\u4fe1\u606f\u680f\u8f93\u5165\u9000\u6b3e\u4fe1\u606f", (String)"TicketRecoverySubmitValidator_2", (String)"occ-ocgcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject payEntry : returnDynColl) {
                    if (payEntry.getBigDecimal("retamount") == null) continue;
                    payAmt = payAmt.add(payEntry.getBigDecimal("retamount"));
                }
            }
        }
    }
}

