/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocgcm.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.payhelper.PaymentFlowHelper;
import kd.occ.ocbase.common.pay.payment.vo.PaymentRecord;

public class TicketPayHelper {
    public static void afterPayTicketSuccess(DynamicObject dataEntity, List<JSONObject> paramsList, String payoption) {
        Date paytime = TimeServiceHelper.now();
        if (!CollectionUtils.isEmpty(paramsList)) {
            for (JSONObject params : paramsList) {
                PaymentRecord payRecord = new PaymentRecord();
                payRecord.setBillId(((Long)dataEntity.getPkValue()).longValue());
                payRecord.setBillNo(dataEntity.getString("billno"));
                if (params.containsKey((Object)"orderNo")) {
                    payRecord.setOrderNo(params.getString("orderNo"));
                }
                if (params.containsKey((Object)"bankExchangeNo")) {
                    payRecord.setBankExchangeNo(params.getString("bankExchangeNo"));
                }
                if (params.containsKey((Object)"payWay")) {
                    DynamicObject payWay = (DynamicObject)params.getObject("payWay", DynamicObject.class);
                    payRecord.setPayWay(payWay);
                }
                if (params.containsKey((Object)"amount")) {
                    BigDecimal payAmount = params.getBigDecimal("amount");
                    payRecord.setAmount(payAmount);
                }
                if (params.containsKey((Object)"cardNo")) {
                    payRecord.setCardNo(params.getString("cardNo"));
                }
                DynamicObject payCurrency = dataEntity.getDynamicObject("settlecurrencyid");
                payRecord.setPayCurrency(payCurrency);
                payRecord.setPaytime(paytime);
                payRecord.setPayStatus("A");
                if (payoption.equalsIgnoreCase("1")) {
                    TicketPayHelper.updateSaleOrderAfterPayment(dataEntity, payRecord, null);
                    continue;
                }
                TicketPayHelper.updateSaleOrderAfterRefund(dataEntity, payRecord);
            }
        }
    }

    public static void updateSaleOrderAfterPayment(DynamicObject dataEntity, PaymentRecord paymentRecord, Map<String, Object> data) {
        PaymentFlowHelper.saveAllPaymentFlow((PaymentRecord)paymentRecord, (String)"1", data);
        DynamicObjectCollection finEntryEntity = dataEntity.getDynamicObjectCollection("paymodeentry");
        DynamicObject finentity = finEntryEntity.addNew();
        finentity.set("paymodeid", (Object)paymentRecord.getPayWay());
        finentity.set("paywaytypeid", (Object)paymentRecord.getPayWayType());
        finentity.set("paycurrencyid", (Object)paymentRecord.getPayCurrency());
        finentity.set("payamount", (Object)paymentRecord.getAmount());
        finentity.set("localcrypayamount", (Object)paymentRecord.getAmount());
        finentity.set("outorderno", (Object)paymentRecord.getOrderNo());
        finentity.set("tradereference", (Object)paymentRecord.getBankExchangeNo());
        finentity.set("bankaccount", (Object)paymentRecord.getBankNo());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    public static void updateSaleOrderAfterRefund(DynamicObject dataEntity, PaymentRecord paymentRecord) {
        PaymentFlowHelper.saveAllPaymentFlow((PaymentRecord)paymentRecord, (String)"0", null);
        DynamicObjectCollection finEntryEntity = dataEntity.getDynamicObjectCollection("ticrreturnentry");
        DynamicObject finentity = finEntryEntity.addNew();
        finentity.set("retmodeid", (Object)paymentRecord.getPayWay());
        finentity.set("paywaytypeid", (Object)paymentRecord.getPayWayType());
        finentity.set("retcurrencyid", (Object)paymentRecord.getPayCurrency());
        finentity.set("retamount", (Object)paymentRecord.getAmount());
        finentity.set("localcrypayamount", (Object)paymentRecord.getAmount());
    }
}

