/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.opplugin.babill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.entity.BudgetCosts;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.opplugin.base.OcBaseOperationServicePlugIn;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsUpdateHelper;

public class BudgetAdjustBillUnSubmitOp
extends OcBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("bizdate");
        fieldKeys.add("budgetyear");
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "budgetbalance"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "adjustamount"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "entryorg"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "feetype"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "channel"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "currency"));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] billArray = e.getDataEntities();
        ArrayList<BudgetCosts> budgetCostsList = new ArrayList<BudgetCosts>(billArray.length * 10);
        for (DynamicObject bill : billArray) {
            for (DynamicObject entry : bill.getDynamicObjectCollection("entryentity")) {
                BigDecimal adjustAmount = entry.getBigDecimal("adjustamount");
                if (adjustAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                BudgetCosts budgetCosts = new BudgetCosts();
                budgetCosts.setSourceBill("ocmem_budgetadjustbill");
                budgetCosts.setSourceBillNo(bill.getString("billno"));
                budgetCosts.setId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"budgetbalance"));
                budgetCosts.setOrgId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"entryorg"));
                budgetCosts.setFeeTypeId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"feetype"));
                budgetCosts.setChannelId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"channel"));
                budgetCosts.setCurrencyId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"currency"));
                budgetCosts.setChannelId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"channel"));
                budgetCosts.setDateTime(bill.getDate("bizdate"));
                budgetCosts.setAvailableAmount(adjustAmount.negate());
                budgetCosts.setBudgetYearId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"budgetyear"));
                budgetCostsList.add(budgetCosts);
            }
        }
        if (!CollectionUtils.isEmpty(budgetCostsList)) {
            BudgetCostsUpdateHelper.updateBudgetCosts(budgetCostsList);
        }
    }
}

