/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.opplugin.babill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.validator.BatchFastValidator;

public class BudgetAdjustBillValidator
extends BatchFastValidator {
    private static final String EF_BUDGETBALANCE = String.join((CharSequence)".", "entryentity", "budgetbalance");

    public void save(ExtendedDataEntity[] datas) {
        super.save(datas);
        this.verifyBudgetBalance(datas);
    }

    public void submit(ExtendedDataEntity[] datas) {
        super.submit(datas);
        this.verifyBudgetBalance(datas);
    }

    private void verifyBudgetBalance(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            long billId = bill.getLong("id");
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
            Set<Long> budgetBalanceIdSet = entries.stream().filter(dynObj -> dynObj.getBigDecimal("adjustamount").compareTo(BigDecimal.ZERO) < 0).map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"budgetbalance")).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(budgetBalanceIdSet = this.queryUnauditBillBudgetBalanceIdSet(billId, budgetBalanceIdSet))) continue;
            for (DynamicObject entry : entries) {
                DynamicObject budgetBalance = entry.getDynamicObject("budgetbalance");
                if (!budgetBalanceIdSet.contains(budgetBalance.getLong("id"))) continue;
                this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u7f16\u7801(%1$s)\u5b58\u5728\u5728\u9014\u8c03\u6574\u6d41\u7a0b\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8c03\u6574\u3002", (String)"BudgetAdjustBillValidator_0", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), budgetBalance.getString("number")));
            }
        }
    }

    private Set<Long> queryUnauditBillBudgetBalanceIdSet(long billId, Set<Long> budgetBalanceIdSet) {
        if (!CollectionUtils.isEmpty(budgetBalanceIdSet)) {
            QFilter budgetCostQFilter = null;
            for (Long budgetCostId : budgetBalanceIdSet) {
                if (budgetCostQFilter == null) {
                    budgetCostQFilter = new QFilter(EF_BUDGETBALANCE, "=", (Object)budgetCostId);
                    continue;
                }
                budgetCostQFilter = budgetCostQFilter.or(EF_BUDGETBALANCE, "=", (Object)budgetCostId);
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
            if (billId > 0L) {
                filters.add(new QFilter("id", "!=", (Object)billId));
            }
            filters.add(new QFilter("billstatus", "!=", (Object)Status.AUDITED.toString()));
            filters.add(budgetCostQFilter);
            return QueryServiceHelper.query((String)"ocmem_budgetadjustbill", (String)EF_BUDGETBALANCE, (QFilter[])((QFilter[])filters.stream().toArray(QFilter[]::new))).stream().map(r -> r.getLong(EF_BUDGETBALANCE)).collect(Collectors.toSet());
        }
        return new HashSet<Long>(0);
    }
}

