/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.opplugin.budgettransfer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.validator.BatchFastValidator;

public class BudgetTransferValidator
extends BatchFastValidator {
    private static final String ENTRYENTITY_INBUDGETBALANCE = StringUtils.join((CharSequence)".", (Object[])new Object[]{"entryentity", "inbudgetbalance"});
    private static final String ENTRYENTITY_OUTBUDGETBALANCE = StringUtils.join((CharSequence)".", (Object[])new Object[]{"entryentity", "outbudgetbalance"});
    private static final String QUERYCOLS = StringUtils.join((CharSequence)",", (Object[])new Object[]{"billno", StringUtils.join((CharSequence)".", (Object[])new Object[]{"entryentity", "inbudgetbalance"}), StringUtils.join((CharSequence)".", (Object[])new Object[]{"entryentity", "outbudgetbalance"})});

    public void save(ExtendedDataEntity[] datas) {
        super.save(datas);
        this.verifyBudgetTransferBills(datas);
    }

    public void submit(ExtendedDataEntity[] datas) {
        super.submit(datas);
        this.verifyBudgetTransferBills(datas);
    }

    private void verifyBudgetTransferBills(ExtendedDataEntity[] datas) {
        ArrayList<Long> outBudgetBalanceIdList = new ArrayList<Long>(datas.length);
        ArrayList<Long> inBudgetBalanceIdList = new ArrayList<Long>(datas.length);
        this.checkSaveBillInfoOnly(datas, inBudgetBalanceIdList, outBudgetBalanceIdList);
        this.checkEntryInUnfinishedBill(datas, inBudgetBalanceIdList, outBudgetBalanceIdList);
    }

    private void checkEntryInUnfinishedBill(ExtendedDataEntity[] datas, List<Long> inBudgetBalanceIdList, List<Long> outBudgetBalanceIdList) {
        Map<String, List<String>> billNumberMap = this.getEntryLinkOtherBillInfoMap(inBudgetBalanceIdList, outBudgetBalanceIdList);
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                List existBillNoList;
                int rowIndex = entry.getInt("seq");
                String key = StringUtils.join((CharSequence)"_", (Object[])new Object[]{DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("inbudgetbalance"), (String)"id"), DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("outbudgetbalance"), (String)"id")});
                List<String> existBillNos = billNumberMap.get(key);
                if (!CollectionUtil.isNotNull(existBillNos) || existBillNos.size() < 2 || !CollectionUtil.isNotNull(existBillNoList = existBillNos.stream().filter(a -> !bill.getString("billno").equalsIgnoreCase((String)a)).collect(Collectors.toList()))) continue;
                this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8f6c\u51fa\u9884\u7b97\u7f16\u7801\u4e0e\u8f6c\u5165\u9884\u7b97\u7f16\u7801\u5728\u5355\u636e\u7f16\u7801\u4e3a%2$s\u4e2d\u5b58\u5728\u91cd\u590d\u503c\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"BudgetTransferValidator_2", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), rowIndex, existBillNoList.get(0)));
            }
        }
    }

    private Map<String, List<String>> getEntryLinkOtherBillInfoMap(List<Long> inBudgetBalanceIdList, List<Long> outBudgetBalanceIdList) {
        if (CollectionUtil.isNotNull(inBudgetBalanceIdList) && CollectionUtil.isNotNull(outBudgetBalanceIdList)) {
            HashMap<String, List<String>> billNumberMap = new HashMap<String, List<String>>(inBudgetBalanceIdList.size());
            QFilter filters = new QFilter("billstatus", "!=", (Object)Character.valueOf('C'));
            filters.and(ENTRYENTITY_INBUDGETBALANCE, "in", inBudgetBalanceIdList);
            filters.and(ENTRYENTITY_OUTBUDGETBALANCE, "in", outBudgetBalanceIdList);
            DynamicObjectCollection existBilList = QueryServiceHelper.query((String)"ocmem_budgettransfer", (String)QUERYCOLS, (QFilter[])filters.toArray());
            for (DynamicObject existObj : existBilList) {
                String existkey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{existObj.getLong(ENTRYENTITY_INBUDGETBALANCE), existObj.getLong(ENTRYENTITY_OUTBUDGETBALANCE)});
                ArrayList<String> billNoList = (ArrayList<String>)billNumberMap.get(existkey);
                if (CollectionUtil.isNull((List)billNoList)) {
                    billNoList = new ArrayList<String>(1);
                }
                if (!billNoList.contains(existkey)) {
                    billNoList.add(existObj.getString("billno"));
                }
                billNumberMap.put(existkey, billNoList);
            }
            return billNumberMap;
        }
        return new HashMap<String, List<String>>(0);
    }

    private void checkSaveBillInfoOnly(ExtendedDataEntity[] datas, List<Long> inBudgetBalanceIdList, List<Long> outBudgetBalanceIdList) {
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
            int size = entries.size();
            ArrayList<String> budgetNumberList = new ArrayList<String>(size);
            for (DynamicObject entry : entries) {
                int rowIndex = entry.getInt("seq");
                String key = StringUtils.join((CharSequence)"_", (Object[])new Object[]{DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("outbudgetbalance"), (String)"id"), DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("inbudgetbalance"), (String)"id")});
                if (budgetNumberList.contains(key)) {
                    this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8f6c\u51fa\u9884\u7b97\u7f16\u7801\u4e0e\u8f6c\u5165\u9884\u7b97\u7f16\u7801\u5728\u672c\u5355\u636e\u5206\u5f55\u4e2d\u5b58\u5728\u91cd\u590d\u503c\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"BudgetTransferValidator_3", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), rowIndex));
                } else {
                    inBudgetBalanceIdList.add(DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("inbudgetbalance")));
                    outBudgetBalanceIdList.add(DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("outbudgetbalance")));
                }
                budgetNumberList.add(key);
                String control = DynamicObjectUtils.getString((DynamicObject)entry.getDynamicObject("outexpensetype"), (String)"control");
                DynamicObject channel = entry.getDynamicObject("outchannel");
                if (control.contains("2") && channel == null) {
                    this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8f6c\u51fa\u8d39\u7528\u7c7b\u578b\u7684\u63a7\u5236\u7c92\u5ea6\u5305\u542b\u4e86\u6e20\u9053\uff0c\u8bf7\u586b\u5199\u8f6c\u51fa\u6e20\u9053\u3002", (String)"BudgetTransferValidator_0", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), rowIndex));
                }
                control = DynamicObjectUtils.getString((DynamicObject)entry.getDynamicObject("inexpensetype"), (String)"control");
                channel = entry.getDynamicObject("inchannel");
                if (!control.contains("2") || channel != null) continue;
                this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8f6c\u5165\u8d39\u7528\u7c7b\u578b\u7684\u63a7\u5236\u7c92\u5ea6\u5305\u542b\u4e86\u6e20\u9053\uff0c\u8bf7\u586b\u5199\u8f6c\u5165\u6e20\u9053\u3002", (String)"BudgetTransferValidator_1", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), rowIndex));
            }
        }
    }
}

