/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.opplugin.cost.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.opplugin.base.OcBaseOperationServicePlugIn;

public class MarketCostApplyFiexedJoinQtyOp
extends OcBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "verifiedqty"));
        fieldKeys.add(String.join((CharSequence)".", "entryentity", "joinqty"));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] billArray = e.getDataEntities();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(billArray.length);
        for (DynamicObject bill : billArray) {
            long billId = DynamicObjectUtils.getPkValue((DynamicObject)bill);
            if (billId == 0L) continue;
            Map<Long, BigDecimal> qtyMap = this.calculateSumVerifiedQtyMap(billId);
            DynamicObjectCollection detailList = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject detailInfo : detailList) {
                if (detailInfo.getBigDecimal("joinqty").compareTo(detailInfo.getBigDecimal("verifiedqty")) <= 0) continue;
                detailInfo.set("joinqty", (Object)qtyMap.get(DynamicObjectUtils.getPkValue((DynamicObject)detailInfo)));
            }
            updateList.add(bill);
        }
        if (CollectionUtil.isNotNull(updateList)) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        }
    }

    private Map<Long, BigDecimal> calculateSumVerifiedQtyMap(long billId) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(8);
        String selectProperties = String.join((CharSequence)",", "sourcebillid", "entrys", "entrys.sourceid", "entrys.sourceentryid", "entrys.verifiedqty");
        QFilter filter = new QFilter("sourcebillid", "=", (Object)String.valueOf(billId));
        DynamicObject[] linkedMcReimburses = BusinessDataServiceHelper.load((String)"ocmem_mc_reimburse", (String)selectProperties, (QFilter[])filter.toArray());
        List linkedMcReimburseList = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])linkedMcReimburses);
        for (DynamicObject mcReimburse : linkedMcReimburseList) {
            DynamicObjectCollection detailList = mcReimburse.getDynamicObjectCollection("entrys");
            for (DynamicObject detail : detailList) {
                BigDecimal sumQty = (BigDecimal)result.get(detail.getLong("sourceentryid"));
                if (sumQty == null) {
                    sumQty = BigDecimal.ZERO;
                }
                sumQty = sumQty.add(detail.getBigDecimal("verifiedqty"));
                result.put(detail.getLong("sourceentryid"), sumQty);
            }
        }
        return result;
    }
}

